/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_mainwindow_list.c - callbacks for the list widget
 */

#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "callbacks_mainwindow_list.h"
#include "callbacks_mainwindow_qsoframe.h"
#include "support.h"
#include "types.h"
#include "utils.h"
#include "log.h"
#include "dxcc.h"

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern statetype state;
extern preferencestype preferences;
extern GList *logwindowlist;

/* a row is selected, update the qso frame */
void
on_log_select_row (GtkTreeSelection *selection, gpointer user_data)
{
	GtkWidget *dateentry, *gmtentry, *endentry, *callentry, *rstentry,
		*myrstentry, *remarksentry, *bandentry, *modeentry, *outcheckbutton,
		*incheckbutton, *powerentry, *nameentry, *qthentry, *locatorentry,
		*unknownentry1, *unknownentry2, *modeoptionmenu, *bandoptionmenu,
		*qsoframe, *framelabel;
	gchar *frametext, *bandcopy, *entry, **bandspl, **modespl;
	guint i, page, bandindex = 0, modeindex = 0;
	GtkTreeModel *model;
	GtkTreeIter iter;
	logtype *logw;

	dateentry = lookup_widget (mainwindow, "dateentry");
	gmtentry = lookup_widget (mainwindow, "gmtentry");
	endentry = lookup_widget (mainwindow, "endentry");
	callentry = lookup_widget (mainwindow, "callentry");
	bandentry = lookup_widget (mainwindow, "bandentry");
	modeentry = lookup_widget (mainwindow, "modeentry");
	rstentry = lookup_widget (mainwindow, "rstentry");
	myrstentry = lookup_widget (mainwindow, "myrstentry");
	remarksentry = lookup_widget (mainwindow, "remarksentry");
	modeoptionmenu = lookup_widget (mainwindow, "modeoptionmenu");
	bandoptionmenu = lookup_widget (mainwindow, "bandoptionmenu");
	outcheckbutton = lookup_widget (mainwindow, "outcheckbutton");
	incheckbutton = lookup_widget (mainwindow, "incheckbutton");
	powerentry = lookup_widget (mainwindow, "powerentry");
	nameentry = lookup_widget (mainwindow, "nameentry");
	qthentry = lookup_widget (mainwindow, "qthentry");
	locatorentry = lookup_widget (mainwindow, "locatorentry");
	unknownentry1 = lookup_widget (mainwindow, "unknownentry1");
	unknownentry2 = lookup_widget (mainwindow, "unknownentry2");

	/* unselect selected QSO's in the other logs */
	page = gtk_notebook_get_current_page (GTK_NOTEBOOK (mainnotebook));
	for (i = 0; i < g_list_length (logwindowlist); i++)
		{
			logw = g_list_nth_data (logwindowlist, i);
			if (page != i)
				gtk_tree_selection_unselect_all (gtk_tree_view_get_selection(GTK_TREE_VIEW (logw->treeview)));
		}

	if (gtk_tree_selection_get_selected (selection, &model, &iter))
	{
		gtk_tree_model_get (model, &iter, NR, &entry, -1);
		qsoframe = lookup_widget (mainwindow, "qsoframe");
		framelabel = gtk_frame_get_label_widget (GTK_FRAME(qsoframe));
		frametext = g_strdup_printf ("QSO %s", entry);
		gtk_label_set_text (GTK_LABEL (framelabel), frametext);
		g_free (frametext);

		gtk_tree_model_get (model, &iter, DATE, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (dateentry), entry);
		gtk_tree_model_get (model, &iter, GMT, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (gmtentry), entry);
		gtk_tree_model_get (model, &iter, GMTEND, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (endentry), entry);

		/* we don't need to convert to uppercase here */
		g_signal_handlers_block_by_func (GTK_OBJECT (callentry), on_callentry_insert_text, user_data);
		gtk_tree_model_get (model, &iter, CALL, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (callentry), entry);
		g_signal_handlers_unblock_by_func (GTK_OBJECT (callentry), on_callentry_insert_text, user_data);

		/* update bandoptionmenu and entry */
		gtk_tree_model_get (model, &iter, BAND, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (bandentry), entry);

		bandspl = g_strsplit (preferences.bands, ",", 0);
		if (strlen (entry) <= 2)
			bandcopy = g_strdup (entry);
		else
			bandcopy = g_strdup(finddot (entry));

		for (;;)
		{
			if (!bandspl[bandindex])
				break;
			if (g_ascii_strcasecmp (bandcopy, bandspl[bandindex]) == 0)
			{
				gtk_combo_box_set_active (GTK_COMBO_BOX (bandoptionmenu), 
					bandindex);
				break;
			}
			bandindex++;
		}
		g_free (bandcopy);
		g_strfreev (bandspl);

		/* update modeoptionmenu and entry */
		gtk_tree_model_get (model, &iter, MODE, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (modeentry), entry);

		modespl = g_strsplit (preferences.modes, ",", 0);
		for (;;)
		{
			if (!modespl[modeindex])
				break;
			if (g_ascii_strcasecmp (entry, modespl[modeindex]) == 0)
				{
					gtk_combo_box_set_active (GTK_COMBO_BOX (modeoptionmenu), 
						modeindex);
					break;
				}
			modeindex++;
		}
		g_strfreev (modespl);

		gtk_tree_model_get (model, &iter, POWER, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (powerentry), entry);
		gtk_tree_model_get (model, &iter, RST, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (rstentry), entry);
		gtk_tree_model_get (model, &iter, MYRST, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (myrstentry), entry);
		gtk_tree_model_get (model, &iter, QSLOUT, &entry, -1);
		if (!g_ascii_strcasecmp (entry, "x") || !g_ascii_strcasecmp (entry, "y"))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outcheckbutton), TRUE);
		else
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (outcheckbutton), FALSE);
		gtk_tree_model_get (model, &iter, QSLIN, &entry, -1);
		if (!g_ascii_strcasecmp (entry, "x") || !g_ascii_strcasecmp (entry, "y"))
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton), TRUE);
		else
			gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (incheckbutton), FALSE);
		gtk_tree_model_get (model, &iter, NAME, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (nameentry), entry);
		gtk_tree_model_get (model, &iter, QTH, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (qthentry), entry);
		gtk_tree_model_get (model, &iter, LOCATOR, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (locatorentry), entry);
		gtk_tree_model_get (model, &iter, U1, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (unknownentry1), entry);
		gtk_tree_model_get (model, &iter, U2, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (unknownentry2), entry);
		gtk_tree_model_get (model, &iter, REMARKS, &entry, -1);
		gtk_entry_set_text (GTK_ENTRY (remarksentry), entry);
	}
}
