/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <sys/types.h>
#include <stdio.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks_mainwindow_menu.h"
#include "callbacks_mainwindow_toolbar.h"
#include "callbacks_mainwindow.h"
#include "callbacks_mainwindow_qsoframe.h"
#include "gui_mainwindow.h"
#include "gui_aboutdialog.h"
#include "gui_b4dialog.h"
#include "gui_closedialog.h"
#include "gui_defaultsdialog.h"
#include "gui_dialogsdialog.h"
#include "gui_dupecheckdialog.h"
#include "gui_openlogdialog.h"
#include "gui_helpdialog.h"
#include "gui_logeditordialog.h"
#include "gui_newlogdialog.h"
#include "gui_printdialog.h"
#include "gui_preferencesdialog.h"
#include "gui_saveasdialog.h"
#include "gui_searchdialog.h"
#include "support.h"
#include "types.h"

#if WANT_HAMLIB
#	include "gui_tracedialog.h"
#endif

GtkWidget *mainwindow, *mainnotebook;
GtkUIManager *ui_manager;
extern preferencestype preferences;

GtkWidget*
create_mainwindow (void)
{
	GtkWidget *mainwindow, *mainvbox, *menubar;
	GdkPixbuf *mainwindow_icon_pixbuf;
	GtkWidget *hpaned;
	GtkWidget *qsomainvbox;
	GtkWidget *handlebox;
	GtkWidget *hbox165;
	GtkWidget *abutton;
	GtkWidget *vbox55;
	GtkWidget *image395;
	GtkWidget *label209;
	GtkWidget *ubutton;
	GtkWidget *vbox56;
	GtkWidget *image396;
	GtkWidget *label210;
	GtkWidget *dbutton;
	GtkWidget *vbox57;
	GtkWidget *image397;
	GtkWidget *label211;
	GtkWidget *qsoscrolledwindow;
	GtkWidget *qsoviewport;
	GtkWidget *qsoframesvbox;
	GtkWidget *qsoframe;
	GtkWidget *qsofieldsvbox;
	GtkWidget *datehbox;
	GtkWidget *datebutton;
	GtkWidget *dateentry;
	GtkWidget *gmthbox;
	GtkWidget *gmtbutton;
	GtkWidget *gmtentry;
	GtkWidget *endhbox;
	GtkWidget *endbutton;
	GtkWidget *endentry;
	GtkWidget *callhbox;
	GtkWidget *calllabel;
	GtkWidget *callentry;
	GtkWidget *bandhbox;
	GtkWidget *mhzhbox;
	GtkWidget *mhzbutton;
	GtkWidget *mhzlabel;
	GtkWidget *bandhbox2;
	GtkWidget *bandentry;
	GtkWidget *modehbox;
	GtkWidget *modehbox1;
	GtkWidget *modebutton;
	GtkWidget *modelabel;
	GtkWidget *modehbox2;
	GtkWidget *modeentry;
	GtkWidget *hrsthbox;
	GtkWidget *hbox39;
	GtkWidget *rstbutton;
	GtkWidget *rstlabel;
	GtkWidget *rstentry;
	GtkWidget *mrsthbox;
	GtkWidget *myrstlabel;
	GtkWidget *myrstentry;
	GtkWidget *qslhbox;
	GtkWidget *outcheckbutton;
	GtkWidget *incheckbutton;
	GtkWidget *powerhbox;
	GtkWidget *hbox74;
	GtkWidget *powerbutton;
	GtkWidget *powerlabel;
	GtkWidget *powerentry;
	GtkWidget *namehbox;
	GtkWidget *namelabel;
	GtkWidget *nameentry;
	GtkWidget *qthhbox;
	GtkWidget *qthlabel;
	GtkWidget *qthentry;
	GtkWidget *locatorhbox;
	GtkWidget *locatorlabel;
	GtkWidget *locatorentry;
	GtkWidget *unknown1hbox;
	GtkWidget *unknownlabel1;
	GtkWidget *unknownentry1;
	GtkWidget *unknown2hbox;
	GtkWidget *unknownlabel2;
	GtkWidget *unknownentry2;
	GtkWidget *remarksvbox;
	GtkWidget *hbox149;
	GtkWidget *remarkslabel;
	GtkWidget *hbox150;
	GtkWidget *remarksentry;
	GtkWidget *label1;
	GtkWidget *dxccframe;
	GtkWidget *dxccvbox;
	GtkWidget *dxcclabel1;
	GtkWidget *dxcclabel2;
	GtkWidget *dxcclabel3;
	GtkWidget *dxcclabel4;
	GtkWidget *dxcclabel5;
	GtkWidget *label2;
	GtkWidget *locatorframe;
	GtkWidget *locatorvbox;
	GtkWidget *locatorlabel1;
	GtkWidget *label3;
	GtkWidget *statushbox;
	GtkWidget *statusbar;
	GtkWidget *frequencyhandlebox;
	GtkWidget *frequencyhbox;
	GtkWidget *frequencypixmap;
	GtkWidget *frequencylabel;
	GtkWidget *smeterhandlebox;
	GtkWidget *smeterhbox;
	GtkWidget *smeterpixmap;
	GtkWidget *smeterdrawingarea;
	GtkWidget *clockhandlebox;
	GtkWidget *clockhbox;
	GtkWidget *clockpixmap;
	GtkWidget *clocklabel;
	GtkAccelGroup *accel_group;
	GtkActionGroup *action_group;
	GtkTooltips *buttontooltips;
	GError *error;
	gint merge_id;
#if !WANT_HAMLIB
	GtkWidget *trace_hamlib;
#endif

/* Normal items */
static GtkActionEntry entries[] = 
{
  { "LogMenu", NULL, N_("_Log") },
  { "EditMenu", NULL, N_("_Edit") },
  { "OptionMenu", NULL, N_("_Options") },
  { "ToolsMenu", NULL, N_("_Tools") },
  { "TabsMenu", NULL, N_("T_abs") },
  { "SettingsMenu", NULL, N_("_Settings") },
  { "HelpMenu", NULL, N_("_Help") },

  { "New", GTK_STOCK_NEW, N_("New..."), "<control>N", "New log", G_CALLBACK(on_menu_new_activate) },
  { "Open", GTK_STOCK_OPEN, N_("Open"), "<control>O", "Open a log", G_CALLBACK(on_menu_open_activate) },
  { "Save", GTK_STOCK_SAVE, N_("Save"), "<control>S", "Save log", G_CALLBACK(on_menu_save_activate) },
  { "Save As", GTK_STOCK_SAVE_AS, N_("Save As..."), "", "Save log as", G_CALLBACK(on_menu_saveas_activate) },
  { "Close", GTK_STOCK_CLOSE, N_("Close"), "<control>Q", "Close log", G_CALLBACK(on_menu_close_activate) },
  { "Print", GTK_STOCK_PRINT, N_("Print"), "<control>P", "Print log", G_CALLBACK(on_menu_print_activate) },
  { "Exit", GTK_STOCK_QUIT, N_("Exit"), "<control>X", "Exit program", G_CALLBACK(on_menu_exit_activate) },

  { "Clear All", GTK_STOCK_CLEAR, N_("Clear All"), "<control>Y", "Clear all fields", G_CALLBACK(on_clearframe_activate) },
  { "Find", GTK_STOCK_FIND, N_("Find"), "<control>F", "Find callsign", G_CALLBACK(on_menu_search_activate) },
  { "Click All", GTK_STOCK_APPLY, N_("Click All"), "<control>K", "Click all buttons", G_CALLBACK(on_clickall_activate) },

  { "Log Editor", GTK_STOCK_PROPERTIES, N_("Log Editor"), "", "Format fields in the log", G_CALLBACK(on_menu_logeditor_activate) },
  { "Dupe Check", GTK_STOCK_COPY, N_("Dupe Check..."), "", "Check the log(s) for dupes", G_CALLBACK(on_menu_dupecheck_activate) },
#if WANT_HAMLIB
  { "Trace Hamlib", GTK_STOCK_EXECUTE, N_("Trace Hamlib"), "", "Show hamlib debugging output", G_CALLBACK(on_trace_hamlib_activate) },
#endif
  { "Sort", GTK_STOCK_SORT_ASCENDING, N_("Sort by Date"), "", "Sort log by date", G_CALLBACK(on_sort_log_activate) },

  { "Defaults", GTK_STOCK_INDEX, N_("Defaults"), "", "Default values to use for logging", G_CALLBACK(on_menu_defaults_activate) },
  { "Dialogs", GTK_STOCK_JUSTIFY_FILL, N_("Dialogs"), "", "Settings for dialogs used", G_CALLBACK(on_menu_dialogs_activate) },
  { "Preferences", GTK_STOCK_PREFERENCES, N_("Preferences..."), "", "Preferences for xlog", G_CALLBACK(on_menu_preferences_activate) },

  { "Documentation", GTK_STOCK_HELP, N_("Documentation"), "", "Important documents", NULL },
  { "About", GTK_STOCK_DIALOG_INFO, N_("About..."), "", "About xlog", G_CALLBACK(on_menu_about_activate) },

  { "Changelog", GTK_STOCK_DIALOG_INFO, N_("Changelog"), "", "Read the changelog", G_CALLBACK(on_helpchangelog_activate) },
  { "Faq", GTK_STOCK_DIALOG_QUESTION, N_("Faq"), "", "Frequently asked quenstions", G_CALLBACK(on_helpfaq_activate) },
  { "Manual", GTK_STOCK_DIALOG_INFO, N_("Manual"), "", "Xlog manual", G_CALLBACK(on_helpmanual_activate) },
  { "Thanks", GTK_STOCK_DIALOG_INFO, N_("Thanks"), "", "Thanks to these hams", G_CALLBACK(on_helpthanks_activate) },
  { "Todo", GTK_STOCK_DIALOG_INFO, N_("Todo"), "", "Things to do for future versions", G_CALLBACK(on_helptodo_activate) },

  { "1", GTK_STOCK_JUMP_TO, "Log 1", "<alt>1", "", G_CALLBACK(on_menu_log_activate) },
  { "2", GTK_STOCK_JUMP_TO, "Log 2", "<alt>2", "", G_CALLBACK(on_menu_log_activate) },
  { "3", GTK_STOCK_JUMP_TO, "Log 3", "<alt>3", "", G_CALLBACK(on_menu_log_activate) },
  { "4", GTK_STOCK_JUMP_TO, "Log 4", "<alt>4", "", G_CALLBACK(on_menu_log_activate) },
  { "5", GTK_STOCK_JUMP_TO, "Log 5", "<alt>5", "", G_CALLBACK(on_menu_log_activate) },
  { "6", GTK_STOCK_JUMP_TO, "Log 6", "<alt>6", "", G_CALLBACK(on_menu_log_activate) },
  { "7", GTK_STOCK_JUMP_TO, "Log 7", "<alt>7", "", G_CALLBACK(on_menu_log_activate) },
  { "8", GTK_STOCK_JUMP_TO, "Log 8", "<alt>8", "", G_CALLBACK(on_menu_log_activate) },
  { "9", GTK_STOCK_JUMP_TO, "Log 9", "<alt>9", "", G_CALLBACK(on_menu_log_activate) },
  { "10", GTK_STOCK_JUMP_TO, "Log 10", "<alt>0", "", G_CALLBACK(on_menu_log_activate) },
};

static GtkToggleActionEntry toggle_entries[] = 
{
  { "ShowToolbar", NULL, N_("Show Toolbar"), "<control>T", "Show/hide the toolbar", G_CALLBACK(on_view_toolbar_activate) },
  { "WorkedBefore", NULL, N_("Worked Before"), "<control>W", "Show/hide the worked before dialog", G_CALLBACK(on_menu_worked_activate) },
};

static const char *ui_description =
"<ui>"
"  <menubar name='MainMenu'>"
"    <menu action='LogMenu'>"
"      <menuitem action='New'/>"
"      <menuitem action='Open'/>"
"      <separator name='sep1'/>"
"      <menuitem action='Save'/>"
"      <menuitem action='Save As'/>"
"      <menuitem action='Close'/>"
"      <separator name='sep2'/>"
"      <menuitem action='Print'/>"
"      <menuitem action='Exit'/>"
"    </menu>"
"    <menu action='EditMenu'>"
"      <menuitem action='Clear All'/>"
"      <menuitem action='Find'/>"
"      <menuitem action='Click All'/>"
"    </menu>"
"    <menu action='OptionMenu'>"
"      <menuitem action='ShowToolbar'/>"
"      <menuitem action='WorkedBefore'/>"
"    </menu>"
"    <menu action='ToolsMenu'>"
"      <menuitem action='Log Editor'/>"
"      <menuitem action='Dupe Check'/>"
#if WANT_HAMLIB
"      <menuitem action='Trace Hamlib'/>"
#endif
"      <menuitem action='Sort'/>"
"    </menu>"
"    <menu action='TabsMenu'>"
"      <menuitem action='1'/>"
"      <menuitem action='2'/>"
"      <menuitem action='3'/>"
"      <menuitem action='4'/>"
"      <menuitem action='5'/>"
"      <menuitem action='6'/>"
"      <menuitem action='7'/>"
"      <menuitem action='8'/>"
"      <menuitem action='9'/>"
"      <menuitem action='10'/>"
"    </menu>"
"    <menu action='SettingsMenu'>"
"      <menuitem action='Defaults'/>"
"      <menuitem action='Dialogs'/>"
"      <separator name='sep'/>"
"      <menuitem action='Preferences'/>"
"    </menu>"
"    <menu action='HelpMenu'>"
"      <menu action='Documentation'>"
"        <menuitem action='Changelog'/>"
"        <menuitem action='Faq'/>"
"        <menuitem action='Manual'/>"
"        <menuitem action='Thanks'/>"
"        <menuitem action='Todo'/>"
"      </menu>"
"      <separator name='sep'/>"
"      <menuitem action='About'/>"
"    </menu>"
"  </menubar>"
"</ui>";

	mainwindow = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_set_events (mainwindow, GDK_KEY_PRESS_MASK | GDK_KEY_RELEASE_MASK);
	gtk_window_set_title (GTK_WINDOW (mainwindow), "xlog");
	mainwindow_icon_pixbuf = create_pixbuf ("xlog.png");
	if (mainwindow_icon_pixbuf)
	{
		gtk_window_set_icon (GTK_WINDOW (mainwindow), mainwindow_icon_pixbuf);
		g_object_unref (mainwindow_icon_pixbuf);
	}

	mainvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (mainvbox);
	gtk_container_add (GTK_CONTAINER (mainwindow), mainvbox);

	action_group = gtk_action_group_new ("MenuActions");
	gtk_action_group_set_translation_domain (action_group, PACKAGE);
	gtk_action_group_add_actions (action_group, entries,
		G_N_ELEMENTS (entries), mainwindow);

	if (preferences.viewtoolbar == 1)
		toggle_entries[0].is_active = TRUE;
	if (preferences.viewb4 == 1)
		toggle_entries[1].is_active = TRUE;
	gtk_action_group_add_toggle_actions (action_group,
		toggle_entries, G_N_ELEMENTS (toggle_entries), mainwindow);

	ui_manager = gtk_ui_manager_new ();
	gtk_ui_manager_insert_action_group (ui_manager, action_group, 0);

	accel_group = gtk_ui_manager_get_accel_group (ui_manager);
	gtk_window_add_accel_group (GTK_WINDOW (mainwindow), accel_group);

	error = NULL;
	merge_id = gtk_ui_manager_add_ui_from_string 
		(ui_manager, ui_description, -1, &error);
	if (!merge_id)
	{
		g_message ("building menus failed: %s", error->message);
		g_error_free (error);
		return (NULL);
	}
	menubar = gtk_ui_manager_get_widget (ui_manager, "/MainMenu");
	gtk_box_pack_start (GTK_BOX (mainvbox), menubar, FALSE, FALSE, 0);
	gtk_widget_show (menubar);

#if !WANT_HAMLIB
	trace_hamlib = gtk_ui_manager_get_widget (ui_manager,
		"/MainMenu/ToolsMenu/Trace Hamlib");
	gtk_widget_hide (trace_hamlib);
#endif

	hpaned = gtk_hpaned_new ();
	gtk_widget_show (hpaned);
	gtk_box_pack_start (GTK_BOX (mainvbox), hpaned, TRUE, TRUE, 0);
	gtk_paned_set_position (GTK_PANED (hpaned), 0);

	qsomainvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (qsomainvbox);
	gtk_paned_pack1 (GTK_PANED (hpaned), qsomainvbox, FALSE, FALSE);

	handlebox = gtk_handle_box_new ();
	gtk_widget_show (handlebox);
	gtk_box_pack_start (GTK_BOX (qsomainvbox), handlebox, FALSE, FALSE, 0);

	hbox165 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox165);
	gtk_container_add (GTK_CONTAINER (handlebox), hbox165);

	buttontooltips = gtk_tooltips_new ();
	abutton = gtk_button_new ();
	gtk_widget_show (abutton);
	gtk_box_pack_start (GTK_BOX (hbox165), abutton, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (buttontooltips, abutton, 
		_("Add a new QSO to the log [Ctrl-A]"), NULL);
	gtk_widget_add_accelerator (abutton, "clicked", accel_group, GDK_a, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	vbox55 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox55);
	gtk_container_add (GTK_CONTAINER (abutton), vbox55);

	image395 = gtk_image_new_from_stock ("gtk-add", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image395);
	gtk_box_pack_start (GTK_BOX (vbox55), image395, TRUE, TRUE, 0);

	label209 = gtk_label_new (_("Add"));
	gtk_widget_show (label209);
	gtk_box_pack_start (GTK_BOX (vbox55), label209, FALSE, FALSE, 0);

	ubutton = gtk_button_new ();
	gtk_widget_show (ubutton);
	gtk_box_pack_start (GTK_BOX (hbox165), ubutton, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (buttontooltips, ubutton, 
		_("Update a modified log entry [Ctrl-U]"), NULL);
	gtk_widget_add_accelerator (ubutton, "clicked", accel_group, GDK_u, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	vbox56 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox56);
	gtk_container_add (GTK_CONTAINER (ubutton), vbox56);

	image396 = gtk_image_new_from_stock ("gtk-refresh", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image396);
	gtk_box_pack_start (GTK_BOX (vbox56), image396, TRUE, TRUE, 0);

	label210 = gtk_label_new (_("Update"));
	gtk_widget_show (label210);
	gtk_box_pack_start (GTK_BOX (vbox56), label210, FALSE, FALSE, 0);

	dbutton = gtk_button_new ();
	gtk_widget_show (dbutton);
	gtk_box_pack_start (GTK_BOX (hbox165), dbutton, TRUE, TRUE, 0);
	gtk_tooltips_set_tip (buttontooltips, dbutton, 
		_("Delete a selected log entry [Ctrl-D]"), NULL);
	gtk_widget_add_accelerator (dbutton, "clicked", accel_group, GDK_d, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE);

	vbox57 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox57);
	gtk_container_add (GTK_CONTAINER (dbutton), vbox57);

	image397 = gtk_image_new_from_stock ("gtk-remove", GTK_ICON_SIZE_BUTTON);
	gtk_widget_show (image397);
	gtk_box_pack_start (GTK_BOX (vbox57), image397, TRUE, TRUE, 0);

	label211 = gtk_label_new (_("Delete"));
	gtk_widget_show (label211);
	gtk_box_pack_start (GTK_BOX (vbox57), label211, FALSE, FALSE, 0);

	qsoscrolledwindow = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_show (qsoscrolledwindow);
	gtk_box_pack_start (GTK_BOX (qsomainvbox), qsoscrolledwindow, TRUE, TRUE, 0);
	GTK_WIDGET_UNSET_FLAGS (qsoscrolledwindow, GTK_CAN_FOCUS);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (qsoscrolledwindow), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	qsoviewport = gtk_viewport_new (NULL, NULL);
	gtk_widget_show (qsoviewport);
	gtk_container_add (GTK_CONTAINER (qsoscrolledwindow), qsoviewport);
	gtk_viewport_set_shadow_type (GTK_VIEWPORT (qsoviewport), GTK_SHADOW_NONE);

	qsoframesvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (qsoframesvbox);
	gtk_container_add (GTK_CONTAINER (qsoviewport), qsoframesvbox);

	qsoframe = gtk_frame_new (NULL);
	gtk_widget_show (qsoframe);
	gtk_box_pack_start (GTK_BOX (qsoframesvbox), qsoframe, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (qsoframe), 2);
	gtk_frame_set_label_align (GTK_FRAME (qsoframe), 0.5, 0.5);

	qsofieldsvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (qsofieldsvbox);
	gtk_container_add (GTK_CONTAINER (qsoframe), qsofieldsvbox);
	gtk_container_set_border_width (GTK_CONTAINER (qsofieldsvbox), 4);

	datehbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (datehbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), datehbox, FALSE, FALSE, 0);

	datebutton = gtk_button_new_with_mnemonic (_("Date"));
	gtk_widget_show (datebutton);
	gtk_box_pack_start (GTK_BOX (datehbox), datebutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (datebutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (datebutton), 2);

	dateentry = gtk_entry_new ();
	gtk_widget_show (dateentry);
	gtk_box_pack_start (GTK_BOX (datehbox), dateentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (dateentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (dateentry), 15);

	gmthbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (gmthbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), gmthbox, FALSE, FALSE, 0);

	gmtbutton = gtk_button_new_with_mnemonic ("GMT");
	gtk_widget_show (gmtbutton);
	gtk_box_pack_start (GTK_BOX (gmthbox), gmtbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (gmtbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (gmtbutton), 2);

	gmtentry = gtk_entry_new ();
	gtk_widget_show (gmtentry);
	gtk_box_pack_start (GTK_BOX (gmthbox), gmtentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (gmtentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (gmtentry), 8);

	endhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (endhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), endhbox, FALSE, FALSE, 0);

	endbutton = gtk_button_new_with_mnemonic (_("End (GMT)"));
	gtk_widget_show (endbutton);
	gtk_box_pack_start (GTK_BOX (endhbox), endbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (endbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (endbutton), 2);

	endentry = gtk_entry_new ();
	gtk_widget_show (endentry);
	gtk_box_pack_start (GTK_BOX (endhbox), endentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (endentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (endentry), 8);

	callhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (callhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), callhbox, FALSE, FALSE, 0);

	calllabel = gtk_label_new (_("Call"));
	gtk_widget_show (calllabel);
	gtk_box_pack_start (GTK_BOX (callhbox), calllabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (calllabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (calllabel), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (calllabel), 10, 0);

	callentry = gtk_entry_new ();
	gtk_widget_show (callentry);
	gtk_box_pack_start (GTK_BOX (callhbox), callentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (callentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (callentry), 15);

	bandhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (bandhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), bandhbox, FALSE, FALSE, 0);

	mhzhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (mhzhbox);
	gtk_box_pack_start (GTK_BOX (bandhbox), mhzhbox, FALSE, FALSE, 0);

	mhzbutton = gtk_button_new_with_mnemonic ("MHz");
	gtk_widget_show (mhzbutton);
	gtk_box_pack_start (GTK_BOX (mhzhbox), mhzbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (mhzbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (mhzbutton), 2);

	mhzlabel = gtk_label_new ("MHz");
	gtk_widget_show (mhzlabel);
	gtk_box_pack_start (GTK_BOX (mhzhbox), mhzlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (mhzlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (mhzlabel), GTK_JUSTIFY_CENTER);

	bandhbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (bandhbox2);
	gtk_box_pack_start (GTK_BOX (bandhbox), bandhbox2, TRUE, TRUE, 0);
	GLADE_HOOKUP_OBJECT (mainwindow, bandhbox2, "bandhbox2");

	bandentry = gtk_entry_new ();
	gtk_widget_show (bandentry);
	gtk_box_pack_start (GTK_BOX (bandhbox2), bandentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (bandentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (bandentry), 15);

	modehbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (modehbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), modehbox, FALSE, FALSE, 0);

	modehbox1 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (modehbox1);
	gtk_box_pack_start (GTK_BOX (modehbox), modehbox1, FALSE, FALSE, 0);

	modebutton = gtk_button_new_with_mnemonic (_("Mode"));
	gtk_widget_show (modebutton);
	gtk_box_pack_start (GTK_BOX (modehbox1), modebutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (modebutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (modebutton), 2);

	modelabel = gtk_label_new (_("Mode"));
	gtk_widget_show (modelabel);
	gtk_box_pack_start (GTK_BOX (modehbox1), modelabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (modelabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (modelabel), GTK_JUSTIFY_CENTER);

	modehbox2 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (modehbox2);
	gtk_box_pack_start (GTK_BOX (modehbox), modehbox2, TRUE, TRUE, 0);
	GLADE_HOOKUP_OBJECT (mainwindow, modehbox2, "modehbox2");

	modeentry = gtk_entry_new ();
	gtk_widget_show (modeentry);
	gtk_box_pack_start (GTK_BOX (modehbox2), modeentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (modeentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (modeentry), 8);

	hrsthbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hrsthbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), hrsthbox, FALSE, FALSE, 0);

	hbox39 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox39);
	gtk_box_pack_start (GTK_BOX (hrsthbox), hbox39, FALSE, FALSE, 0);

	rstbutton = gtk_button_new_with_mnemonic ("TX(RST)");
	gtk_widget_show (rstbutton);
	gtk_box_pack_start (GTK_BOX (hbox39), rstbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (rstbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (rstbutton), 2);

	rstlabel = gtk_label_new ("TX(RST)");
	gtk_widget_show (rstlabel);
	gtk_box_pack_start (GTK_BOX (hbox39), rstlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (rstlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (rstlabel), GTK_JUSTIFY_CENTER);

	rstentry = gtk_entry_new ();
	gtk_widget_show (rstentry);
	gtk_box_pack_start (GTK_BOX (hrsthbox), rstentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (rstentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (rstentry), 15);

	mrsthbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (mrsthbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), mrsthbox, FALSE, FALSE, 0);

	myrstlabel = gtk_label_new ("RX(RST)");
	gtk_widget_show (myrstlabel);
	gtk_box_pack_start (GTK_BOX (mrsthbox), myrstlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (myrstlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (myrstlabel), GTK_JUSTIFY_CENTER);

	myrstentry = gtk_entry_new ();
	gtk_widget_show (myrstentry);
	gtk_box_pack_start (GTK_BOX (mrsthbox), myrstentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (myrstentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (myrstentry), 15);

	qslhbox = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (qslhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), qslhbox, FALSE, FALSE, 0);

	outcheckbutton = gtk_check_button_new_with_mnemonic (_("QSL out"));
	gtk_widget_show (outcheckbutton);
	gtk_box_pack_start (GTK_BOX (qslhbox), outcheckbutton, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (outcheckbutton, GTK_CAN_FOCUS);

	incheckbutton = gtk_check_button_new_with_mnemonic (_("QSL in"));
	gtk_widget_show (incheckbutton);
	gtk_box_pack_start (GTK_BOX (qslhbox), incheckbutton, FALSE, FALSE, 0);
	GTK_WIDGET_UNSET_FLAGS (incheckbutton, GTK_CAN_FOCUS);

	powerhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (powerhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), powerhbox, FALSE, FALSE, 0);

	hbox74 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox74);
	gtk_box_pack_start (GTK_BOX (powerhbox), hbox74, FALSE, FALSE, 0);

	powerbutton = gtk_button_new_with_mnemonic (_("Power"));
	gtk_widget_show (powerbutton);
	gtk_box_pack_start (GTK_BOX (hbox74), powerbutton, FALSE, FALSE, 0);
	gtk_widget_set_size_request (powerbutton, 100, 31);
	gtk_container_set_border_width (GTK_CONTAINER (powerbutton), 2);

	powerlabel = gtk_label_new (_("Power"));
	gtk_widget_show (powerlabel);
	gtk_box_pack_start (GTK_BOX (hbox74), powerlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (powerlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (powerlabel), GTK_JUSTIFY_CENTER);

	powerentry = gtk_entry_new ();
	gtk_widget_show (powerentry);
	gtk_box_pack_start (GTK_BOX (powerhbox), powerentry, FALSE, FALSE, 0);
	gtk_widget_set_size_request (powerentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (powerentry), 8);

	namehbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (namehbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), namehbox, FALSE, FALSE, 0);

	namelabel = gtk_label_new (_("Name"));
	gtk_widget_show (namelabel);
	gtk_box_pack_start (GTK_BOX (namehbox), namelabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (namelabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (namelabel), GTK_JUSTIFY_CENTER);

	nameentry = gtk_entry_new ();
	gtk_widget_show (nameentry);
	gtk_box_pack_start (GTK_BOX (namehbox), nameentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (nameentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (nameentry), 30);

	qthhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (qthhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), qthhbox, FALSE, FALSE, 0);

	qthlabel = gtk_label_new ("QTH");
	gtk_widget_show (qthlabel);
	gtk_box_pack_start (GTK_BOX (qthhbox), qthlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (qthlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (qthlabel), GTK_JUSTIFY_CENTER);

	qthentry = gtk_entry_new ();
	gtk_widget_show (qthentry);
	gtk_box_pack_start (GTK_BOX (qthhbox), qthentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (qthentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (qthentry), 30);

	locatorhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (locatorhbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), locatorhbox, FALSE, FALSE, 0);

	locatorlabel = gtk_label_new (_("Locator"));
	gtk_widget_show (locatorlabel);
	gtk_box_pack_start (GTK_BOX (locatorhbox), locatorlabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (locatorlabel, 100, 17);
	gtk_label_set_justify (GTK_LABEL (locatorlabel), GTK_JUSTIFY_CENTER);

	locatorentry = gtk_entry_new ();
	gtk_widget_show (locatorentry);
	gtk_box_pack_start (GTK_BOX (locatorhbox), locatorentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (locatorentry, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (locatorentry), 8);

	unknown1hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (unknown1hbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), unknown1hbox, FALSE, FALSE, 0);

	unknownlabel1 = gtk_label_new ("");
	gtk_widget_show (unknownlabel1);
	gtk_box_pack_start (GTK_BOX (unknown1hbox), unknownlabel1, FALSE, FALSE, 0);
	gtk_widget_set_size_request (unknownlabel1, 100, 17);
	gtk_label_set_justify (GTK_LABEL (unknownlabel1), GTK_JUSTIFY_CENTER);

	unknownentry1 = gtk_entry_new ();
	gtk_widget_show (unknownentry1);
	gtk_box_pack_start (GTK_BOX (unknown1hbox), unknownentry1, TRUE, TRUE, 0);
	gtk_widget_set_size_request (unknownentry1, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (unknownentry1), 30);

	unknown2hbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (unknown2hbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), unknown2hbox, FALSE, FALSE, 0);

	unknownlabel2 = gtk_label_new ("");
	gtk_widget_show (unknownlabel2);
	gtk_box_pack_start (GTK_BOX (unknown2hbox), unknownlabel2, FALSE, FALSE, 0);
	gtk_widget_set_size_request (unknownlabel2, 100, 17);
	gtk_label_set_justify (GTK_LABEL (unknownlabel2), GTK_JUSTIFY_CENTER);

	unknownentry2 = gtk_entry_new ();
	gtk_widget_show (unknownentry2);
	gtk_box_pack_start (GTK_BOX (unknown2hbox), unknownentry2, TRUE, TRUE, 0);
	gtk_widget_set_size_request (unknownentry2, 130, 25);
	gtk_entry_set_max_length (GTK_ENTRY (unknownentry2), 30);

	remarksvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (remarksvbox);
	gtk_box_pack_start (GTK_BOX (qsofieldsvbox), remarksvbox, FALSE, FALSE, 0);

	hbox149 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox149);
	gtk_box_pack_start (GTK_BOX (remarksvbox), hbox149, FALSE, FALSE, 0);

	remarkslabel = gtk_label_new (_("Remarks"));
	gtk_widget_show (remarkslabel);
	gtk_box_pack_start (GTK_BOX (hbox149), remarkslabel, FALSE, FALSE, 0);
	gtk_widget_set_size_request (remarkslabel, 230, 17);
	gtk_label_set_justify (GTK_LABEL (remarkslabel), GTK_JUSTIFY_CENTER);

	hbox150 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox150);
	gtk_box_pack_start (GTK_BOX (remarksvbox), hbox150, FALSE, FALSE, 0);

	remarksentry = gtk_entry_new ();
	gtk_widget_show (remarksentry);
	gtk_box_pack_start (GTK_BOX (hbox150), remarksentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (remarksentry, 230, 25);
	gtk_widget_set_events (remarksentry, GDK_FOCUS_CHANGE_MASK);
	gtk_entry_set_max_length (GTK_ENTRY (remarksentry), 80);

	label1 = gtk_label_new (_("New QSO"));
	gtk_widget_show (label1);
	gtk_frame_set_label_widget (GTK_FRAME (qsoframe), label1);

	dxccframe = gtk_frame_new (NULL);
	gtk_widget_show (dxccframe);
	gtk_box_pack_start (GTK_BOX (qsoframesvbox), dxccframe, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (dxccframe), 2);
	gtk_frame_set_label_align (GTK_FRAME (dxccframe), 0.5, 0.5);

	dxccvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (dxccvbox);
	gtk_container_add (GTK_CONTAINER (dxccframe), dxccvbox);

	dxcclabel1 = gtk_label_new ("");
	gtk_widget_show (dxcclabel1);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel1), GTK_JUSTIFY_CENTER);

	dxcclabel2 = gtk_label_new ("");
	gtk_widget_show (dxcclabel2);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel2, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel2), GTK_JUSTIFY_CENTER);

	dxcclabel3 = gtk_label_new ("");
	gtk_widget_show (dxcclabel3);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel3, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel3), GTK_JUSTIFY_CENTER);

	dxcclabel4 = gtk_label_new ("");
	gtk_widget_show (dxcclabel4);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel4, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel4), GTK_JUSTIFY_CENTER);

	dxcclabel5 = gtk_label_new ("");
	gtk_widget_show (dxcclabel5);
	gtk_box_pack_start (GTK_BOX (dxccvbox), dxcclabel5, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (dxcclabel5), GTK_JUSTIFY_CENTER);

	label2 = gtk_label_new ("DXCC");
	gtk_widget_show (label2);
	gtk_frame_set_label_widget (GTK_FRAME (dxccframe), label2);

	locatorframe = gtk_frame_new (NULL);
	gtk_widget_show (locatorframe);
	gtk_box_pack_start (GTK_BOX (qsoframesvbox), locatorframe, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (locatorframe), 2);
	gtk_frame_set_label_align (GTK_FRAME (locatorframe), 0.5, 0.5);

	locatorvbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (locatorvbox);
	gtk_container_add (GTK_CONTAINER (locatorframe), locatorvbox);

	locatorlabel1 = gtk_label_new ("");
	gtk_widget_show (locatorlabel1);
	gtk_box_pack_start (GTK_BOX (locatorvbox), locatorlabel1, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (locatorlabel1), GTK_JUSTIFY_CENTER);

	label3 = gtk_label_new (_("Locator"));
	gtk_widget_show (label3);
	gtk_frame_set_label_widget (GTK_FRAME (locatorframe), label3);

	statushbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (statushbox);
	gtk_box_pack_start (GTK_BOX (mainvbox), statushbox, FALSE, FALSE, 0);

	statusbar = gtk_statusbar_new ();
	gtk_widget_show (statusbar);
	gtk_box_pack_start (GTK_BOX (statushbox), statusbar, TRUE, TRUE, 0);
	gtk_statusbar_set_has_resize_grip (GTK_STATUSBAR (statusbar), FALSE);

	frequencyhandlebox = gtk_handle_box_new ();
	gtk_widget_show (frequencyhandlebox);
	gtk_box_pack_start (GTK_BOX (statushbox), frequencyhandlebox, FALSE, FALSE, 0);

	frequencyhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (frequencyhbox);
	gtk_container_add (GTK_CONTAINER (frequencyhandlebox), frequencyhbox);

	frequencypixmap = create_pixmap (mainwindow, "mini-trx.xpm");
	gtk_widget_show (frequencypixmap);
	gtk_box_pack_start (GTK_BOX (frequencyhbox), frequencypixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (frequencypixmap), 5, 0);

	frequencylabel = gtk_label_new ("");
	gtk_widget_show (frequencylabel);
	gtk_box_pack_start (GTK_BOX (frequencyhbox), frequencylabel, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (frequencylabel), 5, 0);

	smeterhandlebox = gtk_handle_box_new ();
	gtk_widget_show (smeterhandlebox);
	gtk_box_pack_start (GTK_BOX (statushbox), smeterhandlebox, FALSE, FALSE, 0);

	smeterhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (smeterhbox);
	gtk_container_add (GTK_CONTAINER (smeterhandlebox), smeterhbox);
	gtk_container_set_border_width (GTK_CONTAINER (smeterhbox), 2);

	smeterpixmap = create_pixmap (mainwindow, "s.xpm");
	gtk_widget_show (smeterpixmap);
	gtk_box_pack_start (GTK_BOX (smeterhbox), smeterpixmap, FALSE, FALSE, 0);

	smeterdrawingarea = gtk_drawing_area_new ();
	gtk_widget_show (smeterdrawingarea);
	gtk_box_pack_start (GTK_BOX (smeterhbox), smeterdrawingarea, TRUE, TRUE, 0);
	gtk_widget_set_size_request (smeterdrawingarea, 144, 20);

	clockhandlebox = gtk_handle_box_new ();
	gtk_widget_show (clockhandlebox);
	gtk_box_pack_start (GTK_BOX (statushbox), clockhandlebox, FALSE, FALSE, 0);

	clockhbox = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (clockhbox);
	gtk_container_add (GTK_CONTAINER (clockhandlebox), clockhbox);

	clockpixmap = create_pixmap (mainwindow, "mini-clock.xpm");
	gtk_widget_show (clockpixmap);
	gtk_box_pack_start (GTK_BOX (clockhbox), clockpixmap, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (clockpixmap), 5, 0);

	clocklabel = gtk_label_new ("");
	gtk_widget_show (clocklabel);
	gtk_box_pack_start (GTK_BOX (clockhbox), clocklabel, FALSE, FALSE, 0);
	gtk_misc_set_padding (GTK_MISC (clocklabel), 5, 0);

	g_signal_connect ((gpointer) mainwindow, "delete_event", G_CALLBACK (on_mainwindow_delete_event), NULL);

	g_signal_connect ((gpointer) abutton, "clicked", G_CALLBACK (on_abutton_clicked), NULL);
	g_signal_connect ((gpointer) ubutton, "clicked", G_CALLBACK (on_ubutton_clicked), NULL);
	g_signal_connect ((gpointer) dbutton, "clicked", G_CALLBACK (on_dbutton_clicked), NULL);
	g_signal_connect ((gpointer) datebutton, "clicked", G_CALLBACK (on_datebutton_clicked), NULL);
	g_signal_connect ((gpointer) gmtbutton, "clicked", G_CALLBACK (on_gmtbutton_clicked), NULL);
	g_signal_connect ((gpointer) endbutton, "clicked", G_CALLBACK (on_endbutton_clicked), NULL);
	g_signal_connect ((gpointer) callentry, "insert_text", G_CALLBACK (on_callentry_insert_text), NULL);
	g_signal_connect ((gpointer) callentry, "changed", G_CALLBACK (on_callentry_changed), NULL);
	g_signal_connect ((gpointer) locatorentry, "changed", G_CALLBACK (on_locatorentry_changed), NULL);


	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (mainwindow, mainwindow, "mainwindow");
	
	GLADE_HOOKUP_OBJECT (mainwindow, handlebox, "handlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, hpaned, "hpaned");
	GLADE_HOOKUP_OBJECT (mainwindow, qsoframe, "qsoframe");
	GLADE_HOOKUP_OBJECT (mainwindow, datebutton, "datebutton");
	GLADE_HOOKUP_OBJECT (mainwindow, dateentry, "dateentry");
	GLADE_HOOKUP_OBJECT (mainwindow, gmtbutton, "gmtbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, gmtentry, "gmtentry");
	GLADE_HOOKUP_OBJECT (mainwindow, endhbox, "endhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, endbutton, "endbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, endentry, "endentry");
	GLADE_HOOKUP_OBJECT (mainwindow, calllabel, "calllabel");
	GLADE_HOOKUP_OBJECT (mainwindow, callentry, "callentry");
	GLADE_HOOKUP_OBJECT (mainwindow, mhzbutton, "mhzbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, mhzlabel, "mhzlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, bandentry, "bandentry");
	GLADE_HOOKUP_OBJECT (mainwindow, modebutton, "modebutton");
	GLADE_HOOKUP_OBJECT (mainwindow, modelabel, "modelabel");
	GLADE_HOOKUP_OBJECT (mainwindow, modeentry, "modeentry");
	GLADE_HOOKUP_OBJECT (mainwindow, rstbutton, "rstbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, rstlabel, "rstlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, rstentry, "rstentry");
	GLADE_HOOKUP_OBJECT (mainwindow, myrstlabel, "myrstlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, myrstentry, "myrstentry");
	GLADE_HOOKUP_OBJECT (mainwindow, qslhbox, "qslhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, outcheckbutton, "outcheckbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, incheckbutton, "incheckbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, powerhbox, "powerhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, powerbutton, "powerbutton");
	GLADE_HOOKUP_OBJECT (mainwindow, powerlabel, "powerlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, powerentry, "powerentry");
	GLADE_HOOKUP_OBJECT (mainwindow, namehbox, "namehbox");
	GLADE_HOOKUP_OBJECT (mainwindow, namelabel, "namelabel");
	GLADE_HOOKUP_OBJECT (mainwindow, nameentry, "nameentry");
	GLADE_HOOKUP_OBJECT (mainwindow, qthhbox, "qthhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, qthlabel, "qthlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, qthentry, "qthentry");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorhbox, "locatorhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorlabel, "locatorlabel");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorentry, "locatorentry");
	GLADE_HOOKUP_OBJECT (mainwindow, unknown1hbox, "unknown1hbox");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownlabel1, "unknownlabel1");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownentry1, "unknownentry1");
	GLADE_HOOKUP_OBJECT (mainwindow, unknown2hbox, "unknown2hbox");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownlabel2, "unknownlabel2");
	GLADE_HOOKUP_OBJECT (mainwindow, unknownentry2, "unknownentry2");
	GLADE_HOOKUP_OBJECT (mainwindow, remarksvbox, "remarksvbox");
	GLADE_HOOKUP_OBJECT (mainwindow, remarkslabel, "remarkslabel");
	GLADE_HOOKUP_OBJECT (mainwindow, remarksentry, "remarksentry");

	GLADE_HOOKUP_OBJECT (mainwindow, dxccframe, "dxccframe");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel1, "dxcclabel1");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel2, "dxcclabel2");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel3, "dxcclabel3");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel4, "dxcclabel4");
	GLADE_HOOKUP_OBJECT (mainwindow, dxcclabel5, "dxcclabel5");

	GLADE_HOOKUP_OBJECT (mainwindow, locatorframe, "locatorframe");
	GLADE_HOOKUP_OBJECT (mainwindow, locatorlabel1, "locatorlabel1");

	GLADE_HOOKUP_OBJECT (mainwindow, statusbar, "statusbar");
	GLADE_HOOKUP_OBJECT (mainwindow, frequencyhandlebox, "frequencyhandlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, frequencylabel, "frequencylabel");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterhandlebox, "smeterhandlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterhbox, "smeterhbox");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterpixmap, "smeterpixmap");
	GLADE_HOOKUP_OBJECT (mainwindow, smeterdrawingarea, "smeterdrawingarea");
	GLADE_HOOKUP_OBJECT (mainwindow, clockhandlebox, "clockhandlebox");
	GLADE_HOOKUP_OBJECT (mainwindow, clocklabel, "clocklabel");

	return mainwindow;
}
