/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "callbacks_printdialog.h"
#include "gui_printdialog.h"
#include "support.h"
#include "types.h"
#include "log.h"

GtkWidget *printdialog;

extern GtkWidget *mainwindow;
extern GtkWidget *mainnotebook;
extern preferencestype preferences;
extern GList *logwindowlist;


void
on_menu_print_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	GtkWidget *printallradiobutton, *printrangeradiobutton, *printlowentry,
		*printhighentry, *printrangelabel, *filedestinationradiobutton, 
		*printerdestinationradiobutton;
	GtkWidget *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9, *p10,
		*p11, *p12, *p13, *p14, *p15, *p16, *p17, *p18;
	gchar *temp;
	GtkTreeViewColumn *column;
	logtype *logwindow;
	gint page;
	GdkPixbuf *printdialog_icon_pixbuf;
	GtkWidget *dialog_vbox5;
	GtkWidget *vbox51;
	GtkWidget *hbox163;
	GtkWidget *vbox52;
	GtkWidget *frame2;
	GtkWidget *vbox7;
	GSList *printallradiobutton_group = NULL;
	GtkWidget *hbox19;
	GtkWidget *label177;
	GtkWidget *frame6;
	GtkWidget *vbox11;
	GSList *printerdestinationradiobutton_group = NULL;
	GtkWidget *label179;
	GtkWidget *frame3;
	GtkWidget *vbox8;
	GtkWidget *hbox17;
	GtkWidget *label14;
	GtkWidget *papersizecombo;
	GtkWidget *hbox18;
	GtkWidget *label15;
	GtkWidget *pointsizecombo;
	GtkWidget *hbox162;
	GtkWidget *label204;
	GtkWidget *orientationcombo;
	GtkWidget *label178;
	GtkWidget *frame22;
	GtkWidget *hbox164;
	GtkWidget *vbox53;
	GtkWidget *vbox54;
	GtkWidget *label207;
	GtkWidget *frame23;
	GtkWidget *contestcheckbutton;
	GtkWidget *label208;
	GtkWidget *dialog_action_area5;
	GtkWidget *printcancelbutton;
	GtkWidget *printokbutton;

	page = gtk_notebook_get_current_page (GTK_NOTEBOOK(mainnotebook));
	if (page >= 0)
	{


	printdialog = gtk_dialog_new ();
	gtk_window_set_title (GTK_WINDOW (printdialog), _("xlog - print"));
	gtk_window_set_position (GTK_WINDOW (printdialog), GTK_WIN_POS_MOUSE);
	printdialog_icon_pixbuf = create_pixbuf ("xlog.png");
	if (printdialog_icon_pixbuf)
		{
			gtk_window_set_icon (GTK_WINDOW (printdialog), printdialog_icon_pixbuf);
			g_object_unref (printdialog_icon_pixbuf);
		}

	dialog_vbox5 = GTK_DIALOG (printdialog)->vbox;
	gtk_widget_show (dialog_vbox5);

	vbox51 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox51);
	gtk_box_pack_start (GTK_BOX (dialog_vbox5), vbox51, TRUE, TRUE, 0);

	hbox163 = gtk_hbox_new (FALSE, 0);
	gtk_widget_show (hbox163);
	gtk_box_pack_start (GTK_BOX (vbox51), hbox163, TRUE, TRUE, 0);

	vbox52 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox52);
	gtk_box_pack_start (GTK_BOX (hbox163), vbox52, TRUE, TRUE, 0);

	frame2 = gtk_frame_new (NULL);
	gtk_widget_show (frame2);
	gtk_box_pack_start (GTK_BOX (vbox52), frame2, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame2), 5);

	vbox7 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox7);
	gtk_container_add (GTK_CONTAINER (frame2), vbox7);

	printallradiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Print all QSO's"));
	gtk_widget_show (printallradiobutton);
	gtk_box_pack_start (GTK_BOX (vbox7), printallradiobutton, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (printallradiobutton), 5);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (printallradiobutton), printallradiobutton_group);
	printallradiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (printallradiobutton));

	hbox19 = gtk_hbox_new (FALSE, 2);
	gtk_widget_show (hbox19);
	gtk_box_pack_start (GTK_BOX (vbox7), hbox19, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox19), 5);

	printrangeradiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Print QSO"));
	gtk_widget_show (printrangeradiobutton);
	gtk_box_pack_start (GTK_BOX (hbox19), printrangeradiobutton, TRUE, TRUE, 0);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (printrangeradiobutton), printallradiobutton_group);
	printallradiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (printrangeradiobutton));

	printlowentry = gtk_entry_new ();
	gtk_widget_show (printlowentry);
	gtk_box_pack_start (GTK_BOX (hbox19), printlowentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (printlowentry, 50, 23);
	gtk_entry_set_max_length (GTK_ENTRY (printlowentry), 8);

	printrangelabel = gtk_label_new (_("To"));
	gtk_widget_show (printrangelabel);
	gtk_box_pack_start (GTK_BOX (hbox19), printrangelabel, FALSE, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (printrangelabel), GTK_JUSTIFY_CENTER);
	gtk_misc_set_padding (GTK_MISC (printrangelabel), 5, 0);

	printhighentry = gtk_entry_new ();
	gtk_widget_show (printhighentry);
	gtk_box_pack_start (GTK_BOX (hbox19), printhighentry, TRUE, TRUE, 0);
	gtk_widget_set_size_request (printhighentry, 50, 23);
	gtk_entry_set_max_length (GTK_ENTRY (printhighentry), 8);

	label177 = gtk_label_new (_("Range"));
	gtk_widget_show (label177);
	gtk_frame_set_label_widget (GTK_FRAME (frame2), label177);

	frame6 = gtk_frame_new (NULL);
	gtk_widget_show (frame6);
	gtk_box_pack_start (GTK_BOX (vbox52), frame6, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame6), 5);

	vbox11 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox11);
	gtk_container_add (GTK_CONTAINER (frame6), vbox11);

	printerdestinationradiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("Printer"));
	gtk_widget_show (printerdestinationradiobutton);
	gtk_box_pack_start (GTK_BOX (vbox11), printerdestinationradiobutton, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (printerdestinationradiobutton), 5);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (printerdestinationradiobutton), printerdestinationradiobutton_group);
	printerdestinationradiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (printerdestinationradiobutton));

	filedestinationradiobutton = gtk_radio_button_new_with_mnemonic (NULL, _("File"));
	gtk_widget_show (filedestinationradiobutton);
	gtk_box_pack_start (GTK_BOX (vbox11), filedestinationradiobutton, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (filedestinationradiobutton), 5);
	gtk_radio_button_set_group (GTK_RADIO_BUTTON (filedestinationradiobutton), printerdestinationradiobutton_group);
	printerdestinationradiobutton_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (filedestinationradiobutton));

	label179 = gtk_label_new (_("Destination"));
	gtk_widget_show (label179);
	gtk_frame_set_label_widget (GTK_FRAME (frame6), label179);

	frame3 = gtk_frame_new (NULL);
	gtk_widget_show (frame3);
	gtk_box_pack_start (GTK_BOX (hbox163), frame3, TRUE, TRUE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (frame3), 5);

	vbox8 = gtk_vbox_new (TRUE, 0);
	gtk_widget_show (vbox8);
	gtk_container_add (GTK_CONTAINER (frame3), vbox8);

	hbox17 = gtk_hbox_new (TRUE, 5);
	gtk_widget_show (hbox17);
	gtk_box_pack_start (GTK_BOX (vbox8), hbox17, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox17), 5);

	label14 = gtk_label_new (_("Papersize"));
	gtk_widget_show (label14);
	gtk_box_pack_start (GTK_BOX (hbox17), label14, TRUE, TRUE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label14), TRUE);

	papersizecombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (papersizecombo);
	gtk_box_pack_start (GTK_BOX (hbox17), papersizecombo, TRUE, TRUE, 0);
	gtk_widget_set_size_request (papersizecombo, 80, -1);
	gtk_combo_box_append_text (GTK_COMBO_BOX (papersizecombo), "a4");
	gtk_combo_box_append_text (GTK_COMBO_BOX (papersizecombo), "letter");
	gtk_editable_set_editable (GTK_EDITABLE (GTK_BIN(papersizecombo)->child), FALSE);

	hbox18 = gtk_hbox_new (TRUE, 5);
	gtk_widget_show (hbox18);
	gtk_box_pack_start (GTK_BOX (vbox8), hbox18, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox18), 5);

	label15 = gtk_label_new (_("Pointsize"));
	gtk_widget_show (label15);
	gtk_box_pack_start (GTK_BOX (hbox18), label15, TRUE, TRUE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label15), TRUE);

	pointsizecombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (pointsizecombo);
	gtk_box_pack_start (GTK_BOX (hbox18), pointsizecombo, TRUE, TRUE, 0);
	gtk_widget_set_size_request (pointsizecombo, 80, -1);
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "6");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "7");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "8");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "9");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "10");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "11");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "12");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "13");
	gtk_combo_box_append_text (GTK_COMBO_BOX (pointsizecombo), "14");
	gtk_editable_set_editable (GTK_EDITABLE (GTK_BIN(pointsizecombo)->child),
		FALSE);

	hbox162 = gtk_hbox_new (TRUE, 5);
	gtk_widget_show (hbox162);
	gtk_box_pack_start (GTK_BOX (vbox8), hbox162, FALSE, FALSE, 0);
	gtk_container_set_border_width (GTK_CONTAINER (hbox162), 5);

	label204 = gtk_label_new (_("Orientation"));
	gtk_widget_show (label204);
	gtk_box_pack_start (GTK_BOX (hbox162), label204, TRUE, TRUE, 0);
	gtk_label_set_line_wrap (GTK_LABEL (label204), TRUE);

	orientationcombo = gtk_combo_box_entry_new_text ();
	gtk_widget_show (orientationcombo);
	gtk_box_pack_start (GTK_BOX (hbox162), orientationcombo, TRUE, TRUE, 0);
	gtk_widget_set_size_request (orientationcombo, 80, -1);
	gtk_combo_box_append_text (GTK_COMBO_BOX (orientationcombo), _("portrait"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (orientationcombo), _("landscape"));
	gtk_editable_set_editable (GTK_EDITABLE (GTK_BIN(orientationcombo)->child),
		FALSE);

	label178 = gtk_label_new (_("Paper"));
	gtk_widget_show (label178);
	gtk_frame_set_label_widget (GTK_FRAME (frame3), label178);

	frame22 = gtk_frame_new (NULL);
	gtk_widget_show (frame22);
	gtk_box_pack_start (GTK_BOX (vbox51), frame22, TRUE, TRUE, 0);

	hbox164 = gtk_hbox_new (TRUE, 0);
	gtk_widget_show (hbox164);
	gtk_container_add (GTK_CONTAINER (frame22), hbox164);

	vbox53 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox53);
	gtk_box_pack_start (GTK_BOX (hbox164), vbox53, TRUE, TRUE, 0);

	p1 = gtk_check_button_new_with_mnemonic (_("QSO Number"));
	gtk_widget_show (p1);
	gtk_box_pack_start (GTK_BOX (vbox53), p1, FALSE, FALSE, 0);

	p2 = gtk_check_button_new_with_mnemonic (_("Date"));
	gtk_widget_show (p2);
	gtk_box_pack_start (GTK_BOX (vbox53), p2, FALSE, FALSE, 0);

	p3 = gtk_check_button_new_with_mnemonic ("GMT");
	gtk_widget_show (p3);
	gtk_box_pack_start (GTK_BOX (vbox53), p3, FALSE, FALSE, 0);

	p4 = gtk_check_button_new_with_mnemonic (_("GMT - end"));
	gtk_widget_show (p4);
	gtk_box_pack_start (GTK_BOX (vbox53), p4, FALSE, FALSE, 0);

	p5 = gtk_check_button_new_with_mnemonic (_("Call"));
	gtk_widget_show (p5);
	gtk_box_pack_start (GTK_BOX (vbox53), p5, FALSE, FALSE, 0);

	p6 = gtk_check_button_new_with_mnemonic (_("Frequency"));
	gtk_widget_show (p6);
	gtk_box_pack_start (GTK_BOX (vbox53), p6, FALSE, FALSE, 0);

	p7 = gtk_check_button_new_with_mnemonic (_("Mode"));
	gtk_widget_show (p7);
	gtk_box_pack_start (GTK_BOX (vbox53), p7, FALSE, FALSE, 0);

	p8 = gtk_check_button_new_with_mnemonic ("TX(RST)");
	gtk_widget_show (p8);
	gtk_box_pack_start (GTK_BOX (vbox53), p8, FALSE, FALSE, 0);

	p9 = gtk_check_button_new_with_mnemonic ("RX(RST)");
	gtk_widget_show (p9);
	gtk_box_pack_start (GTK_BOX (vbox53), p9, FALSE, FALSE, 0);

	vbox54 = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox54);
	gtk_box_pack_start (GTK_BOX (hbox164), vbox54, TRUE, TRUE, 0);

	p10 = gtk_check_button_new_with_mnemonic (_("Qsl Out"));
	gtk_widget_show (p10);
	gtk_box_pack_start (GTK_BOX (vbox54), p10, FALSE, FALSE, 0);

	p11 = gtk_check_button_new_with_mnemonic (_("Qsl In"));
	gtk_widget_show (p11);
	gtk_box_pack_start (GTK_BOX (vbox54), p11, FALSE, FALSE, 0);

	p12 = gtk_check_button_new_with_mnemonic (_("Power"));
	gtk_widget_show (p12);
	gtk_box_pack_start (GTK_BOX (vbox54), p12, FALSE, FALSE, 0);

	p13 = gtk_check_button_new_with_mnemonic (_("Name"));
	gtk_widget_show (p13);
	gtk_box_pack_start (GTK_BOX (vbox54), p13, FALSE, FALSE, 0);

	p14 = gtk_check_button_new_with_mnemonic ("QTH");
	gtk_widget_show (p14);
	gtk_box_pack_start (GTK_BOX (vbox54), p14, FALSE, FALSE, 0);

	p15 = gtk_check_button_new_with_mnemonic (_("Locator"));
	gtk_widget_show (p15);
	gtk_box_pack_start (GTK_BOX (vbox54), p15, FALSE, FALSE, 0);

	p16 = gtk_check_button_new_with_mnemonic (_("Freefield1"));
	gtk_widget_show (p16);
	gtk_box_pack_start (GTK_BOX (vbox54), p16, FALSE, FALSE, 0);

	p17 = gtk_check_button_new_with_mnemonic (_("Freefield2"));
	gtk_widget_show (p17);
	gtk_box_pack_start (GTK_BOX (vbox54), p17, FALSE, FALSE, 0);

	p18 = gtk_check_button_new_with_mnemonic (_("Remarks"));
	gtk_widget_show (p18);
	gtk_box_pack_start (GTK_BOX (vbox54), p18, FALSE, FALSE, 0);

	label207 = gtk_label_new (_("Columns"));
	gtk_widget_show (label207);
	gtk_frame_set_label_widget (GTK_FRAME (frame22), label207);

	frame23 = gtk_frame_new (NULL);
	gtk_widget_show (frame23);
	gtk_box_pack_start (GTK_BOX (vbox51), frame23, TRUE, TRUE, 0);

	contestcheckbutton = gtk_check_button_new_with_mnemonic (_("Add empty Multiplier and Points columns"));
	gtk_widget_show (contestcheckbutton);
	gtk_container_add (GTK_CONTAINER (frame23), contestcheckbutton);

	label208 = gtk_label_new (_("Contests"));
	gtk_widget_show (label208);
	gtk_frame_set_label_widget (GTK_FRAME (frame23), label208);

	dialog_action_area5 = GTK_DIALOG (printdialog)->action_area;
	gtk_widget_show (dialog_action_area5);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area5), GTK_BUTTONBOX_SPREAD);

	printcancelbutton = gtk_button_new_from_stock ("gtk-cancel");
	gtk_widget_show (printcancelbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (printdialog), printcancelbutton, GTK_RESPONSE_CANCEL);
	GTK_WIDGET_SET_FLAGS (printcancelbutton, GTK_CAN_DEFAULT);

	printokbutton = gtk_button_new_from_stock ("gtk-ok");
	gtk_widget_show (printokbutton);
	gtk_dialog_add_action_widget (GTK_DIALOG (printdialog), printokbutton, GTK_RESPONSE_OK);
	GTK_WIDGET_SET_FLAGS (printokbutton, GTK_CAN_DEFAULT);

	g_signal_connect ((gpointer) printdialog, "delete_event", G_CALLBACK (on_printdialog_delete_event), NULL);
	g_signal_connect ((gpointer) printcancelbutton, "clicked", G_CALLBACK (on_printcancelbutton_clicked), NULL);
	g_signal_connect ((gpointer) printokbutton, "clicked", G_CALLBACK (on_printokbutton_clicked), NULL);

	/* Store pointers to all widgets, for use by lookup_widget(). */
	GLADE_HOOKUP_OBJECT_NO_REF (printdialog, printdialog, "printdialog");
	GLADE_HOOKUP_OBJECT (printdialog, printallradiobutton, "printallradiobutton");
	GLADE_HOOKUP_OBJECT (printdialog, printrangeradiobutton, "printrangeradiobutton");
	GLADE_HOOKUP_OBJECT (printdialog, printlowentry, "printlowentry");
	GLADE_HOOKUP_OBJECT (printdialog, printrangelabel, "printrangelabel");
	GLADE_HOOKUP_OBJECT (printdialog, printhighentry, "printhighentry");
	GLADE_HOOKUP_OBJECT (printdialog, printerdestinationradiobutton, "printerdestinationradiobutton");
	GLADE_HOOKUP_OBJECT (printdialog, filedestinationradiobutton, "filedestinationradiobutton");
	GLADE_HOOKUP_OBJECT (printdialog, papersizecombo, "papersizecombo");
	GLADE_HOOKUP_OBJECT (printdialog, pointsizecombo, "pointsizecombo");
	GLADE_HOOKUP_OBJECT (printdialog, orientationcombo, "orientationcombo");
	GLADE_HOOKUP_OBJECT (printdialog, p1, "p1");
	GLADE_HOOKUP_OBJECT (printdialog, p2, "p2");
	GLADE_HOOKUP_OBJECT (printdialog, p3, "p3");
	GLADE_HOOKUP_OBJECT (printdialog, p4, "p4");
	GLADE_HOOKUP_OBJECT (printdialog, p5, "p5");
	GLADE_HOOKUP_OBJECT (printdialog, p6, "p6");
	GLADE_HOOKUP_OBJECT (printdialog, p7, "p7");
	GLADE_HOOKUP_OBJECT (printdialog, p8, "p8");
	GLADE_HOOKUP_OBJECT (printdialog, p9, "p9");
	GLADE_HOOKUP_OBJECT (printdialog, p10, "p10");
	GLADE_HOOKUP_OBJECT (printdialog, p11, "p11");
	GLADE_HOOKUP_OBJECT (printdialog, p12, "p12");
	GLADE_HOOKUP_OBJECT (printdialog, p13, "p13");
	GLADE_HOOKUP_OBJECT (printdialog, p14, "p14");
	GLADE_HOOKUP_OBJECT (printdialog, p15, "p15");
	GLADE_HOOKUP_OBJECT (printdialog, p16, "p16");
	GLADE_HOOKUP_OBJECT (printdialog, p17, "p17");
	GLADE_HOOKUP_OBJECT (printdialog, p18, "p18");
	GLADE_HOOKUP_OBJECT (printdialog, contestcheckbutton, "contestcheckbutton");

	gtk_button_set_label (GTK_BUTTON (p16), preferences.freefield1);
	gtk_button_set_label (GTK_BUTTON (p17), preferences.freefield2);

	g_signal_handlers_block_by_func (GTK_OBJECT (printrangeradiobutton),
		on_printradiobutton_toggled, user_data);
	if (preferences.printall == 0)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printallradiobutton),
					TRUE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printrangeradiobutton),
					FALSE);
		gtk_widget_set_sensitive (printlowentry, 0);
		gtk_widget_set_sensitive (printhighentry, 0);
		gtk_widget_set_sensitive (printrangelabel, 0);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printallradiobutton),
					FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (printrangeradiobutton),
					TRUE);
		gtk_widget_set_sensitive (printlowentry, 1);
		gtk_widget_set_sensitive (printhighentry, 1);
		gtk_widget_set_sensitive (printrangelabel, 1);
	}
	g_signal_handlers_unblock_by_func (GTK_OBJECT (printrangeradiobutton),
		on_printradiobutton_toggled, user_data);

	if (preferences.printdestination == 0)
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(printerdestinationradiobutton), TRUE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(filedestinationradiobutton), FALSE);
	}
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(printerdestinationradiobutton), FALSE);
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON
					(filedestinationradiobutton), TRUE);
	}

	logwindow = g_list_nth_data (logwindowlist, page);

	temp = g_strdup_printf ("1");
	gtk_entry_set_text (GTK_ENTRY (printlowentry), temp);
	temp = g_strdup_printf ("%d", logwindow->qsos);
	gtk_entry_set_text (GTK_ENTRY (printhighentry), temp);
	g_free (temp);

	if (preferences.printsize == 0)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(papersizecombo)->child), "a4");
	else
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(papersizecombo)->child), "letter");

	if (preferences.printpoint == 0)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "10");
	else if (preferences.printpoint == 1)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "11");
	else if (preferences.printpoint == 2)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "12");
	else if (preferences.printpoint == 3)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "13");
	else if (preferences.printpoint == 4)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "14");
	else if (preferences.printpoint == 5)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "6");
	else if (preferences.printpoint == 6)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "7");
	else if (preferences.printpoint == 7)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "8");
	else if (preferences.printpoint == 8)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(pointsizecombo)->child), "9");

	if (preferences.printorientation == 0)
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(orientationcombo)->child),
			_("portrait"));
	else
		gtk_entry_set_text (GTK_ENTRY (GTK_BIN(orientationcombo)->child),
			_("landscape"));

	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), NR);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p1), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p1), FALSE);
		gtk_widget_set_sensitive (p1, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), DATE);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p2), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p2), FALSE);
		gtk_widget_set_sensitive (p2, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), GMT);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p3), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p3), FALSE);
		gtk_widget_set_sensitive (p3, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), GMTEND);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p4), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p4), FALSE);
		gtk_widget_set_sensitive (p4, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), CALL);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p5), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p5), FALSE);
		gtk_widget_set_sensitive (p5, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), BAND);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p6), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p6), FALSE);
		gtk_widget_set_sensitive (p6, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), MODE);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p7), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p7), FALSE);
		gtk_widget_set_sensitive (p7, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), RST);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p8), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p8), FALSE);
		gtk_widget_set_sensitive (p8, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), MYRST);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p9), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p9), FALSE);
		gtk_widget_set_sensitive (p9, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), QSLOUT);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p10), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p10), FALSE);
		gtk_widget_set_sensitive (p10, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), QSLIN);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p11), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p11), FALSE);
		gtk_widget_set_sensitive (p11, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), POWER);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p12), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p12), FALSE);
		gtk_widget_set_sensitive (p12, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), NAME);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p13), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p13), FALSE);
		gtk_widget_set_sensitive (p13, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), QTH);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p14), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p14), FALSE);
		gtk_widget_set_sensitive (p14, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), LOCATOR);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p15), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p15), FALSE);
		gtk_widget_set_sensitive (p15, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), U1);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p16), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p16), FALSE);
		gtk_widget_set_sensitive (p16, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), U2);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p17), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p17), FALSE);
		gtk_widget_set_sensitive (p17, 0);
	}
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (logwindow->treeview), REMARKS);
	if (gtk_tree_view_column_get_visible (GTK_TREE_VIEW_COLUMN(column)))
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p18), TRUE);
	else
	{
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(p18), FALSE);
		gtk_widget_set_sensitive (p18, 0);
	}

	g_signal_connect (G_OBJECT (printallradiobutton), "toggled",
		G_CALLBACK (on_printradiobutton_toggled), "1");
	g_signal_connect (G_OBJECT (printrangeradiobutton), "toggled",
		G_CALLBACK (on_printradiobutton_toggled), "2");

	gtk_widget_set_sensitive (mainwindow, 0);
	gtk_widget_show (printdialog);
	}
}
