/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2004 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * labels.c - support for glabels, export some fields in a TAB separated way
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "logfile.h"
#include "types.h"


/*
 * file fields
 */
static gint labels_open (LOGDB *);
static void labels_close (LOGDB *);
static gint labels_create (LOGDB *);
static gint labels_qso_append (LOGDB *, const qso_t *);
static gint labels_qso_foreach (LOGDB *,
	gint (*fn) (LOGDB *, qso_t *, gpointer arg), gpointer arg);

extern preferencestype preferences;

const struct log_ops labels_ops = {
	.open = labels_open,
	.close = labels_close,
	.create = labels_create,
	.qso_append = labels_qso_append,
	.qso_foreach = labels_qso_foreach,
	.type = TYPE_LABELS,
	.name = "Labels",
	.extension = ".labels",
};

/*
 * open for read
 */
gint
labels_open (LOGDB * handle)
{
	FILE *fp;

	fp = fopen (handle->path, "r");
	if (!fp)
		return -1;
	handle->priv = (gpointer) fp;

	return 0;
}

/*
 * open for write
 */
gint
labels_create (LOGDB * handle)
{
	FILE *fp;

	fp = fopen (handle->path, "w");
	if (!fp)
		return -1;
	handle->priv = (gpointer) fp;
	return 0;
}

void
labels_close (LOGDB * handle)
{
	FILE *fp = (FILE *) handle->priv;
	fclose (fp);
}

gint
labels_qso_append (LOGDB * handle, const qso_t * q)
{
	FILE *fp = (FILE *) handle->priv;

	if (preferences.saveaslabels == 0)
		fprintf (fp, "%s\t%s\t%s\t%s\t%s\t%s\n",
			q[DATE], q[GMT], q[CALL], q[BAND], q[MODE], q[RST]);
	else if (preferences.saveaslabels == 1)
		fprintf (fp, "%s\t%s\t%s\t%s\t%s\t%s\t%s\n",
			q[DATE], q[GMT], q[CALL], q[BAND], q[MODE], q[RST], q[U1]);
	else if (preferences.saveaslabels == 2)
		fprintf (fp, "%s\t%s\t%s\t%s\t%s\t%s\t%s\n",
			q[DATE], q[GMT], q[CALL], q[BAND], q[MODE], q[RST], q[U2]);
	else
		fprintf (fp, "%s\t%s\t%s\t%s\t%s\t%s\t%s\t%s\n",
			q[DATE], q[GMT], q[CALL], q[BAND], q[MODE], q[RST], q[U1], q[U2]);
	return 0;
}

gint labels_qso_foreach 
(LOGDB * handle, gint (*fn) (LOGDB *, qso_t *, gpointer arg), gpointer arg)
{
	return 1;
}
