/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * filename: xfilesel.c                                                    *
 *                                                                         *
 * UTIL C-source: Medical Image Conversion Utility                         *
 *                                                                         *
 * purpose      : file selection routines                                  *
 *                                                                         *
 * project      : (X)MedCon by Erik Nolf                                   *
 *                                                                         *
 * Note         : basic code extracted from Gtk+ tutorial                  *
 *                                                                         *
 * Functions    : XMdcFileSelOpenCallbackOk()       - Open Ok callback     *
 *                XMdcFileSelOpen()                 - Open file selection  *
 *                XMdcFileSelSaveCreateFormatMenu() - Create Format menu   *
 *                XMdcFileSelSaveCreateDefaultName()- Create Default name  *
 *                XMdcFileSelSaveCallbackAlias()    - Get alias   filename *
 *                XMdcFileSelSaveCallbackDefault()  - Get default filename *
 *                XMdcFileSelSaveCallbackCancel()   - Save Cancel callback *
 *                XMdcFileSelSaveCallbackOk()       - Save Ok     callback *
 *                XMdcFileSelSave()                 - Save file selection  *
 *                XMdcLutSelOpenCallbackOk()        - LUT Open Ok callback *
 *                XMdcLutSelOpen()                  - LUT open file        *
 *                XMdcRawPredefSelSaveCallbackOk()  - Raw Predef Save Ok   *
 *                XMdcRawPredefSelSave()            - Raw Predef Save      *
 *                XMdcRawPredefSelOpenCallbackOk()  - Raw Predef Load Ok   *
 *                XMdcRawPredefSelOpen()            - Raw Predef Load      * 
 *                                                                         *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* $Id: xfilesel.c,v 1.32 2007/06/20 22:06:36 enlf Exp $
 */

/*
   Copyright (C) 1997-2007 by Erik Nolf

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   59 Place - Suite 330, Boston, MA 02111-1307, USA.  */

/****************************************************************************
                              H E A D E R S
****************************************************************************/

#include "m-depend.h"

#include <stdio.h>
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#ifndef _WIN32
#include <strings.h>
#endif
#endif

#include "xmedcon.h"

/****************************************************************************
                              D E F I N E S
****************************************************************************/

static guint format_to_use[MDC_MAX_FRMTS], mitem_nr[MDC_MAX_FRMTS];
static guint OPEN_TYPE=XMDC_NORMAL;
static GtkWidget *ofilew=NULL, *sfilew=NULL, *olutw=NULL, *formatmenu=NULL;
static GtkWidget *opredefw=NULL, *spredefw=NULL;
static GtkWidget *default_name=NULL;

/****************************************************************************
                            F U N C T I O N S
****************************************************************************/

/* Get the selected filename and display */
void XMdcFileSelOpenCallbackOk(GtkWidget *w, GtkWidget *fs)
{
    char *fname;

    if (OPEN_TYPE == XMDC_RAW) {

      XMdcRawReadInteractive(fs);

    }else if(OPEN_TYPE == XMDC_PREDEF) {

      XMdcRawReadPredef(fs);

    }else{

      XMdcMainWidgetsInsensitive();

      fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));

      XMdcDisplayFile(fname);

      XMdcMainWidgetsResensitive();

   }
}

void XMdcFileSelOpen(GtkWidget *widget, guint otype)
{
 
    OPEN_TYPE = otype;

    if (ofilew == NULL) {

      /* Create a new file selection widget */
      ofilew = gtk_file_selection_new ("Open File");
    
      gtk_signal_connect(GTK_OBJECT (ofilew), "destroy",
                         GTK_SIGNAL_FUNC(XMdcMedconQuit), NULL); 
      gtk_signal_connect(GTK_OBJECT (ofilew), "delete_event",
                         GTK_SIGNAL_FUNC(XMdcHandlerToHide), NULL);

      /* Connect the ok_button to file_ok_sel function */
      gtk_signal_connect_object(
         GTK_OBJECT(GTK_FILE_SELECTION(ofilew)->ok_button), 
         "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(ofilew));
      gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION (ofilew)->ok_button),
         "clicked", GTK_SIGNAL_FUNC(XMdcFileSelOpenCallbackOk),ofilew);

      /* Connect the cancel_button to hide the widget */
      gtk_signal_connect_object(GTK_OBJECT 
         (GTK_FILE_SELECTION (ofilew)->cancel_button),
         "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(ofilew));
    }

    if (OPEN_TYPE == XMDC_RAW) {
      gtk_window_set_title(GTK_WINDOW(ofilew),"Open RAW File (interactive)");
    }else if (OPEN_TYPE == XMDC_PREDEF) {
      gtk_window_set_title(GTK_WINDOW(ofilew),"Open RAW File (predefined)");
    }else{
      gtk_window_set_title(GTK_WINDOW(ofilew),"Open File");
    }

    /* Lets set the filename, as if this were a save dialog, and we are giving
      a default filename */
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(ofilew), 
				     "<unknown>");
    XMdcShowWidget(ofilew);

    switch (XMDC_FILE_TYPE) {
      case XMDC_RAW    : XMdcDisplayWarn("RAW file was not saved");
          break;
      case XMDC_PREDEF : XMdcDisplayWarn("RAW file was not saved");
          break;
      case XMDC_EXTRACT: XMdcDisplayWarn("Extracted images were not saved");
          break;
      case XMDC_RESLICE: XMdcDisplayWarn("Resliced images not saved");
          break;
      case XMDC_TRANSF : XMdcDisplayWarn("Transformed images not saved");
          break;
      case XMDC_EDITFI : XMdcDisplayWarn("Changed FileInfo not saved");
          break;
    }
}

void XMdcFileSelSaveCreateFormatMenu(GtkWidget *fs, guint format)
{
    GtkWidget *menu=NULL;
    GtkWidget *menuitem; 
    guint item=0, selected=0;
    Uint8 LOOK=MDC_YES;

    formatmenu = gtk_option_menu_new();
    menu = gtk_menu_new();

    memset(format_to_use,MDC_FRMT_NONE,MDC_MAX_FRMTS);
    memset(mitem_nr,-1,MDC_MAX_FRMTS);

/* format Raw Binary */
    if (LOOK && (format == MDC_FRMT_RAW)) {
      XMDC_WRITE_FRMT = MDC_FRMT_RAW; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_RAW]=MDC_FRMT_RAW;
    mitem_nr[MDC_FRMT_RAW] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_RAW]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_RAW]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);

/* format Raw Ascii */
    if (LOOK && (format == MDC_FRMT_ASCII)) {
     XMDC_WRITE_FRMT  = MDC_FRMT_ASCII; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_ASCII]=MDC_FRMT_ASCII;
    mitem_nr[MDC_FRMT_ASCII] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_ASCII]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_ASCII]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);

#if MDC_INCLUDE_ACR
    if (LOOK && (format == MDC_FRMT_ACR)) {
      XMDC_WRITE_FRMT = MDC_FRMT_ACR; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_ACR]=MDC_FRMT_ACR;
    mitem_nr[MDC_FRMT_ACR] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_ACR]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_ACR]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_ANLZ
    if (LOOK && (format == MDC_FRMT_ANLZ)) {
      XMDC_WRITE_FRMT = MDC_FRMT_ANLZ; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_ANLZ]=MDC_FRMT_ANLZ;
    mitem_nr[MDC_FRMT_ANLZ] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_ANLZ]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_ANLZ]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_CONC
    if (LOOK && (format == MDC_FRMT_CONC)) {
      XMDC_WRITE_FRMT = MDC_FRMT_CONC; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_CONC]=MDC_FRMT_CONC;
    mitem_nr[MDC_FRMT_CONC] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_CONC]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_CONC]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_DICM
    if (LOOK && (format == MDC_FRMT_DICM)) {
      XMDC_WRITE_FRMT = MDC_FRMT_DICM; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_DICM]=MDC_FRMT_DICM;
    mitem_nr[MDC_FRMT_DICM] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_DICM]);
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                       &format_to_use[MDC_FRMT_DICM]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_ECAT
    if (LOOK && (format == MDC_FRMT_ECAT6)) {
      XMDC_WRITE_FRMT = MDC_FRMT_ECAT6; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_ECAT6]=MDC_FRMT_ECAT6;
    mitem_nr[MDC_FRMT_ECAT6] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_ECAT6]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_ECAT6]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
  #if MDC_INCLUDE_TPC
    if (LOOK && (format == MDC_FRMT_ECAT7)) {
      XMDC_WRITE_FRMT = MDC_FRMT_ECAT7; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_ECAT7]=MDC_FRMT_ECAT7;
    mitem_nr[MDC_FRMT_ECAT7] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_ECAT7]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_ECAT7]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
  #endif
#endif
#if MDC_INCLUDE_GIF
    if (LOOK && (format == MDC_FRMT_GIF)) {
      XMDC_WRITE_FRMT = MDC_FRMT_GIF; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_GIF]=MDC_FRMT_GIF;
    mitem_nr[MDC_FRMT_GIF] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_GIF]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_GIF]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_INTF
    if (LOOK && (format == MDC_FRMT_INTF)) {
      XMDC_WRITE_FRMT = MDC_FRMT_INTF; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_INTF]=MDC_FRMT_INTF;
    mitem_nr[MDC_FRMT_INTF] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_INTF]);

    gtk_signal_connect( GTK_OBJECT(menuitem), "activate",
                        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                        &format_to_use[MDC_FRMT_INTF]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_INW
    if (LOOK && (format == MDC_FRMT_INW)) {
      XMDC_WRITE_FRMT = MDC_FRMT_INW; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_INW]=MDC_FRMT_INW;
    mitem_nr[MDC_FRMT_INW] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_INW]);
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                       &format_to_use[MDC_FRMT_INW]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_NIFTI
    if (LOOK && (format == MDC_FRMT_NIFTI)) {
      XMDC_WRITE_FRMT = MDC_FRMT_NIFTI; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_NIFTI]=MDC_FRMT_NIFTI;
    mitem_nr[MDC_FRMT_NIFTI] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_NIFTI]);
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                       &format_to_use[MDC_FRMT_NIFTI]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif
#if MDC_INCLUDE_PNG
    if (LOOK && (format == MDC_FRMT_PNG)) {
      XMDC_WRITE_FRMT = MDC_FRMT_PNG; LOOK = MDC_NO; selected = item;
    }
    format_to_use[MDC_FRMT_PNG]=MDC_FRMT_PNG;
    mitem_nr[MDC_FRMT_PNG] = item++;

    menuitem = gtk_menu_item_new_with_label(FrmtString[MDC_FRMT_PNG]);
    gtk_signal_connect(GTK_OBJECT(menuitem), "activate",
                       GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackFormatMenu),
                       &format_to_use[MDC_FRMT_PNG]);

    gtk_menu_append(GTK_MENU(menu),menuitem);
    gtk_widget_show(menuitem);
#endif

    if (LOOK) XMdcDisplayFatalErr(MDC_BAD_CODE,"Unexpected format to save");

    XMdcFileSelSaveCreateDefaultName(fs);

    gtk_option_menu_set_menu(GTK_OPTION_MENU(formatmenu),menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(formatmenu),selected);
    gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(fs)->action_area),
                       formatmenu,FALSE,FALSE,0);
    gtk_widget_show(formatmenu);

}

void XMdcFileSelSaveCreateDefaultName(GtkWidget *fs)
{

  MdcDefaultName(my.fi,XMDC_WRITE_FRMT,my.fi->ofname,my.fi->ifname);

  gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs),my.fi->ofname);
 
} 
  

void XMdcFileSelSaveCallbackFormatMenu(GtkWidget *fs, guint *selected_format)
{
   XMDC_WRITE_FRMT = (Int8)(*selected_format);

   XMdcFileSelSaveCreateDefaultName(sfilew);
}

void XMdcFileSelSaveCallbackAlias(GtkObject *fs, char *filename)
{
  Int8 prev = MDC_ALIAS_NAME;

  MDC_ALIAS_NAME = MDC_YES;

  MdcDefaultName(my.fi,XMDC_WRITE_FRMT,my.fi->ofname,my.fi->ifname);

  gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs),my.fi->ofname);

  MDC_ALIAS_NAME = prev;
}
   
void XMdcFileSelSaveCallbackDefault(GtkObject *fs, char *filename)
{
  MdcDefaultName(my.fi,XMDC_WRITE_FRMT,my.fi->ofname,my.fi->ifname);
  gtk_file_selection_set_filename(GTK_FILE_SELECTION(fs),my.fi->ofname);
}

void XMdcFileSelSaveCallbackCancel(GtkWidget *widget, GtkWidget *fs)
{
   write_counter-=1;
}

void XMdcFileSelSaveCallbackOk(GtkWidget *widget, GtkWidget *fs)
{

  strcpy(my.fi->opath,gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs)));

   MdcSplitPath(my.fi->opath,my.fi->odir,my.fi->ofname);
   if (my.fi->ofname[0] == '\0') {
     XMdcDisplayErr("No file specified");
     write_counter-=1;
     return;
   }
   MdcMergePath(my.fi->opath,my.fi->odir,my.fi->ofname);

   if (XMdcWriteFile(XMDC_WRITE_FRMT)) {
     if (XMDC_FILE_TYPE >= XMDC_UNSAVED) XMDC_FILE_TYPE = XMDC_SAVED;
   }

   XMdcProgressBar(MDC_PROGRESS_END,0.,NULL);

}

void XMdcFileSelSave(GtkWidget *widget, guint format)
{
   GtkWidget *button;

   GtkWidget *menu=NULL;
   GtkWidget *active=NULL;
   guint nr=mitem_nr[format];

   nr = (format < MDC_MAX_FRMTS) ? mitem_nr[format] : 1;

   if (XMdcNoFileOpened()) return;

   MdcPrefix((signed)write_counter++);

   if (sfilew == NULL) {

     /* first call "Save": no format set before */
     /* so we use default value this first time */
     if (format == MDC_MAX_FRMTS) format = XMDC_DEFAULT_FRMT;

     /* Create a new file selection widget */
     sfilew = gtk_file_selection_new ("Save File");

     gtk_signal_connect(GTK_OBJECT(sfilew), "destroy",
                        GTK_SIGNAL_FUNC(XMdcMedconQuit), NULL);

     gtk_signal_connect(GTK_OBJECT(sfilew), "delete_event",
                        GTK_SIGNAL_FUNC(XMdcHandlerToHide), NULL);

     /* Connect the ok_button to file_ok_sel function */
     gtk_signal_connect_object(
        GTK_OBJECT(GTK_FILE_SELECTION (sfilew)->ok_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(sfilew));
     gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION (sfilew)->ok_button), 
        "clicked", GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackOk), sfilew);

     /* Connect the cancel_button to hide the widget, decrease counter */
     gtk_signal_connect_object(
        GTK_OBJECT(GTK_FILE_SELECTION (sfilew)->cancel_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(sfilew));
     gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION (sfilew)->cancel_button), 
        "clicked", GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackCancel), NULL);

     XMdcFileSelSaveCreateFormatMenu(sfilew,format);

     button = gtk_button_new_with_label("Alias Name");
     gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackAlias), GTK_OBJECT(sfilew));
     gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(sfilew)->action_area),
                        button, TRUE, TRUE, 0);
     gtk_widget_show(button);

     button = gtk_button_new_with_label("Default Name");
     gtk_signal_connect_object(GTK_OBJECT(button), "clicked", 
        GTK_SIGNAL_FUNC(XMdcFileSelSaveCallbackDefault), GTK_OBJECT(sfilew));
     gtk_box_pack_start(GTK_BOX(GTK_FILE_SELECTION(sfilew)->action_area),
                        button, TRUE, TRUE, 0);
     gtk_widget_show(button); 

     default_name = button;

   }else{
   
     if (format == MDC_MAX_FRMTS) {
       /* Save: use previous selected format */
       menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(formatmenu));
       active = gtk_menu_get_active(GTK_MENU(menu));
       gtk_menu_item_activate(GTK_MENU_ITEM(active));

     }else{ 
       /* Save As: use given format */
        nr=mitem_nr[format];
 
        gtk_option_menu_set_history(GTK_OPTION_MENU(formatmenu),nr);
        menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(formatmenu));
        gtk_menu_set_active(GTK_MENU(menu),nr);
        active = gtk_menu_get_active(GTK_MENU(menu));
        gtk_menu_item_activate(GTK_MENU_ITEM(active));
     }

  }

  if (MDC_ALIAS_NAME == MDC_YES) gtk_widget_hide(default_name);
  else gtk_widget_show(default_name);

  XMdcShowWidget(sfilew);

}


void XMdcLutSelOpenCallbackOk(GtkWidget *w, GtkWidget *fs)
{
   char *fname;

   fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));

   XMdcLoadLUT(fname);
 
}

void XMdcLutSelOpen(GtkWidget *widget, gpointer data)
{

   if (olutw == NULL) {

     /* Create a new file selection widget */
     olutw = gtk_file_selection_new ("Select LUT File");

     gtk_signal_connect(GTK_OBJECT (olutw), "destroy",
                        GTK_SIGNAL_FUNC(XMdcMedconQuit), NULL);
     gtk_signal_connect(GTK_OBJECT (olutw), "delete_event",
                       GTK_SIGNAL_FUNC(XMdcHandlerToHide), NULL);

     /* Connect the ok_button to file_ok_sel function */
     gtk_signal_connect_object(
       GTK_OBJECT(GTK_FILE_SELECTION(olutw)->ok_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(olutw));
     gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION (olutw)->ok_button),
       "clicked", GTK_SIGNAL_FUNC(XMdcLutSelOpenCallbackOk),olutw);

     /* Connect the cancel_button to hide the widget */
     gtk_signal_connect_object(GTK_OBJECT
       (GTK_FILE_SELECTION (olutw)->cancel_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(olutw));
   }

   /* Lets set the filename, as if this were a save dialog, and we are giving
    *       a default filename */
   if (XMEDCONLUT != NULL) {
     strncpy(xmdcstr,XMEDCONLUT,MDC_1KB_OFFSET); xmdcstr[MDC_1KB_OFFSET]='\0';

     if (xmdcstr[strlen(xmdcstr)-1] != MDC_PATH_DELIM_CHR)
       strcat(xmdcstr,MDC_PATH_DELIM_STR);

     gtk_file_selection_set_filename(GTK_FILE_SELECTION(olutw),xmdcstr);
   }else{ 
     /* installation dir */
     gtk_file_selection_set_filename(GTK_FILE_SELECTION(olutw),XMDCLUT);
   }
   gtk_file_selection_complete(GTK_FILE_SELECTION(olutw),"*.lut");

   XMdcShowWidget(olutw);

}

void XMdcRawPredefSelSaveCallbackOk(GtkWidget *widget, GtkWidget *fs)
{
  gchar *fname, *msg;

  fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));

  if ((msg = MdcWritePredef(fname)) != NULL) {
    XMdcDisplayWarn("%s",msg);
  }else{
    XMdcDisplayMesg("File successfully written");
  }
}

void XMdcRawPredefSelSave(GtkWidget *widget, gpointer data)
{
  if (spredefw == NULL) {

     /* Create a new file selection widget */
     spredefw = gtk_file_selection_new ("Save Raw Predef File");

     gtk_signal_connect(GTK_OBJECT(spredefw), "destroy",
                        GTK_SIGNAL_FUNC(XMdcMedconQuit), NULL);

     gtk_signal_connect(GTK_OBJECT(spredefw), "delete_event",
                        GTK_SIGNAL_FUNC(XMdcHandlerToHide), NULL);

     /* Connect the ok_button to save_ok_sel function */
     gtk_signal_connect_object(
        GTK_OBJECT(GTK_FILE_SELECTION (spredefw)->ok_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(spredefw));
     gtk_signal_connect(
        GTK_OBJECT(GTK_FILE_SELECTION (spredefw)->ok_button),
        "clicked", GTK_SIGNAL_FUNC(XMdcRawPredefSelSaveCallbackOk),
        GTK_OBJECT(spredefw));


     /* Connect the cancel_button to hide the widget */
     gtk_signal_connect_object(
        GTK_OBJECT(GTK_FILE_SELECTION (spredefw)->cancel_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(spredefw));
  }

  if (XMEDCONRPI != NULL) {
    strncpy(xmdcstr,XMEDCONRPI,MDC_1KB_OFFSET); xmdcstr[MDC_1KB_OFFSET]='\0';

    if (xmdcstr[strlen(xmdcstr)-1] != MDC_PATH_DELIM_CHR)
      strcat(xmdcstr,MDC_PATH_DELIM_STR);

    gtk_file_selection_set_filename(GTK_FILE_SELECTION(spredefw),xmdcstr);

    gtk_file_selection_complete(GTK_FILE_SELECTION(spredefw),"predef.rpi");
  }else{
    gtk_file_selection_set_filename(GTK_FILE_SELECTION(spredefw),"predef.rpi");
  }
   
  XMdcShowWidget(spredefw);

}

void XMdcRawPredefSelOpenCallbackOk(GtkWidget *w, GtkWidget *fs)
{
   char *fname, *msg;

   fname = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));

   if (MdcCheckPredef(fname) == MDC_NO) {
     XMdcDisplayWarn("Invalid raw predef input file"); return;
   }

   msg = MdcReadPredef(fname);
   if (msg != NULL) XMdcDisplayWarn(msg);

}

void XMdcRawPredefSelOpen(GtkWidget *widget, gpointer data)
{

   if (opredefw == NULL) {

     /* Create a new file selection widget */
     opredefw = gtk_file_selection_new ("Load Raw Predef File");

     gtk_signal_connect(GTK_OBJECT (opredefw), "destroy",
                        GTK_SIGNAL_FUNC(XMdcMedconQuit), NULL);
     gtk_signal_connect(GTK_OBJECT (opredefw), "delete_event",
                       GTK_SIGNAL_FUNC(XMdcHandlerToHide), NULL);

     /* Connect the ok_button to file_ok_sel function */
     gtk_signal_connect_object(
       GTK_OBJECT(GTK_FILE_SELECTION(opredefw)->ok_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(opredefw));
     gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION (opredefw)->ok_button),
       "clicked", GTK_SIGNAL_FUNC(XMdcRawPredefSelOpenCallbackOk),opredefw);

     /* Connect the cancel_button to hide the widget */
     gtk_signal_connect_object(GTK_OBJECT
       (GTK_FILE_SELECTION (opredefw)->cancel_button),
        "clicked", GTK_SIGNAL_FUNC(gtk_widget_hide), GTK_OBJECT(opredefw));
   }

   if (XMEDCONRPI != NULL) {
     strncpy(xmdcstr,XMEDCONRPI,MDC_1KB_OFFSET); xmdcstr[MDC_1KB_OFFSET]='\0';

     if (xmdcstr[strlen(xmdcstr)-1] != MDC_PATH_DELIM_CHR)
       strcat(xmdcstr,MDC_PATH_DELIM_STR);

     gtk_file_selection_set_filename(GTK_FILE_SELECTION(opredefw),xmdcstr);

     gtk_file_selection_complete(GTK_FILE_SELECTION(opredefw),"*.rpi");
   }else{
     gtk_file_selection_set_filename(GTK_FILE_SELECTION(opredefw),"*.rpi");
   }

   XMdcShowWidget(opredefw);

}

