<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                xmlns:ed="http://greenbytes.de/2002/rfcedit"
                exclude-result-prefixes="ed"
>

<!-- re-use some of the default RFC2629.xslt rules -->
<xsl:import href="rfc2629.xslt"/>

<!-- generate DTD-valid output, override all values imported from rfc2629.xslt -->
<xsl:output doctype-system="rfc2629.dtd" doctype-public="" method="xml" version="1.0" encoding="UTF-8" />

<!-- kick into cleanup mode -->
<xsl:template match="/">
  <xsl:comment>
    This XML document is the output of clean-for-DTD-xslt; a tool that strips
    extensions to RFC2629(bis) from documents for processing with xml2rfc.
  </xsl:comment>
  <xsl:apply-templates select="/" mode="cleanup"/>
</xsl:template>

<!-- rules for identity transformations -->

<xsl:template match="processing-instruction()" mode="cleanup">
  <xsl:text>&#10;</xsl:text>
  <xsl:copy><xsl:apply-templates select="node()|@*" mode="cleanup"/></xsl:copy>
</xsl:template>

<xsl:template match="text()|comment()|@*"  mode="cleanup"><xsl:copy><xsl:apply-templates select="node()|@*" mode="cleanup" /></xsl:copy></xsl:template>

<xsl:template match="/" mode="cleanup">
	<xsl:copy><xsl:apply-templates select="node()" mode="cleanup" /></xsl:copy>
</xsl:template>

<xsl:template match="*" mode="cleanup">
  <xsl:element name="{local-name()}">
  	<xsl:apply-templates select="node()|@*" mode="cleanup" />
  </xsl:element>
</xsl:template>


<!-- remove PI extensions -->

<xsl:template match="processing-instruction('rfc-ext')" mode="cleanup"/>

<!-- add issues appendix -->

<xsl:template match="back" mode="cleanup">
  <back>
  	<xsl:apply-templates select="node()|@*" mode="cleanup" />
    <xsl:if test="//ed:issue[@status='closed']">
      <section title="Resolved issues (to be removed by RFC Editor before publication)">
        <t>
          Issues that were either rejected or resolved in this version of this
          document.
        </t>
        <xsl:apply-templates select="//ed:issue[@status='closed']" mode="issues" />
      </section>
    </xsl:if>
    <xsl:if test="//ed:issue[@status='open']">
      <section title="Open issues (to be removed by RFC Editor prior to publication)">
        <xsl:apply-templates select="//ed:issue[@status!='closed']" mode="issues" />
      </section>
    </xsl:if>
  </back>
</xsl:template>




<!-- extensions -->

<xsl:template match="@xml:lang" mode="cleanup"/>
<xsl:template match="@xml:lang" />

<xsl:template match="ed:*" mode="cleanup"/>
<xsl:template match="ed:*" />

<xsl:template match="@ed:*" mode="cleanup"/>
<xsl:template match="@ed:*" />

<xsl:template match="ed:replace" mode="cleanup">
  <xsl:apply-templates mode="cleanup" />
</xsl:template>

<xsl:template match="ed:replace">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="ed:ins" mode="cleanup">
  <xsl:apply-templates mode="cleanup"/>
</xsl:template>

<xsl:template match="ed:ins">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="ed:issue" mode="issues">
  <section title="{@name}">
    <t>
      Type: <xsl:value-of select="@type" />
    </t>
    <xsl:if test="@href">
      <t>
        <!-- temp. removed because of xml2rfc's handling of erefs when producing TXT-->
        <!--<eref target="{@href}" /> -->
        &lt;<xsl:value-of select="@href"/>>
      </t>
    </xsl:if>
    <xsl:for-each select="ed:item">
      <t>
        <xsl:value-of select="concat(@entered-by,' (',@date,'): ')" />
        <xsl:value-of select="." />
      </t>
    </xsl:for-each> 
    <xsl:if test="ed:resolution">
      <t>
        <xsl:text>Resolution</xsl:text>
        <xsl:if test="ed:resolution/@datetime"> (<xsl:value-of select="ed:resolution/@datetime"/>)</xsl:if>
        <xsl:text>: </xsl:text>
        <xsl:value-of select="ed:resolution" />
      </t>
    </xsl:if>
  </section>
</xsl:template>



<!-- markup inside artwork element -->

<xsl:template match="figure[artwork//iref]" mode="cleanup">
  <!-- move up iref elements -->
  <xsl:apply-templates select="artwork//iref" mode="cleanup"/>
  <figure>
    <xsl:apply-templates select="@*|node()" mode="cleanup" />
  </figure>
</xsl:template>

<xsl:template match="artwork[*]" mode="cleanup">
  <xsl:choose>
    <xsl:when test="$xml2rfc-ext-allow-markup-in-artwork='yes'">
      <xsl:variable name="content"><xsl:apply-templates select="."/></xsl:variable>
      <artwork>
      	<xsl:copy-of select="@*" />
        <xsl:value-of select="translate($content,'&#160;',' ')"/>
      </artwork>
    </xsl:when>
    <xsl:otherwise>
      <artwork>
      	<xsl:apply-templates select="@*|node()" mode="cleanup" />
      </artwork>
    </xsl:otherwise>
  </xsl:choose>
  
</xsl:template>



<!-- table styles -->
<xsl:template match="texttable/@style" mode="cleanup"/>


</xsl:transform>