<!--
    Produce a reference entry based on an Amazon ASIN (ISBN) entry.

    Copyright (c) 2003 Julian F. Reschke (julian.reschke@greenbytes.de)

    placed into the public domain

    change history:

    2003-11-16  julian.reschke@greenbytes.de

    Initial release.
    
    2005-04-02  julian.reschke@greenbytes.de
    
    Fix two DTD issues.
-->

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
>

<xsl:output indent="yes"/>

<xsl:param name="asin" />

<xsl:template match="/">
  <xsl:variable name="uri" select="concat('http://xml.amazon.com/onca/xml3?t=webservices-20&amp;dev-t=foobar&amp;AsinSearch=',$asin,'&amp;type=heavy&amp;f=xml')" />
  <xsl:variable name="res" select="document($uri)" />
  <references>
    <xsl:apply-templates select="$res/ProductInfo/Details" />
  </references>
</xsl:template>

<xsl:template name="initials">
  <xsl:param name="str"/>
  <xsl:choose>
    <xsl:when test="contains($str,' ')">
      <xsl:call-template name="initials">
        <xsl:with-param name="str">
          <xsl:value-of select="substring-before($str,' ')"/>
        </xsl:with-param>
      </xsl:call-template>
      <xsl:call-template name="initials">
        <xsl:with-param name="str">
          <xsl:value-of select="substring-after($str,' ')"/>
        </xsl:with-param>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise><xsl:value-of select="substring($str,1,1)"/>. </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="get-surname">
  <xsl:param name="str"/>
  <xsl:choose>
    <xsl:when test="contains($str,' ')">
      <xsl:call-template name="get-surname">
        <xsl:with-param name="str" select="substring-after($str,' ')"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$str"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="Author">
  <xsl:variable name="surname">
    <xsl:call-template name="get-surname">
      <xsl:with-param name="str" select="normalize-space(.)"/>
    </xsl:call-template>
  </xsl:variable>
  <xsl:variable name="givenname">
    <xsl:value-of select="normalize-space(substring-before(.,$surname))"/>
  </xsl:variable>
  <author surname="{$surname}" fullname="{$givenname} {$surname}">
    <xsl:attribute name="initials">
      <xsl:call-template name="initials">
        <xsl:with-param name="str" select="$givenname"/>
      </xsl:call-template>
    </xsl:attribute>
    <organization/>
  </author>
</xsl:template>

<xsl:template match="Details">
  <reference target="urn:isbn:{Isbn}">
    <front>
      <xsl:apply-templates select="ProductName"/>
      <xsl:apply-templates select="Authors/Author"/>
      <xsl:apply-templates select="ReleaseDate"/>
    </front>
    <xsl:apply-templates select="Manufacturer"/>
  </reference>
</xsl:template>

<xsl:template match="ReleaseDate">
  <xsl:variable name="part1" select="normalize-space(substring-before(.,','))" />
  <xsl:variable name="part2" select="normalize-space(substring-after(.,','))" />
  <date year="{$part2}">
    <xsl:choose>
      <xsl:when test="contains($part1,' ')">
        <xsl:attribute name="month">
          <xsl:value-of select="substring-after($part1,' ')" />
        </xsl:attribute>
      </xsl:when>
      <xsl:otherwise>
        <xsl:attribute name="month">
          <xsl:value-of select="$part1" />
        </xsl:attribute>
      </xsl:otherwise>
    </xsl:choose>
  </date>
</xsl:template>

<xsl:template match="ProductName">
  <title><xsl:value-of select="."/></title>
</xsl:template>

<xsl:template match="Manufacturer">
  <seriesInfo name="{.}" value="" />
</xsl:template>



</xsl:transform>