<!--
    Extract named artwork elements.

    Copyright (c) 2005 Julian F. Reschke (julian.reschke@greenbytes.de)

    placed into the public domain
-->

<xsl:transform xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
>

<xsl:import href="clean-for-DTD.xslt"/>

<xsl:output method="text" encoding="UTF-8"/>

<xsl:param name="name" />

<xsl:template match="/" priority="9">
  
  <xsl:variable name="artwork" select="//artwork[@name=$name]"/>
  
  <xsl:choose>
    <xsl:when test="$artwork">
      <xsl:apply-templates select="$artwork" mode="cleanup"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:message>Artwork element named '<xsl:value-of select="$name"/>' not found.</xsl:message>
    </xsl:otherwise>
  </xsl:choose>

</xsl:template>


</xsl:transform>