#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include <effects.h>
#include <gettext.h>


static t_effect effects[100];
static int nb_effects = 0;


void effects_save_effect (t_effect *effect)
{
    char datafile[256], path[256];
    FILE *f;
    int i;
    
    g_assert (effect);
    f = fopen ("/usr/share/xmms/infinite_states","a");
    if (f == NULL) {
        fflush (stdin);
        f = popen ("xmms-config --data-dir","r");
        fscanf (f, "%s", path);
        pclose (f);
        sprintf (datafile, "%s/%s", path, "infinite_states");
        f = fopen (datafile, "a");
        if (f == NULL) {
            g_warning (_("Could not be opened file %s for saving effects\n"),
                       datafile);
            return ;
        }
    }
    for (i = 0; i < sizeof(t_effect); i++) 
        fputc (*((byte*)effect+i), f);
    fclose (f);
}


void effects_load_effects (void)
{
    char path[255];
    char datafile[255];
    FILE *f;
    int finished = 0;
    int i;

    f = fopen ("/usr/share/xmms/infinite_states","r");
    if (f == NULL) {
        fflush (stdin);
        f = popen ("xmms-config --data-dir","r");
        fscanf (f, "%s", path);
        pclose (f);
        sprintf (datafile,"%s/%s",path,"infinite_states");
        f = fopen (datafile,"r");
        if (f == NULL) {
            g_warning (_("Could not be opened file %s for loading effects\n"),
                       datafile);
            return ;
        }
    }
    while (!finished) {
        byte* ptr_effect = (byte*)&effects[nb_effects];
        for (i=0;i < sizeof(t_effect); i++) {
            int b=fgetc(f);
            if (b!=EOF)
                ptr_effect[i]=(byte)b;
            else
                finished=1;
        }
        nb_effects+=1;
    }
    nb_effects -= 1;
    fclose (f);
}

void effects_load_random_effect (t_effect *effect)
{
    if (nb_effects > 0) {
        int num_effect = rand() % nb_effects;
        int i;
        
        for (i = 0; i < sizeof(t_effect); i++) {
            *((byte*)effect+i) = *((byte*)(&effects[num_effect])+i);
        }
    }
}
