/*
 * Copyright (C) 2003 the xmms-kde team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef __OSDFRAME_H__
#define __OSDFRAME_H__

#include <kcolorbutton.h>
#include <kconfig.h>
#include <klocale.h>
#include <krootpixmap.h>

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcolor.h>
#include <qevent.h>
#include <qfont.h>
#include <qfontdialog.h>
#include <qfontmetrics.h>
#include <qframe.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qtabwidget.h>
#include <qtimer.h>
#include <qwidget.h>

#include "math.h"

class OSDFrame : public QFrame {

  Q_OBJECT

 public:

  enum { FADE_IN, FADE_WAIT, FADE_OUT, FADE_STOP, OSD_TEST };
  enum { LEFT, RIGHT, TOP, BOTTOM };

  OSDFrame(KConfig *config);
  ~OSDFrame();

  void paintEvent(QPaintEvent *e);
  
  void startSequence(QString t);
  void startDemo();
  void stopDemo();

  QWidget *getConfigurationWidget(QWidget *parent);

  void writeConfig();

 private slots:

  void paint();
  void configChanged();
  void fadeInChanged(int index);
  void fadeOutChanged(int index);
  void fontChanged();

  void readConfig();

 private:
  KRootPixmap *frameRoot;

  QString title;
  int height;
  int width;

  float i;
  int wait;

  QTimer *paintTimer;
  QFont titleFont;

  int effect;
  int source;
  int destination;

  QColor fgColor;
  QColor bgColor;

  QTabWidget *confWidget;
  QCheckBox *osdBox;
  QSpinBox *osdXBox;
  QSpinBox *osdYBox;
  //QSpinBox *osdSizeBox;
  QPushButton *osdFontButton;
  QSpinBox *osdTBox;
  KColorButton *osdFGColorButton;
  KColorButton *osdBGColorButton;

  bool enable;
  int x, y;
  float transparency;

  KConfig *config;
  bool loop;
};

#endif
