/*  
   XMMS-SID - SIDPlay input plugin for X MultiMedia System (XMMS)

   Main header file

   Written by Matti "ccr" Hamalainen <ccr@tnsp.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#ifndef _XMMS_SID_H
#define _XMMS_SID_H

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifdef HAVE_ASSERT_H
#include <assert.h>
#else
#define assert(x) /* stub */
#endif
#include <glib.h>
#include <xmms/plugin.h>

/*
 * Some defines
 */
#define DEBUG
#undef HAVE_HARDSID_BUILDER	/* HardSID-support is not working and is untested */

/*
 * Generals
 */
#define XS_BUFSIZE		(4096)		/* Size for some buffers */

#define XS_CONFIG_IDENT		"XMMS-SID"	/* Configuration file identifier */
#define XS_CONFIG_FILE		"/.xmms/xmms-sid"	/* Use this configfile if autocyrpe fails */

#define XS_STIL_MAXENTRY	(128)		/* Max number of sub-songs in STIL/SLDB node */

#define XS_MIN_OVERSAMPLE	(2)		/* Minimum oversampling factor */
#define XS_MAX_OVERSAMPLE	(8)		/* Maximum oversampling factor */

extern InputPlugin xs_plugin_ip;		/* XMMS-SID plugin structure */


typedef struct {
	gint		tuneSpeed;
	gint		tuneLength;
	gchar		*tuneTitle;
} t_xs_subtune;


typedef struct {
	gchar		*tuneFilename,
			*tuneName,
			*tuneComposer,
			*tuneCopyright;
	gint		nsubTunes, startTune;
	t_xs_subtune	subTunes[XS_STIL_MAXENTRY];
} t_xs_tune;


typedef struct {
	gint		audioFrequency,
			audioFormat,
			audioChannels,
			audioBitsPerSample;
	void		*player;
	gboolean	isError, isPlaying;
	gint		currSong,
			lastTime;
	t_xs_tune	*pTune;
} t_xs_status;


extern t_xs_status xs_status;


/*
 * Plugin function prototypes
 */
void	xs_init(void);
void	xs_reinit(void);
void	xs_close(void);
gint	xs_is_our_file(gchar *);
void	xs_play_file(gchar *);
void	xs_stop(void);
void	xs_pause(short);
void	xs_seek(gint);
gint	xs_get_time(void);
void	xs_get_song_info(gchar *, gchar **, gint *);
void	xs_fileinfo(gchar *);
void	xs_about(void);

t_xs_tune *xs_tune_new(gchar *, gint, gint, gchar *, gchar *, gchar *);
void	xs_tune_free(t_xs_tune *);


/*
 * Debugging and error handling macros
 */
#ifdef DEBUG
#define XSDEBUG(x...) { fprintf(stderr, "XS[%s:%d]: ", __FILE__, (int) __LINE__); fprintf(stderr, ## x); }
#else
#define XSDEBUG(x...) /* foo */
#endif

#define XSERR(x...) { fprintf(stderr, PACKAGE_NAME ": "); fprintf(stderr, ## x); }


#ifdef __cplusplus
}
#endif
#endif /* _XMMS_SID_H */
