#ifndef XS_LENGTH_H
#define XS_LENGTH_H

#ifdef __cplusplus
extern "C" {
#endif

#include "xmms-sid.h"
#include "xs_md5.h"

/*
 * Defines and typedefs
 */
typedef struct _t_xs_sldb_node {
	t_xs_md5hash	md5Hash;	/* 128-bit MD5 hash-digest */
	gint		nLengths;	/* Number of lengths */
	gint32		sLengths[XS_STIL_MAXENTRY];	
					/* Lengths in seconds */

	struct _t_xs_sldb_node *pPrev, *pNext;
} t_xs_sldb_node;


/*
 * Functions
 */
gint	xs_songlen_init(void);		/* Initialize songlength subsystem */
void	xs_songlen_close(void);		/* Close/shutdown */
t_xs_sldb_node *xs_songlen_get(gchar *);


#ifdef __cplusplus
}
#endif
#endif /* XS_LENGTH_H */
