/*
   XMMS-SID - SIDPlay input plugin for X MultiMedia System (XMMS)

   NanoSID support

   Written by Matti "ccr" Hamalainen <ccr@tnsp.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include "xmms-sid.h"

#ifdef HAVE_NANOSID

#include "xs_nanosid.h"
#include <stdio.h>
#include <xmms/titlestring.h>
#include "xs_config.h"
#include "xs_support.h"
#include <libNanoSID.h>


typedef struct {
} t_xs_nanosid;


/*
 * Check if we can play the given file
 */
gboolean xs_nanosid_isourfile(gchar *pcFilename)
{
 if (strstr(pcFilename, ".zsid"))
	return TRUE;
	else
	return FALSE;
}


/*
 * Initialize NanoSID
 */
gboolean xs_nanosid_init(t_xs_status *myStatus)
{
 t_xs_nanosid *myPlayer;
 assert(myStatus);

 /* Allocate internal structures */
 myPlayer = (t_xs_nanosid *) g_malloc0(sizeof(t_xs_nanosid));
 if (!myPlayer) return FALSE;

 /* Initialize engine */



 myStatus->player = myPlayer;
 return TRUE;
}


/*
 * Close NanoSID
 */
void xs_nanosid_close(t_xs_status *myStatus)
{
 t_xs_nanosid *myPlayer;
 assert(myStatus);

 /* Free internals */
 myPlayer = (t_xs_nanosid *) myStatus->player;




 g_free(myPlayer);
 myStatus->player = NULL;
}


gboolean xs_nanosid_initsong(t_xs_status *myStatus)
{
 t_xs_nanosid *myPlayer = (t_xs_nanosid *) myStatus->player;

 if (!myPlayer) return FALSE;

}


guint xs_nanosid_fillbuffer(t_xs_status *myStatus, gchar *audioBuffer, guint audioBufSize)
{
 t_xs_nanosid *myPlayer = (t_xs_nanosid *) myStatus->player;

 if (!myPlayer) return -1;

 return audioBufSize;
}


gboolean xs_nanosid_loadsid(t_xs_status *myStatus, gchar *pcFilename)
{
 t_xs_nanosid *myPlayer = (t_xs_nanosid *) myStatus->player;
 assert(myStatus);

 /* Try to get the tune */
 if (!pcFilename) return FALSE;

 return FALSE;
}


/*
 * Delete INTERNAL information
 */
void xs_nanosid_deletesid(t_xs_status *myStatus)
{
 t_xs_nanosid *myPlayer;
 assert(myStatus);

 myPlayer = (t_xs_nanosid *) myStatus->player;
 if (!myPlayer) return;
}


/*
 * Return song information
 */


#endif	/* HAVE_NANOSID */
