#! /bin/sh
WANT_AM_VERSION=1.9

echo "***"
echo "*** Now bootstrapping the package."
echo "*** This may take a while, please be patient ..."
echo "***"
ftest_msg()
{
echo "You do not have required GNU Autotools installed, please install"
echo "recent version of GNU autoconf, automake and libtool packages."
echo "(Could not find runnable $1)"
}

ftest_am_package()
{
PRG1=`which "$1-$WANT_AM_VERSION"`
PRG2=`which $1`
if test -n "$PRG1"  && test -x "$PRG1"; then
	echo "* $1-$WANT_AM_VERSION $2"
	eval $1-$WANT_AM_VERSION $2
else
	if test -n "$PRG2"  && test -x "$PRG2"; then
		echo "* Warning! Could not find $1-$WANT_AM_VERSION!"
		echo "  Trying '$1', which may fail due to incompabilities."
		echo "* $1 $2"
		eval $1 $2
	else
		ftest_msg "'$1-$WANT_AM_VERSION' or '$1'"
		exit 1
	fi
fi
}

ftest_ac_package()
{
PRG1=`which $1`
if test -n "$PRG1"  && test -x "$PRG1"; then
	echo "* $1 $2"
	eval $1 $2
else
	ftest_msg "'$1'"
	exit 1
fi
}

ftest_package()
{
PRG1=`which $1`
if test -n "$PRG1"  && test -x "$PRG1"; then
	echo "* $1 $2"
	eval $1 $2
else
	echo "Could not find runnable '$1', perhaps $3 package is not installed"
	echo "or it is not in the PATH. Please install $4."
	exit 1
fi
}

# Check available m4 macro paths
aclocal_opts=$ACLOCAL_FLAGS
for i in /usr /usr/local /usr/sfw /opt/gnome; do
	j="$i/share/aclocal"
	if test -d "$j"; then
		aclocal_opts="$aclocal_opts -I $j"
	fi
done

# Check if gettext is used
for i in configure.ac configure.in; do
	if test -e "$i"; then
		k=`grep AM_GNU_GETTEXT $i`
	fi
done

if test -n "$k"; then
	echo "* GNU gettext seems to be in use ..."
	ftest_package "autopoint" "-f" "gettext(-dev|-devel)" "GNU gettext 0.14.1 or later."
else
	echo "* GNU gettext not used by the package, skipping."
fi

# Check and run autotools
ftest_am_package "aclocal" "-I . $aclocal_opts"
ftest_ac_package "libtoolize" "--automake --force"
ftest_am_package "automake" "-a -c -f --foreign"
ftest_ac_package "autoconf" ""

# Check if Glade is used and run it for each file
k=`echo *.glade`
if test "x$k" != "x*.glade"; then
	echo "* Glade XML files found, processing ..."
	for i in *.glade; do
		ftest_package "glade" "-w $i" "Glade" "Glade for Gtk+1 applications (Glade v0.6.4)"
	done
else
	echo "* No Glade files found, skipping."
fi

