%define	name	xmms-sid
%define	version	0.8.0beta17
%define	release	1
%define plugindir %(xmms-config --input-plugin-dir)
%define withSID1 %(if test -z "`rpm -q --whatprovides libsidplay.so.1 2>/dev/null | grep -v '^no package provides'`"; then echo 0; else echo 1; fi)
%define withSID2 %(if test -z "`rpm -q --whatprovides libsidplay2.so.1 2>/dev/null | grep -v '^no package provides'`" ; then echo 0; else echo 1; fi)

Summary:	A SID-tune (C64 music) input plugin for XMMS
Name:		%{name}
Version:	%{version}
Release:	%{release}
Copyright:	GPL
Group:		Applications/Multimedia
Vendor:		Matti 'ccr' Hmlinen <ccr@tnsp.org>
Url:		http://www.tnsp.org/xmms-sid.php
Source:		http://www.tnsp.org/xs-files/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-root
BuildRequires:	xmms-devel >= 1.2.10
Requires:	gtk+ >= 1.2.5, glib >= 1.2.5, xmms >= 1.2.10
%if %{withSID1} == 1
Requires:	libsidplay
%else
%define optSID1 --without-sidplay1
%endif
%if %{withSID2} == 1
Requires:	libsidplay2 >= 2.1.1
%else
%define optSID2 --without-sidplay2
%endif

%description
Input plugin for XMMS to play SID-tunes (Music from Commodore
64 games/demos/etc.). Supports either (or both) libSIDPlay
v1.x or v2.x. Includes extensive configurability (settings for
filters and other SID-emulation parameters, extensive fileinfo),
has STIL-database support, song-length database support and more.

High Voltage SID Collection (HVSC) contains over 30,000 SID-tunes
for your listening pleasure, http://hvsc.c64.org/

%description -l de
Input-Plugin fr XMMS um SID-musiken (Musik aus Commodore64 Spielen,
Demos, etc) abzuspielen. Untersttzt entweder libSidPlay V1.x, V2.x
oder beide. Enthlt erweiterte Konfiguriermglichkeiten, wie
Filtereinstellungen, diverse Parameter fr die SID-Emulation und
ausfhrlichere Fileinformationen), Untersttzung der STIL Datenbank,
Song-Lngen Datenbank und vieles mehr.

%prep
%setup -q

%build
export CFLAGS="$RPM_OPT_FLAGS" CPPFLAGS="$RPM_OPT_FLAGS" CXXFLAGS="$RPM_OPT_FLAGS";
%configure --libdir=%{plugindir} %{optSID1} %{optSID2}
make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
%makeinstall libdir=$RPM_BUILD_ROOT/%{plugindir}

%post	-p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
[ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)
%doc AUTHORS COPYING FAQ NEWS README THANKS TODO BUGS xmms-1.2.10-songpos.patch
%{plugindir}/libxmmssid.*
%{_datadir}/xmms-sid
