/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_clist_status.h"

CListStatus displayer_clist_status;

void displayer_clist_status_init(void)
{
	displayer_clist_status.lastRow = -1;
	displayer_clist_status.line = -1;
	displayer_clist_status.jump_to_song = 0;

	displayer_clist_status.timestamp_context_id = 0;
	displayer_clist_status.song_context_id = 0;
	displayer_clist_status.messageCounter = 0;

	displayer_clist_status.next_lyric_line = NULL;
	displayer_clist_status.song = NULL;

	displayer_clist_status.win_size_y = -1;
}

void displayer_clist_status_finish(void)
{
	displayer_clist_status.messageCounter = 0;
	displayer_clist_status.timestamp_context_id = 0;

	displayer_clist_status.lastRow = -1;
	displayer_clist_status.line = 0;

	singit_song_detach(&displayer_clist_status.song);
}
