/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_CLIST_STATUS_H__
#define __DISPLAYER_CLIST_STATUS_H__

#include "singit_song.h"

#include <glib.h>

typedef struct _CListStatus {

	gint lastRow;
	gint line;
	gint jump_to_song;

	guint timestamp_context_id;
	guint song_context_id;
	gint messageCounter;

	GList *next_lyric_line;
	SingitSong *song;

	gint win_size_y;

} CListStatus;

extern CListStatus displayer_clist_status;

void displayer_clist_status_init(void);
void displayer_clist_status_finish(void);

#endif // __DISPLAYER_CLIST_STATUS_H__
