/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_FULLSCREEN_STATUS_H__
#define __DISPLAYER_FULLSCREEN_STATUS_H__

#include <gtk/gtk.h>
#include "singit_song.h"

typedef struct _FullScreenStatus
{
	GtkWidget *karaoke_widget;

	gint hide_mouse_id;
	gint jump_to_song;

	SingitSong *song;

	gboolean print_debug;
	gboolean toggle_yz;
	gboolean guess_synced_lyrics;
	gboolean show_jumping_ball;
	gboolean find_optimal_font;
}
FullScreenStatus;

extern FullScreenStatus full_screen_status;

#define DEBUG(x)  { if (full_screen_status.print_debug) debug x; }
#define PERROR(x) { if (full_screen_status.print_debug) perror(x); }

void displayer_fullscreen_status_init(void);
void displayer_fullscreen_status_finish(void);

#endif // __DISPLAYER_FULLSCREEN_STATUS_H__
