/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <GL/gl.h>
#include <glib.h>

#include "ctexture.h"
#include "cscene.h"

#include "c_wrapper.h"
#include "clyrictextengine.h"

static CScene *scene = 0;

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

void opengl_lyrics_draw(guint time, gboolean rotate, gboolean beat, gfloat level[3])
{
	if (scene) {
		scene->draw(time, (rotate == TRUE) ? true : false,
			(beat == TRUE) ? true : false, level);
	}
}

void opengl_lyrics_set_song(SingitSong *song)
{
	if (scene)
		{ scene->set_song(song); }
}

void opengl_lyrics_free()
{
	delete scene;
	scene = 0;
}

void opengl_lyrics_init()
{
	scene = new CScene;
}

#ifdef __cplusplus
}
#endif // __cplusplus
