/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtksignal.h>

#include <singit_macros.h>
#include <singit_config.h>
#include <singit_config_xmms.h>

#include "displayer_opengl_config.h"

SingitConfigGen *displayer_opengl_config = NULL;

static gpointer displayer_opengl_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	OpenGLConfigData *opengl_config_data = g_malloc(sizeof(OpenGLConfigData));

	opengl_config_data->sensitivityBassLow = 20;
	opengl_config_data->sensitivityBassHigh = 20;

	opengl_config_data->directApply = FALSE;
	opengl_config_data->displayParticles = TRUE;

	return opengl_config_data;
}

static void displayer_opengl_config_free_event(SingitConfigGen *scg, OpenGLConfigData *cfg_data, gpointer user_data)
{
	g_free(cfg_data);
}

#define CFG_DATA     cfg_data
#define CFG_FILE     cfg_file
#define SECTION     "DisplayerOpenGL"

static void displayer_opengl_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, OpenGLConfigData *cfg_data, gpointer user_data)
{
	READ_CFG_DEF(int,sensitivityBassLow,20);
	READ_CFG_DEF(int,sensitivityBassHigh,20);
	READ_CFG_DEF(boolean,directApply,FALSE);
	READ_CFG_DEF(boolean,displayParticles,TRUE);
}

static void displayer_opengl_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, OpenGLConfigData *cfg_data, gpointer user_data)
{
	WRITE_CFG(int, sensitivityBassLow);
	WRITE_CFG(int, sensitivityBassHigh);
	WRITE_CFG(boolean, directApply);
	WRITE_CFG(boolean, displayParticles);
}

#undef SECTION
#undef CFG_FILE
#undef CFG_DATA

static void displayer_opengl_config_destroy_event(SingitConfigGen *scg, gpointer user_data)
{
	displayer_opengl_config = NULL;
}

SingitConfigGen* displayer_opengl_config_new(void)
{
	GtkObject *dcc;

	if (displayer_opengl_config != NULL)
		{ return displayer_opengl_config; }

	dcc = singit_config_gen_new(CONFIG_FILENAME, NULL);

	gtk_signal_connect(GTK_OBJECT(dcc), "init",
		GTK_SIGNAL_FUNC(displayer_opengl_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "free",
		GTK_SIGNAL_FUNC(displayer_opengl_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "load",
		GTK_SIGNAL_FUNC(displayer_opengl_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "save",
		GTK_SIGNAL_FUNC(displayer_opengl_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(dcc), "destroy",
		GTK_SIGNAL_FUNC(displayer_opengl_config_destroy_event), NULL);

	return SINGIT_CONFIG_GEN(dcc);
}
