/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_OPENGL_STATUS_H__
#define __DISPLAYER_OPENGL_STATUS_H__

#include <gtk/gtkwidget.h>

// #include <GL/gl.h>

#include "singit_song.h"
// #include "singit_macros.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _OpenGLStatus
{
	GtkWidget *gl_area_widget;

	gint hide_mouse_id;
	gint jump_to_song;
	guint time;

	gboolean toggle_yz;

	SingitSong *song;

	gint stereo_bass[2][2];

	gboolean print_debug;
	gboolean rotate;

	guint display_list;

	gboolean beat;
	gfloat level[3];
}
OpenGLStatus;

#define DEBUG(x)  { if (displayer_opengl_status.print_debug) debug x; }
#define PERROR(x) { if (displayer_opengl_status.print_debug) perror(x); }

extern OpenGLStatus displayer_opengl_status;

void displayer_opengl_status_init(void);
void displayer_opengl_status_finish(void);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __DISPLAYER_OPENGL_STATUS_H__
