/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <glib.h>
#include <gtk/gtk.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include <singit_macros.h>
#include <singit_config.h>
#include <singit_config_xmms.h>

#include "displayer_sdl_config.h"

SingitConfigGen *displayer_sdl_config = NULL;
extern SingitConfigGen* singit_config;

static gpointer displayer_sdl_config_init_event(SingitConfigGen *scg, gpointer user_data)
{
	SDLConfigData *sdl_config_data = g_malloc(sizeof(SDLConfigData));

	sdl_config_data->forceGlobals = TRUE;
	sdl_config_data->debugEnable = FALSE;

	sdl_config_data->lyricFontName = NULL;

	return sdl_config_data;
}

static void displayer_sdl_config_free_event(SingitConfigGen *scg, SDLConfigData *cfg_data, gpointer user_data)
{
	if (cfg_data->lyricFontName) { g_free(cfg_data->lyricFontName); }

	g_free(cfg_data);
}

#define GLOBAL_VAR   forceGlobals
#define GLOBAL_DATA  scd
#define CFG_DATA     cfg_data
#define CFG_FILE     cfg_file
#define SECTION     "DisplayerSDL"

static void displayer_sdl_config_load_event(SingitConfigGen *scg, ConfigFile* cfg_file, SDLConfigData *cfg_data, gpointer user_data)
{
	SingitConfigData *scd = GET_SCD;

	READ_CFG_DEF(boolean,forceGlobals,FALSE);

	READ_CFG_DEF_GBL(boolean,hideIfNotFound,);
	READ_CFG_DEF_GBL(boolean,showEmpty,);
	READ_CFG_DEF_GBL(boolean,autoResize,);
#ifdef CODEDEBUG
	READ_CFG_DEF_GBL(boolean,debugEnable,);
#endif

	// * global independant config *
	READ_CFG_DEF(boolean,hideIfNotFoundFullscreen,FALSE);
	READ_CFG_DEF(string,lyricFontName,g_strdup(SINGIT_DATA_DIR "/vixar.ttf"));
	READ_CFG_DEF(boolean,optimizeFontSize,TRUE);

	READ_CFG_DEF(int,winPosX,-1);
	READ_CFG_DEF(int,winPosY,-1);
	READ_CFG_DEF(int,lyricFontSize,32);
	READ_CFG_DEF(int,lyricFontSizeFullscreen,48);

	// * global config copies *
	cfg_data->gblToggleYZ = scd->toggleYZ;
}

static void displayer_sdl_config_save_event(SingitConfigGen *scg, ConfigFile* cfg_file, SDLConfigData *cfg_data, gpointer user_data)
{
	// * boolean values *
	WRITE_CFG(boolean, forceGlobals);
	WRITE_CFG(boolean, hideIfNotFound);
	WRITE_CFG(boolean, showEmpty);
	WRITE_CFG(boolean, autoResize);
#ifdef CODEDEBUG
	WRITE_CFG(boolean, debugEnable);
#endif

	// * string values *
	WRITE_CFG(del_string, lyricFontName);

	// * global independant config *
	WRITE_CFG(boolean, hideIfNotFoundFullscreen);
	WRITE_CFG(boolean, optimizeFontSize);

	WRITE_CFG(int, winPosX);
	WRITE_CFG(int, winPosY);
	WRITE_CFG(int, lyricFontSize);
	WRITE_CFG(int, lyricFontSizeFullscreen);
}

#undef SECTION
#undef CFG_FILE
#undef CFG_DATA
#undef GLOBAL_DATA
#undef GLOBAL_VAR

static void displayer_sdl_config_destroy_event(SingitConfigGen *scg, gpointer user_data)
{
	displayer_sdl_config = NULL;
}

SingitConfigGen* displayer_sdl_config_new(void)
{
	GtkObject *scd;

	if (displayer_sdl_config != NULL) { return displayer_sdl_config; }

	scd = singit_config_gen_new(CONFIG_FILENAME, NULL);

	gtk_signal_connect(GTK_OBJECT(scd), "init",
		GTK_SIGNAL_FUNC(displayer_sdl_config_init_event), NULL);
	gtk_signal_connect(GTK_OBJECT(scd), "free",
		GTK_SIGNAL_FUNC(displayer_sdl_config_free_event), NULL);
	gtk_signal_connect(GTK_OBJECT(scd), "load",
		GTK_SIGNAL_FUNC(displayer_sdl_config_load_event), NULL);
	gtk_signal_connect(GTK_OBJECT(scd), "save",
		GTK_SIGNAL_FUNC(displayer_sdl_config_save_event), NULL);
	gtk_signal_connect(GTK_OBJECT(scd), "destroy",
		GTK_SIGNAL_FUNC(displayer_sdl_config_destroy_event), NULL);

	return SINGIT_CONFIG_GEN(scd);
}
