/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __SDL_HELPERS_H__
#define __SDL_HELPERS_H__

#include <glib.h>

#include <X11/X.h>

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

enum {
	BLANK_RESET = -2,
	BLANK_QUERY = -1,
	BLANK_DISABLE = 0,
	BLANK_ENABLE = 1,
};

void sdl_helper_get_position(gint *x, gint *y);

void sdl_helper_map(gboolean show);

int sdl_helper_blanking(int sdl_enum);

void sdl_helper_set_transient(Window parent);

void sdl_helper_gain_focus(void);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __SDL_HELPERS_H__
