/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DISPLAYER_TEST_SDL_H__
#define __DISPLAYER_TEST_SDL_H__

#include "singit_song.h"
#include "singit_macros.h"
#include "singit_karaoke_data.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#define MY_SDL_MUSTLOCK(sf) \
	(SDL_MUSTLOCK((SDL_Surface*) sf) && (SDL_LockSurface((SDL_Surface*) sf) == 0))
#define MY_SDL_UNLOCK(sf) \
	((SDL_MUSTLOCK((SDL_Surface*) sf) && (SDL_UnlockSurface((SDL_Surface*) sf)))

#define DEBUG(x) g_print x

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // __DISPLAYER_TEST_SDL_H__
