/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "displayer_test_sdl_status.h"
#include "sdl_test_helpers.h"
#include "displayer_test_sdl.h"

SDLTestStatus displayer_test_sdl_status;

/*
	pthread_mutex_t sdl_event_mutex = PTHREAD_MUTEX_INITIALIZER;
	gboolean kill = FALSE;
	guint timeout = 0;
	gint dpms = 0;

	gboolean hideIfNotFound = FALSE;
	gboolean hideIfNotFoundFullscreen = FALSE;
*/
void displayer_test_sdl_status_init(void)
{
	displayer_test_sdl_status.song = NULL;

	displayer_test_sdl_status.toggle_yz = FALSE;
	displayer_test_sdl_status.print_debug = FALSE;
	displayer_test_sdl_status.is_fullscreen = FALSE;

	displayer_test_sdl_status.time = 0;
	displayer_test_sdl_status.toplines = 2;
	displayer_test_sdl_status.lines = 5;

	displayer_test_sdl_status.screen = NULL;
	displayer_test_sdl_status.current_text = NULL;
	displayer_test_sdl_status.next_text = NULL;
	displayer_test_sdl_status.font = NULL;

	displayer_test_sdl_status.jump_to_song = -1;
	displayer_test_sdl_status.skd = NULL;

	displayer_test_sdl_status.sdl_inuse = FALSE;

	displayer_test_sdl_status.xmms_playing = FALSE;
	displayer_test_sdl_status.singit_playing = FALSE;

	pthread_mutex_init(&displayer_test_sdl_status.sdl_event_mutex, NULL);
	displayer_test_sdl_status.kill = FALSE;
	displayer_test_sdl_status.timeout = 0;
	displayer_test_sdl_status.dpms = 0;

	displayer_test_sdl_status.hideIfNotFound = FALSE;
	displayer_test_sdl_status.hideIfNotFoundFullscreen = FALSE;
}

void displayer_test_sdl_status_finish(void)
{
	singit_song_detach(&displayer_test_sdl_status.song);

	displayer_test_sdl_status.screen = NULL;
}
