/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_CONFIG_GEN_PROPS_H__
#define __SINGIT_CONFIG_GEN_PROPS_H__

#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

typedef struct _SingitConfigGenEntry SingitConfigGenEntry;

struct _SingitConfigGenEntry
{
	GtkArg *value;
	GtkArg *default_value;
};

#define scgeName(a) (*(((SingitConfigGenEntry*) entry)->value->name))
#define scgeType(a) (*(((SingitConfigGenEntry*) entry)->value->type))

static SingitConfigGenEntry *singit_config_gen_entry_new(GtkType type)
{
	SingitConfigGenEntry *entry = g_new(SingitConfigGenEntry, 1);
	entry->value = gtk_arg_new(type);
	entry->default_value = gtk_arg_new(type);
	return entry;
}

#endif // __SINGIT_CONFIG_GEN_PROPS_H__
