/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gdk/gdk.h>

#include "singit_config_xmms.h"

gboolean xmms_cfg_read_color(ConfigFile *cfg, gchar *section, gchar *key, gchar **color_str)
{
	GdkColor color;
	gboolean result = FALSE;
	if (xmms_cfg_read_string(cfg, section, key, color_str))
	{
		result = gdk_color_parse(*color_str, &color);
		if (result == FALSE) {
			g_free(*color_str);
			*color_str = NULL;
		}
	}
	return result;
}

void xmms_cfg_write_del_string(ConfigFile *cfg, gchar *section, gchar* entry, gchar *value)
{
	if (value == NULL) { xmms_cfg_remove_key(cfg, section, entry); }
	else { xmms_cfg_write_string(cfg, section, entry, value); }
}
