/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_MAIN_STATUS_H__
#define __SINGIT_MAIN_STATUS_H__

#include <pthread.h>

#include "singit_sound_precalcs.h"
#include "singit_framerate_counter.h"

typedef struct {

        GList *next_lyric_line;

	pthread_t display_thread;
	pthread_t check_thread;

	pthread_mutex_t config_rw_mutex;
	pthread_mutex_t lyrics_rw_mutex;

	gboolean kill_threads;
	gboolean initialize_plugins;

	gboolean config_update;
	gboolean playing;
	gboolean song_changed;
	gboolean text_update;

	SingitSoundPrecalcs *singit_sound_precalcs;
	SingitFramerateCounter *singit_framerate_counter;

	gint attachments;

} SingitStatus;

extern SingitStatus singit_status;

void singit_main_status_init(void);
void singit_main_status_finish(void);

#endif  // __SINGIT_MAIN_H__
