
#ifndef __PARTICLE_GROUP_H__
#define __PARTICLE_GROUP_H__

#include "GF_WaveShape.h"

class ParticleGroup
	: public GF_WaveShape, public nodeClass {

public:
	ParticleGroup( float* inTPtr, ExprUserFcn** inMagFcn );

	void		Load( ArgList& inArgs );

	void		SetDuration( float inSecs )							{ mEndTime = *mTPtr + inSecs;	}
	inline bool	IsExpired()											{ return *mTPtr > mEndTime;	}

	void		DrawGroup( PixPort& inDest );

	UtilStr		mTitle;

protected:
	const float*	mTPtr;

	float		mID, mNumInstances;
	float		mEndTime, mStartTime;
	float		mFadeTime;
};

#endif // __PARTICLE_GROUP_H__
