#### Header variables
%define name volnorm
%define version 0.8.1
%define release 1
%define serial 1

# Override standard libdir with xmms config
%define _libdir /usr/lib/xmms/Effect

#### Useful macros
# Attempt to avoid disaster
%define clean_build_root if test -O "%{buildroot}" -a "%{buildroot}" != "/" -a "%{buildroot}" != "$HOME"; then %{__rm} -rf %{buildroot}; fi
# To delete directory where compilation takes place
%define clean_build_dir %{__rm} -rf %{buildsubdir}

#### Header
Summary: XMMS - Plugin for Normalizing Volume
Name: %{name}
Version: %{version}
Release: %{release}
Serial: %{serial}
Copyright: GPL
Group: Applications/Multimedia
Vendor: Baruch Even <baruch@users.sourceforge.net>
Packager: %packager
Url: http://volnorm.sourceforge.net/
Source: %{name}-%{version}.tar.gz
Prefix: %{_prefix}
Requires: xmms
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root

#### Description
%description
This XMMS plugin changes the volume of played songs to a uniform level such
that the base volume of all songs will be the same so that you will not need to
play with the volume knob whenever a song changes.

#### Prep
%prep
%setup -q

#### Build
%build
%configure
# Build user might have his/her own special "make" hooks
%__make

#### Install
%install
%clean_build_root
%{!?makeinstall: %define makeinstall make DESTDIR="$RPM_BUILD_ROOT" install}
%makeinstall

#### Clean
%clean
%clean_build_root
%clean_build_dir

#### Post
# Nothing to do

#### Files
%files
%defattr(-, root, root)
%doc AUTHORS BUGS COPYING ChangeLog INSTALL NEWS README RELEASE TODO
%{_bindir}/*
%{_libdir}/*
#%{_mandir}/man?/* 
#%{_datadir}/locale/*/LC_MESSAGES/* 

#### Changelog
%changelog

* Wed Jan 03 2001 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
- New spec file incorporated in tarball package

