#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>


/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif


#include "gtktopdata.h"
#include "gtksettings.h"

/*header in the settings (the template has no header)*/
#define GTKSETTINGS_HEADERSIZE 2


static void call_callback(GtkMenuItem     *menuitem)
{
  void (*callback)(GtkMenuItem* thismenuitem, gpointer userdata);
  gpointer   *settings =
    gtk_widget_get_data_top(GTK_WIDGET(menuitem),"settings");
  gpointer   *userdata =
    gtk_widget_get_data_top(GTK_WIDGET(menuitem),"userdata");
  g_assert(settings);
  callback =gtk_widget_get_data_top(GTK_WIDGET(menuitem),"callback");
  g_assert(callback==settings[0]);
  g_assert(userdata==settings[1]);
  if(callback)
    (*callback)(menuitem, settings[1]);
}

static
void
on_setting_activate    (GtkMenuItem     *menuitem,
			gpointer         thisitemsetting)
{  

#ifdef VERBOSE     
  g_message(" activate '%s' from %d to %d\n",
	    *(char **)thisitemsetting,
	    GPOINTER_TO_INT( *((gpointer *)thisitemsetting+1) ),
	    GTK_CHECK_MENU_ITEM(menuitem)->active);
#endif

  *((gpointer *)thisitemsetting+1 )=
    GINT_TO_POINTER(GTK_CHECK_MENU_ITEM(menuitem)->active);
  /* now we dont deal with accels */
  g_assert(  *((gpointer *)thisitemsetting+2)==NULL );
  call_callback(menuitem);
}

/* actually this is never called ... */
static
void
on_setting_toggle    (GtkMenuItem     *menuitem,
			gpointer         thisitemsetting)
{ 
  g_message(" toggle '%s' from %d to %d\n",
	    *(char **)thisitemsetting,
	    GPOINTER_TO_INT(*((gpointer *)
			      thisitemsetting+1 )),
	    GTK_CHECK_MENU_ITEM(menuitem)->active);
	 
  *( ((gpointer *)thisitemsetting) +1)=
    GINT_TO_POINTER(GTK_CHECK_MENU_ITEM(menuitem)->active);

  call_callback(menuitem);
}





//static inline
int
gtk_settings_get_value(char *name,gpointer thesettings[])
{
  int lp=GTKSETTINGS_HEADERSIZE;
  while( thesettings[lp]) { 
    if(strcmp(name,thesettings[lp])==0) {
      GtkWidget  *item = thesettings[lp+4];
      
      if ( GTK_CHECK_MENU_ITEM(item)->active 
	   != GPOINTER_TO_INT(thesettings[lp+1]))
	g_warning(" the item %s has value %d but the menu has value %d!\n",
		  *(char **)(thesettings+lp),
		  GPOINTER_TO_INT(thesettings[lp+1]),
		  GTK_CHECK_MENU_ITEM(item)->active
		);
      

      return GPOINTER_TO_INT(thesettings[lp+1]);

    }
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }
  g_warning("gtk_settings_get_value: setting '%s' not found", name);

  return 0;
}

//static inline
gboolean
gtk_settings_set_value(char *name,gpointer thesettings[], int value)
{
  int lp=GTKSETTINGS_HEADERSIZE;
  while( thesettings[lp]) { 
    if(strcmp(name,thesettings[lp])==0)
      {
	GtkWidget  *item = thesettings[lp+4];
	thesettings[lp+1] = GINT_TO_POINTER(value);
	/* FIXME is this relevant? 
	   if(!GTK_WIDGET_REALIZED(item))
	    g_warning(" item %s is not realized, while initializing to %d\n",
	              (char *)(thesettings[lp]),value);
	   else */
	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(item) ,
				       (value)?TRUE:FALSE);


	return TRUE;
      }
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }
  g_warning("gtk_settings_set_value: setting '%s' not found", name);

  return FALSE;
}




int
gtk_settings_template_size(/* template for the settings */
		   gpointer template[])
{
  /*find size */
  int lp=0;
  while(template[lp]) { 
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }  
  /* includes the final NULL and a HACK (FIXME)*/
  return lp+2;
}

gpointer
gtk_settings_alloc(/* template for the settings */
		   gpointer template[])
{
  int lp, size;
  /*find size */
  lp=gtk_settings_template_size(template); 
  /* includes   the header*/
  size=lp+GTKSETTINGS_HEADERSIZE;
  return g_malloc(size * sizeof(gpointer));
}

GtkWidget*
gtk_settings_create(gpointer template[],
		    gpointer *thesettings,
		    void (*callback)(),
		    gpointer userdata)
{
  GtkWidget *menuSettings;
  GtkAccelGroup *menuSettings_accels;
  GtkWidget *item;
  GtkTooltips *tooltips;
  int lp, size;

  g_assert(thesettings);

  /*find size */
  size= gtk_settings_template_size(template); 

  /* copy template */
  memcpy(thesettings+GTKSETTINGS_HEADERSIZE,template,
	 size*sizeof(gpointer) );
  /*translate*/
  lp=0;
  while(template[lp]) { 
    /* menu item IS NOT TRANSLATED here but below */
    thesettings[lp+GTKSETTINGS_HEADERSIZE]= (template[lp]);
    /* tooltip */
    thesettings[lp+3+GTKSETTINGS_HEADERSIZE]= _(template[lp+3]);
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  } 

  menuSettings = gtk_menu_new ();

  {
    //void (*callback)(GtkWidget* thismenu, gpointer userdata);
    //callback = thesettings[0];
    //g_assert(callback == callbac);
    thesettings[0]=callback;
    thesettings[1]=userdata;
    gtk_widget_set_data_top(menuSettings,"callback", callback);
    gtk_widget_set_data_top(menuSettings,"userdata", userdata);
    gtk_widget_set_data_top(menuSettings,"settings", thesettings);
  }

  tooltips = gtk_tooltips_new ();

  gtk_widget_set_name (menuSettings, "menuSettings");
  gtk_object_set_data (GTK_OBJECT (menuSettings),"menuSettings", menuSettings);
#if GTK_MAJOR_VERSION < 2
  //FIXME
  menuSettings_accels = gtk_menu_ensure_uline_accel_group 
    (GTK_MENU (menuSettings));
#endif


  lp=GTKSETTINGS_HEADERSIZE;
  while(thesettings[lp]) {
    char * name = ( char *)thesettings[lp],
      * tooltip = ( char *)thesettings[lp+3];
    thesettings[lp+4]= item = /* translate menu label */
      gtk_check_menu_item_new_with_label ( _(name) );
    
    gtk_widget_set_name (item,name);
    gtk_widget_ref (item );
    /* FIXME: what is this for? 
       gtk_object_set_data_full (GTK_OBJECT (menuSettings),
       " menu" , 
       item,
       (GtkDestroyNotify) gtk_widget_unref);

       gtk_object_set_data (GTK_OBJECT (menuSettings), "tooltips", tooltips);
    */
    gtk_widget_show (item);
    gtk_container_add (GTK_CONTAINER (menuSettings), item);
    if  ( tooltip[0] )
      gtk_tooltips_set_tip (tooltips, item, tooltip, NULL);
    if(thesettings[lp+1])
      gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item), TRUE);
    
    gtk_signal_connect (GTK_OBJECT (item), "activate",
    			GTK_SIGNAL_FUNC (on_setting_activate ),
    			thesettings+lp);
    gtk_signal_connect (GTK_OBJECT (item), "toggle",
    			GTK_SIGNAL_FUNC (on_setting_toggle ),
    			thesettings+lp);
    
    lp+=GTKSETTINGS_BLOCKS_SIZE;
  }
  
  return menuSettings;
}
