#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdio.h>
#include <strings.h>
#include <string.h>
#include <errno.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>

//NO WE USE g_assert for portability
//#include "assert.h"

#include <gtk/gtk.h>

#ifdef USE_IMLIB
#include <gdk_imlib.h>
#else
#include <gdk-pixbuf/gdk-pixbuf.h>
#endif

#include <gdk/gdk.h>


#include "gdk-pixbuf-extra.h"

#include "gtktopdata.h"

#include "libmorph/warp.h"
#include "libmorph/warp2.h"
#include "libmorph/warp-gtk.h"
#include "libmorph/resample.h"

#include "callbacks.h"
#include "interface.h"
#include "support.h"
//#include "pixmaps.h"
#include "mesh-gtk.h"
#include "utils.h"
#include "main.h"
#include "settings.h"

#include "libmorph/mesh.h"

extern gtkmorph_status_t   *sp ;


/*******************************************************************/




/***************************** colors ***************/


/* color flashing */
GdkGC *flash_gc;


GdkColor    colors[] =   {
  //selected points, 
  {    0L,     63 * 1024,     63 * 1024,     40 * 1024   },
  //unselected points. This color is used also for lines
  {    0L,     40 * 1024,     50 * 1024,     40 * 1024   },

  //all these are for features
  //so, to change from feature_n to feature_gc you have to add 2
  //so, to change from feature_n to mesh label you have to add 1
  //{    0L,     63 * 1024,     63 * 1024,     63 * 1024   },
  //{    0L,     63 * 1024,     63 * 1024,     30 * 1024   },
  {    0L,     63 * 1024,     30 * 1024,     30 * 1024   },
  {    0L,     63 * 1024,     30 * 1024,     63 * 1024   },
  {    0L,     30 * 1024,     63 * 1024,     63 * 1024   },
  {    0L,     30 * 1024,     63 * 1024,     30 * 1024   },
  {    0L,     30 * 1024,     30 * 1024,     63 * 1024   },
  {    0L,     30 * 1024,     30 * 1024,     30 * 1024   },

  //{    0L,     63 * 1024,     63 * 1024,     63 * 1024   },
  {    0L,     63 * 1024,     63 * 1024,     50 * 1024   },
  {    0L,     63 * 1024,     50 * 1024,     63 * 1024   },
  {    0L,     63 * 1024,     50 * 1024,     50 * 1024   },
  {    0L,     50 * 1024,     63 * 1024,     63 * 1024   },
  {    0L,     50 * 1024,     63 * 1024,     50 * 1024   },
  {    0L,     50 * 1024,     50 * 1024,     63 * 1024   },
  {    0L,     50 * 1024,     50 * 1024,     50 * 1024   },

  //{    0L,     63 * 1024,     63 * 1024,     63 * 1024   },
  {    0L,     63 * 1024,     63 * 1024,     10 * 1024   },
  {    0L,     63 * 1024,     10 * 1024,     63 * 1024   },
  {    0L,     63 * 1024,     10 * 1024,     10 * 1024   },
  {    0L,     10 * 1024,     63 * 1024,     63 * 1024   },
  {    0L,     10 * 1024,     63 * 1024,     10 * 1024   },
  {    0L,     10 * 1024,     10 * 1024,     63 * 1024   },
  //{    0L,     10 * 1024,     10 * 1024,     10 * 1024   },

  //{    0L,     40 * 1024,     40 * 1024,     40 * 1024   },
  {    0L,     40 * 1024,     40 * 1024,     30 * 1024   },
  {    0L,     40 * 1024,     30 * 1024,     40 * 1024   },
  {    0L,     40 * 1024,     30 * 1024,     30 * 1024   },
  {    0L,     30 * 1024,     40 * 1024,     40 * 1024   },
  {    0L,     30 * 1024,     40 * 1024,     30 * 1024   },
  {    0L,     30 * 1024,     30 * 1024,     40 * 1024   },
  {    0L,     30 * 1024,     30 * 1024,     30 * 1024   }

};
GdkGC  *features_gc[100];
int features_max_n=sizeof(colors)/sizeof(GdkColor)-2;


/* color for selected points */
//GdkGC   *mps_gc;
/* color for resulting points */
//GdkGC   *mpr_gc;
/* color for mesh lines */
GdkGC *mpl_gc;


void allocate_colors(GtkWidget * widget)
{
  /* allocate colors */
  int lp=sizeof(colors)/sizeof(GdkColor)-1;

  g_message("allocating colors");

  //features_max_n=lp-2;

  g_assert(widget->window);
  g_assert(lp<100);
  for(;lp>=0;lp--) {
    features_gc[lp] = gdk_gc_new(widget->window);
    gdk_gc_copy(features_gc[lp], widget->style->white_gc );
    if(gdk_colormap_alloc_color (gdk_colormap_get_system (),
				 & (colors[lp]),
				 FALSE , //gboolean writeable,
				 TRUE //gboolean best_match
				 )
       == FALSE)
      g_warning("%s %d : can't allocate color\n",__FILE__,__LINE__);
    else
      gdk_gc_set_foreground ( features_gc[lp], &(colors[lp])); 
    g_assert(features_gc[lp]);
  }

  //FIXME CRUDE PROGRAMMING
  
  mpl_gc=gdk_gc_new(widget->window);
  g_assert(mpl_gc);
  gdk_gc_copy(mpl_gc, features_gc[1] );
  gdk_gc_set_line_attributes (mpl_gc,
			      1, //gint line_width,
			      GDK_LINE_DOUBLE_DASH,//GdkLineStyle line_style,
			      GDK_CAP_BUTT, //GdkCapStyle cap_style,
			      GDK_JOIN_MITER //GdkJoinStyle join_style
			      );

#ifdef FIXME
  /* the xor method  flashes on/off 
       we should use the same clipping rectangle as above, but we dont */
  gdk_gc_set_function(mpl_gc,GDK_XOR);
#endif

  flash_gc = gdk_gc_new(widget->window);
  gdk_gc_copy(flash_gc,mpl_gc );
  gdk_gc_set_function(flash_gc,GDK_XOR);
    
  //  mps_gc= features_gc[0];
  //mpr_gc= features_gc[1];

}






























/***********************************************************************
allocates / deallocate  pixbufs and pixmaps

********************************************************************/


/* which image are we displaying?    */

GdkPixbuf **
which_pixbuf(int lp, enum what_display what)
{
  GdkPixbuf **pb ;
  g_assert(lp>0 && lp < MAX_WINS+2);
  switch( what)
    {
    case PIXLOADED:
      pb=&sp->im_loaded_pixbuf[lp];      
      break;
    case PIXSUBIMAGE:
      pb=&sp->im_subimage_pixbuf[lp];
      break; 
    case PIXWARPED:
      pb=&sp->im_warped_pixbuf[lp];
      break;
    default: abort();
    }
  return pb;
}

GdkPixbuf **
which_pixbuf_is_visible(int lp)
{
  return which_pixbuf(lp,sp->which_pix[lp]);
}

GdkPixmap **
which_pixmap(int lp, enum what_display what)
{
  GdkPixmap **pb ;
  g_assert(lp>0 && lp < MAX_WINS+2);
  switch( what)
    {
    case PIXLOADED:
      pb=&sp->im_loaded_pixmap[lp];
      break;
    case PIXSUBIMAGE:
      pb=&sp->im_subimage_pixmap[lp];
      break; 
    case PIXWARPED:
      pb=&sp->im_warped_pixmap[lp];
      break;
    default: abort();
    }
  return pb;
}

GdkPixmap **
which_pixmap_is_visible(int lp)
{
  return which_pixmap(lp,sp->which_pix[lp]);
}


void
destroy_pixbuf(int lp, enum what_display what)
{
  GdkPixbuf **pb=which_pixbuf(lp,what);
  if(*pb)
    gdk_pixbuf_unref(*pb);
  else
    g_critical("gtkmorph (%s:%d) destroy pixbuf [%d] type %d which is already NULL\n",
	       __FILE__,__LINE__,lp, what);
  *pb=NULL;
}

void
destroy_pixmap(int lp, enum what_display what)
{
  GdkPixmap **pm=which_pixmap(lp,what);
  if(*pm)
    gdk_pixmap_unref(*pm);
  else
    g_critical("gtkmorph (%s:%d) destroy pixmap [%d] type %d which is already NULL\n",
	       __FILE__,__LINE__, lp, what);
  *pm=NULL;
}

void
create__pixbuf(int lp, enum what_display what)
{
  GdkPixbuf **pb=which_pixbuf(lp,what);
  int w,h;
  which_pixbuf_size(lp, what, &w, &h);

  g_assert(*pb == NULL);

  *pb=gdk_pixbuf_new (GDK_COLORSPACE_RGB,//GdkColorspace colorspace,
		      FALSE, //gboolean has_alpha,
		      8,//int bits_per_sample,
		      w,h); //HACK FIXME sp->resulting_width, sp->resulting_height);
  g_assert( gdk_pixbuf_get_bits_per_sample (*pb) == 8);  
  gdk_pixbuf_clear(*pb);
  //FIXME *pb is not a drawable
  //  if(back_font && mpl_gc) { const gchar *text="ciao bello";
  //  gdk_draw_text((*pb),//GdkDrawable *drawable,
  //		  back_font,//GdkFont *font,
  //		  mpl_gc,//sp->im_widget[lp]->style->white_gc,//GdkGC *gc,
  //		  10,10,//gint x, gint y,
  //		  text,4);//const gchar *text,  gint text_length);
  //}
}

void
create__pixmap(int lp, enum what_display what)
{
  GdkPixmap **pm=which_pixmap(lp,what);
  int w,h;
  static GdkFont* back_font=NULL;
  char *xlfd="-*-helvetica-*-r-normal--*-120-*-*-*-*-iso8859-1";
  if(!back_font) {
    back_font=gdk_font_load(xlfd); //const gchar *font_name);
    if(!back_font)
      g_warning("can't load font %s",xlfd);
  }

  which_pixbuf_size(lp, what, &w, &h);
  /* some border around the image */
  if ( what == PIXLOADED)
    { w+=2*PIXLOADEDBORDER; h+=2*PIXLOADEDBORDER; }
  else if ( what == PIXSUBIMAGE)
    { w+=2*PIXEDITBORDER; h+=2*PIXEDITBORDER; }

  g_assert(*pm == NULL);
  
  /* creates backing pixmaps anyway */
  *pm = gdk_pixmap_new(sp->im_widget[lp]->window,
		       w,
		       h,
		       -1);
  
  gdk_draw_rectangle (*pm,
		      sp->im_widget[lp]->style->black_gc,
		      TRUE,
		      0, 0,
		      w,
		      h);
  
  if(back_font ) { const gchar *text="(no image loaded)";
    gdk_draw_text((*pm),//GdkDrawable *drawable,
  		  back_font,//GdkFont *font,
  		  sp->im_widget[lp]->style->white_gc,//GdkGC *gc,
  		  PIXEDITBORDER+30,PIXEDITBORDER+30,//gint x, gint y,
  		  text,strlen(text));//const gchar *text,  gint text_length);
  }
}

static void dim(GdkPixbuf* new)
{
  int i,j,
    width =  gdk_pixbuf_get_width(new),
    height = gdk_pixbuf_get_height(new);
  int rowstride= gdk_pixbuf_get_rowstride (new) ;
  guchar  *data = gdk_pixbuf_get_pixels(new);
  long  dp=0; 
  int ch= gdk_pixbuf_get_n_channels(new);
  if(ch!=3)
      g_warning("gtkmorph (%s:%d:%s) image has %d channels! dimming may fail",
		__FILE__,__LINE__,__FUNCTION__,ch);
  for( j=0; j<  height ; j++)
    {
      dp= rowstride * j;
      for( i=0; i<  width*ch ; i++) {
	data[dp] = data[dp] * 3/4;
	dp++;
      }
    }
}

void
render_pixmap(int lp, enum what_display what)
{
  GdkPixbuf **pb=which_pixbuf(lp,what);
  GdkPixmap **pm=which_pixmap(lp,what);
  int w,h;

  which_pixbuf_size(lp, what, &w, &h);

  if( *pm==NULL) {
    g_critical("creating pixmap [%d] type %d",lp,what);
    create__pixmap(lp,what);
  }
  if( *pb==NULL) {
    g_critical("creating pixbuf [%d] type %d",lp,what);
    create__pixbuf(lp,what);
  }
#ifdef DIM
  //FIXME dim image a bit to better view mesh DONE BELOW
  gdk_pixbuf_saturate_and_pixelate
                                            (const GdkPixbuf *src,
                                             GdkPixbuf *dest,
                                             gfloat saturation,
                                             gboolean pixelate);
#endif
  
  {
    int dx=0, dy=0;
    GdkPixbuf* new;
    if ( what == PIXLOADED )
      { dy+=PIXLOADEDBORDER; dx+=PIXLOADEDBORDER; }
     if (  what == PIXSUBIMAGE)
      { dy+=PIXEDITBORDER; dx+=PIXEDITBORDER; }
    
    if(what != PIXWARPED && image_settings_get_value("dim image",lp)) 
      {
	new=gdk_pixbuf_copy (*pb);
	dim(new);
      }
    else
      {
	new=*pb;
	gdk_pixbuf_ref(new);
      }
    gdk_pixbuf_render_to_drawable  
      (new,
       *pm,
       sp->im_widget[lp]->style->black_gc, //GdkGC *gc,
       0, //int src_x,
       0, //int src_y,
       dx, //int dest_x,
       dy, //int dest_y,
       w,h, //width, height,
       GDK_RGB_DITHER_NORMAL,//GdkRgbDither dither,
       0, //int x_dither,
       0 ); //int y_dither);
    gdk_pixbuf_unref(new);
  }
}

















/*********************** 
			 some commonly used routines 
********************** 
*/



void set_sensitive(GtkWidget * widget, gboolean flag)
{
  if(flag) {
    gtk_widget_show(widget);  
    gtk_widget_set_sensitive(widget,flag);
  } else {
    if(settings_get_value("hide unusable"))
      {
      	gtk_widget_hide(widget);
      }
    else {
      gtk_widget_show(widget);  
      gtk_widget_set_sensitive(widget,flag);
    }
  }
}

void   set_frame_label(int i)
{
  GtkWidget *m=lookup_widget(sp->im_widget[i],"image_frame");
  gchar *t;
  double dist;
  g_assert(m);


  if(sp->im_editview[i] == EDITVIEW_EDIT  
     || sp->im_editview[i] == EDITVIEW_EYES ) {
    if(i== MAIN_WIN)
	t=  _("template image");
    else
      t=  _("input image");
    if(sp-> im_filename_in[i])
      t=g_strdup_printf("%s: %s",t,sp-> im_filename_in[i]);
    
  } else {
    if(i== MAIN_WIN) //FIXME if only one input?
      t= _("morphed image");
    else
      t= _("warped image");
    if(sp-> im_filename_out[i])
      t=g_strdup_printf("%s: %s",t,sp-> im_filename_out[i]);
    }
  if ( i != MAIN_WIN ) {
    dist=meshDistance(&sp->im_mesh[i],&sp->im_mesh[MAIN_WIN],0);
    //g_message("%i dist %g",i, dist);
    t=g_strdup_printf("%s, dist %.1f",t,dist);
  }
  gtk_frame_set_label(GTK_FRAME(m),t);
}    


/*sets things according to the edit view menu value */
void
editview_callback(int i)
{
  set_frame_label(i);  

  if(i!= MAIN_WIN)    {
    GtkWidget *m=gtk_widget_get_data_top(sp->im_widget[i],"handleboxsubimage");
    g_assert(m);
    set_sensitive(m,(sp->im_editview[i] == EDITVIEW_EYES));
    setup_handlebox_factor(i);
  }

  if(sp->im_editview[i] == EDITVIEW_EYES)
    sp->which_pix[i]=PIXLOADED;
  else
    if(sp->im_editview[i] == EDITVIEW_SHOW ||
       sp->im_editview[i] == EDITVIEW_SHOWMESHES )
      sp->which_pix[i]=PIXWARPED;
    else
      sp->which_pix[i]=PIXSUBIMAGE;

  switch (sp->im_editview[i]) {
  case EDITVIEW_EDIT:
    image_settings_set_value("dim image",i,1);
    image_settings_set_value("view original mesh",  i, 1);
    image_settings_set_value("view original points",  i, 1);
    image_settings_set_value("view warped mesh",  i, 0);
    image_settings_set_value("view warped points",  i, 0);
    image_settings_set_value("view eyes",i,0);
    //image_settings_set_value("view .../loaded image/subimage/warped image/",  i, 1);
    image_settings_set_value("mesh is readonly",  i, 0);
    break;
  case EDITVIEW_SHOW:    
    image_settings_set_value("dim image",i,0);
    image_settings_set_value("view original mesh",  i, 0);
    image_settings_set_value("view original points",  i, 0);
    image_settings_set_value("view warped mesh",  i, 0);
    image_settings_set_value("view warped points",  i, 0);
    image_settings_set_value("view eyes",i,0);
    //image_settings_set_value("view .../loaded image/subimage/warped image/",  i, 2);
    image_settings_set_value("mesh is readonly",  i, 1);
    break;
  case EDITVIEW_SHOWMESHES:
    image_settings_set_value("dim image",i,1);
    image_settings_set_value("view original mesh",  i, 1);
    image_settings_set_value("view original points",  i, 1);
    image_settings_set_value("view warped mesh",  i, 1);
    image_settings_set_value("view warped points",  i, 1);
    image_settings_set_value("view eyes",i,0);
    //image_settings_set_value("view .../loaded image/subimage/warped image/", i, 2);
    image_settings_set_value("mesh is readonly",  i,1);
    break;
  case EDITVIEW_EYES:
    {
      int f=0;
      if(i==MAIN_WIN) f=!0;
      //image_settings_set_value("dim image",i,1);
      image_settings_set_value("view original mesh",  i, !f);
      image_settings_set_value("view original points",  i, !f);
      image_settings_set_value("view warped mesh",  i, f);
      image_settings_set_value("view warped points",  i, f);
      image_settings_set_value("view eyes",i,1);
      //image_settings_set_value("view .../loaded image/subimage/warped image/",  i, 0);
      image_settings_set_value("mesh is readonly",  i, 1);
    }
    break;
    //case EDITVIEW_SHOWANIM:
    //g_critical("showanim unimplemented");
  }
  
  drawingarea_configure(i);
/*   gtk_signal_emit_by_name         (sp->im_widget[i],//  GtkObject *object, */
/* 				   "configure-event",//const gchar *name, */
/* 				   NULL,NULL,NULL); */
  //gtk_widget_configure(sp->im_widget[i]);
}



/** sets the state of all  widgets: visible invisible etc etc**/
void set_state()
{
  int i,s;

  mesh_resample_use_aa(settings_get_value( "use antialiasing warping"));

  for(i=0;i<MAIN_WIN;i++) {
    if(sp->im_widget[i]) {
      setup_handlebox_factor(i);
      editview_callback(i);
    }
  }
  i= MAIN_WIN;
  s=settings_get_value( "automatic mesh interpolation");
  //if(sp->im_widget[i])
  {
    GtkWidget *m=
      lookup_widget(sp->im_widget[i],"button_interp_meshes");
    g_assert(m);
    set_sensitive(m,!s);
  }
  s=settings_get_value( "automatic blending");
  {
    GtkWidget *m=
      lookup_widget(sp->im_widget[i],"do_mixing");
    g_assert(m);
    set_sensitive(m,!s);
  }
  {
    GtkWidget *m=gtk_widget_get_data_top(sp->im_widget[i],"hbox_feature");
    int flag=//(sp->im_editview[i] == EDITVIEW_FEATURES) &&
      settings_get_value("edit features");
    int l=0;
    gchar *T[]={"tool_select","tool_unselect","tool_assign",NULL};
    g_assert(m);
    set_sensitive(m,flag);
    while(T[l]) {
      GtkWidget *m=gtk_widget_get_data_top(sp->im_widget[i],T[l]);
      set_sensitive(m,flag);
      l++;
    }
  }
}



/******** sets the "edit mesh/show warp" option menu value */

void
set_editview(int lp, /* window number */
	     int status)
{
  
  /* this trick comes from the FAQ of glade*/
  GtkWidget * option_menu = lookup_widget (sp->im_widget[lp],
					   "optionmenu_editview");
  sp->im_editview[lp]=status;

  gtk_option_menu_set_history(GTK_OPTION_MENU( option_menu),
			      status);
  
  editview_callback(lp);

  //FIXME HACK HACK lets see what happens if I skip this 
  //gtk_widget_draw(option_menu, NULL);
}  

/*****************************************************/



static void __after_warp(int lp)
{
  int val=1;

  val =  settings_get_value("warped image in other win");      
  if( val)
    {
      if( sp->im_warped_widget[lp]==NULL) {
	sp->im_warped_widget[lp]=create_window_warped(); 
	gtk_widget_set_data_top(sp->im_warped_widget[lp],"imagenum",
				GUINT_TO_POINTER(lp));
      }
      {
	/* resizes the viewport so that the scrolling bars will work ok */ 
	int w=sp->resulting_width, h=sp->resulting_height;
	  
	GtkWidget *g =gtk_widget_get_data_top
	  (sp->im_warped_widget[lp],"drawingarea_warped");
	g_assert(g);
	gtk_widget_set_usize(g,  w,h);
      }

      render_pixmap(lp,2);
      gtk_widget_show (sp->im_warped_widget[lp]); 
      gtk_widget_draw (sp->im_warped_widget[lp] , NULL); 
    }
  else
    {	
      if(settings_get_value( "show warp after warp"))
	set_editview(lp, EDITVIEW_SHOW);

      render_pixmap(lp,2);
      gtk_widget_show (sp->im_widget[lp]);  
      gtk_widget_draw (sp->im_widget[lp] , NULL);  
    }
}



void
do_warp_an_image_new(int lp)
{
  GdkPixbuf *pb = * which_pixbuf(lp,PIXWARPED);
  if(pb==NULL) {
    create__pixbuf(lp,PIXWARPED);
  }
  warp_image_gdk_m
    (* which_pixbuf(lp,PIXSUBIMAGE),
     * which_pixbuf(lp,PIXWARPED),
     & sp-> im_mesh[lp],
     & sp-> im_mesh[MAIN_WIN]);
  __after_warp(lp);
}





/********************************************************************
		loads image from pixbuf to pixmap for image window "lp"
		you should unref the pixbuf   when it exists
		
		copies its data to r,g,b,
*/

void scale_loaded_pixbuf_et_rrggbb(
				   //GdkPixbuf      *impixfile,
		 int lp //image number
		 )
{
  GdkPixbuf 
    ** pbl = which_pixbuf(lp,PIXLOADED),
    **pbs = which_pixbuf(lp,PIXSUBIMAGE);

  double *a=sp->transforms[lp].loaded2subimage;

  if(a[0]==1. && a[1]==0. && a[2]==0. && 
     a[3]==0. && a[4]==1. && a[5]==0. ) {
    gdk_pixbuf_unref(*pbs);
    *pbs=gdk_pixbuf_copy(*pbl);
  } else
    gdk_pixbuf_scale(*pbl,//const GdkPixbuf *src,
		     *pbs,//GdkPixbuf *dest,
		     0,0,//int dest_x,  int dest_y,
		     sp->resulting_width,//int dest_width,
		     sp->resulting_height,//int dest_height,
		     a[2],//double offset_x,
		     a[5],//double offset_y,
		     a[0],//double scale_x,
		     a[4],//double scale_y,
		     GDK_INTERP_HYPER); //GdkInterpType interp_type);

  
  render_pixmap(lp,PIXSUBIMAGE);

#ifdef STORE_RRGGBB
  pixbuf_to_rrrgggbb(*pbs,
		     sp->red[lp],
		     sp->green[lp],
		     sp->blue[lp]  );
#endif
}










/***************************************************************

 *		drawing area bookkeeping

 ***********************************************************
*/ 




void
drawingarea_configure (int i)
{
  int w,h;
  g_return_if_fail(sp-> im_widget[i]);

  {
    GtkWidget *d=gtk_widget_get_data_top((sp->im_widget[i]),
					 "drawingarea widget");
    if(d) {
      which_pixbuf_size(i,sp->which_pix[i],  &w, &h);
    /* some border around the image */
      if ( sp->which_pix[i] == PIXLOADED)
	{ w+=2*PIXLOADEDBORDER; h+=2*PIXLOADEDBORDER; }
      /* some border around the image */
      if ( sp->which_pix[i] == PIXSUBIMAGE)
	{ w+=2*PIXEDITBORDER; h+=2*PIXEDITBORDER; }

      //FIXME I think this is already done render_pixmap(i, sp->which_pix[i]); 
      
      /* resizes the viewport so that the scrolling bars will work ok */
      //g_message("scrolled viewport set to %d w %d h %d",i,w,h);
      gtk_widget_set_usize(d,      w,h);
    }
  }

  if ( sp->which_pix[i] == PIXSUBIMAGE) {

    GtkScrolledWindow *d=gtk_widget_get_data_top((sp->im_widget[i]),
						 "scrolledwindow_image");
    if(d) {
      GtkAdjustment* H=gtk_scrolled_window_get_hadjustment(d);
      GtkAdjustment* V=gtk_scrolled_window_get_vadjustment(d);
      //g_message("scrolled %d",i);
      if( H && V ) {
	H->value=PIXEDITBORDER;
	V->value=PIXEDITBORDER;
	gtk_scrolled_window_set_hadjustment(d,H);
	gtk_scrolled_window_set_vadjustment(d,V);
	gtk_adjustment_value_changed(H);
	gtk_adjustment_value_changed(V);
	
	if(sp->im_widget[i])
	  gtk_widget_draw (sp->im_widget[i] , NULL);
	else g_warning("redraw %i unavailable",i);
      }
    }   else g_warning("scrolls %i unavailable",i);
  }

  //else
  /* this is not an error: this function gets called before the
     windows are realized :-( */
  //g_warning("drawing area %i unavailable\n",i);
}




/*     GtkWidget *d=NULL; */
/*     if(sp->im_drawingarea_widget[i]) { */
/*       d=gtk_widget_get_parent( sp->im_drawingarea_widget[i]); */
/*       //d=gtk_bin_get_child(d); */
/*       if(d && !GTK_IS_VIEWPORT (d)) */
/* 	d=gtk_widget_get_parent(d); */
/*       if(d && !GTK_IS_VIEWPORT (d)) */
/* 	d=gtk_widget_get_parent(d); */
/*       if(d && !GTK_IS_VIEWPORT (d)) */
/* 	d=gtk_widget_get_parent(d); */
/*       if(d && GTK_IS_VIEWPORT (d)) {  */
/* 	//DARNED GTK */
/* 	GtkAdjustment* HH=gtk_viewport_get_hadjustment(d); */
/* 	GtkAdjustment* VV=gtk_viewport_get_vadjustment(d); */
/* 	g_message("viewport %d",i); */
/* 	if(HH && VV ) { */
/* 	  HH->value=PIXEDITBORDER; */
/* 	  VV->value=PIXEDITBORDER; */
/* 	  gtk_adjustment_value_changed(HH); */
/* 	  gtk_adjustment_value_changed(VV); */
/* 	  if(sp->im_drawingarea_widget[i]) */
/* 	    gtk_widget_draw (sp->im_drawingarea_widget[i] , NULL); */
/* 	} */
/*       } */
/*     } */
/*     else  */
/*       { */
/*     } */





/************************************************************************/


/************************************************************************

************************************************************************

 load/save hooks 

 see  on_ok_button1_realize ()

************************************************************************

************************************************************************/

inline  void 
showerr(const char *file, const char *msg)
{
  char *s = 
	g_strdup_printf( msg, file, strerror(errno));
			
  show_error(s  );
  g_free(s);
}



gboolean is_null(const gchar *s)
{
  if(strlen(s) == 0)
    {
      show_error(_("please provide a filename"));
      return TRUE;
    }
  return FALSE;
}




gboolean save_session(int ignored,
		      const char *file)
{
  FILE *f;
  int lp;
#ifdef HAVE_UNISTD_H
  int c;
  char cwd[PATH_MAX];
  getcwd(cwd,PATH_MAX);
  c=strlen(cwd);
  /* delete the common initial part of cwd and filename */
#define REDUCE_CWD(A) ( (strlen(A)>=(c+1) && 0==strncmp((A),cwd,c) && (A)[c] == '/' ) ? (A)+c+1:(A))
#else
#define REDUCE_CWD(A) (A)
#endif
 
  if(is_null(file)) return FALSE;

  if((f=fopen(file, "w"))==NULL) {
    showerr(file, _("could not open file '%s' for write: %s") );
    return FALSE; 
  }
  fprintf(f,"<gtkmorph session>\n");
#ifdef HAVE_UNISTD_H
  fprintf(f,"<cwd>\n%s\n</cwd>\n",cwd);
#endif
 for(lp=1;lp<=MAX_WINS; lp++)
    if(sp->im_widget[lp] != NULL)
      {
	if(sp->im_filename_in[lp]) {
	  fprintf(f,"<image>\n");
	  fprintf(f,"<image file in>\n%s\n</image file in>\n",
		  REDUCE_CWD(sp->im_filename_in[lp]));
	  fprintf(f,"<preserve aspect>\n%d\n</preserve aspect>\n",
		  image_settings_get_value("preserve aspect ratio",lp));
	  if(sp->im_mesh_filename[lp]) 
	    fprintf(f,"<mesh file>\n%s\n</mesh file>\n",
		    REDUCE_CWD(sp->im_mesh_filename[lp]));
	  fprintf(f,"<morph factors>\n%f %f\n</morph factors>\n",
		  sp->mf.im_warp_factor[lp],
		  sp->mf.im_dissolve_factor[lp]);
	  fprintf(f,"</image>\n");
	}
      }
  fprintf(f,"<resulting_size>\n%d %d\n</resulting_size>\n",
	 sp->resulting_width,sp->resulting_height);
  fprintf(f,"</gtkmorph session>\n");
  fclose(f);
  return TRUE;
}

static inline void de_n(char *s)
{ int l=strlen(s);  if(s[l-1]=='\n') s[l-1]=0; }

static inline void close_tag(FILE *f)
{
  char s[PATH_MAX+1];
  fgets(s,PATH_MAX,f);
  if( s[0]!='<' || s[1]!='/') {
    de_n(s);
    g_message("malformed session: '%s' is not a closing tag",s);
  } 
}


static gboolean load_session_stanza(FILE *f)
{
  int aspect=-3333, equal=0;
  float a=-3333.3,b=-3333.3;
  const  int lens=PATH_MAX;
  char s[lens+1],  imagename[lens+1], meshname[lens+1];

  imagename[0]=meshname[0]=0; 
  fgets(s,lens,f); de_n(s); /* tag? */
  while( !feof(f) && 0!=strcmp(s,"</image>") ) {
    /********* image tags loop *********/
    if( s[0]!='<' || s[1]=='/' ) {
      /* attemp syncronization */
      g_message("malformed session: '%s' is not an opening tag in image",s);
    } else
      if(0==strcmp(s,"<image file in>")) {
	fgets(imagename,lens,f); /* file name */
	de_n(imagename); close_tag(f);
      } else
	if( 0==strcmp(s,"<mesh file>")) {
	  fgets(meshname,lens,f);
	  de_n(meshname); close_tag(f);
	} else
	  if( 0==strcmp(s,"<preserve aspect>")) {
	    fgets(s,lens,f); 
	    sscanf(s,"%d",&aspect);     close_tag(f);  
	  } else
	    if( 0==strcmp(s,"<morph factors>")) {
	      fgets(s,lens,f); 
	      sscanf(s,"%f %f",&a,&b);  close_tag(f);
	    } else
	      g_message("session file: line '%s' was unrecognized in image\n",
			s);
    fgets(s,lens,f); de_n(s);/* tag? */
  }    /********* end image tags loop *********/
      
  if(imagename[0]==0) {
    g_message("malformed session: no image filename");
    return FALSE;
  }
  {/* look if it has already been loaded */
    int empty=0;
    { 
      int lp;
      /* FIXME < or <= ?? */
      for(lp=1;lp<MAX_WINS; lp++) {
	if(sp->im_widget[lp] != NULL) {	  
	  if(sp->im_filename_in[lp] &&
	     0==strcmp(sp->im_filename_in[lp],imagename)) {
	    equal=lp;	    
	  }
	  /* if the user has not used this image... we reuse it */
	  if(!image_used(lp)) { if(!empty) empty=lp; }
	} else  {
	  if(!empty) empty=lp; 
	}
      }
    }
    /* if not existent, create it now */
    if(equal==0) {
      if(empty==0) {
	show_error(_("can't reload the full session-no more available images"));
	return FALSE;
      } else {
	if(sp->im_widget[empty] == NULL) {
	  sp->max_wins++;
	  create_and_show_image_win(empty);	 
	}
      }
    }
    /* if not loaded, load it now */
    if(equal==0) {
      load_image_from_file(empty,imagename);
      equal=empty;
    }
  }
  if(equal==0) return TRUE;
  /* aspect */
  if(aspect!=-3333)
    image_settings_set_value("preserve aspect ratio",equal,aspect);

  /* mesh file */    
  if(sp->im_mesh_filename[equal]==NULL ||
     0!=strcmp(sp->im_mesh_filename[equal],meshname))
    load_mesh_from_file(equal,meshname);
    
  if(a!=-3333.3) { 
    sp->mf.im_warp_factor[equal]=a;
    sp->mf.im_dissolve_factor[equal]=b;
  }

  gtk_widget_show(sp->im_widget[equal]);
  return TRUE;
}



gboolean load_session(int ignored,
		      const char *file)
{
  FILE *f;  
  const  int lens=PATH_MAX;
  char s[lens+1], cwd[lens+1];

  if(is_null(file)) return FALSE;

  cwd[0]=0;
  if((f=fopen(file, "r"))==NULL) {
    showerr(file, _("could not open file '%s' for read: %s"));
    return FALSE; 
  }
  fgets(s,lens,f);
  if(strcmp(s,"<gtkmorph session>\n")) {
    show_error( _("parsing of session failed at first header!") );
    return FALSE;
  }
  fgets(s,lens,f);  de_n(s);
  while(!feof(f) && strcmp(s,"</gtkmorph session>") ) {
    /* attemp syncronization    */
    if( s[0]!='<' || s[1]=='/' ) {
      /* attemp syncronization */
      g_message("malformed session: '%s' is not an opening tag",s);
    } else
      if( 0==strcmp(s,"<cwd>") ) {
	fgets(cwd,lens,f); de_n(cwd);      
	if(chdir(cwd)) {
	  g_warning("Cannot change to CWD %s\n   as specified in the session file",cwd);
	  perror("");
	}
	close_tag(f);	
      } else
	if( 0==strcmp(s,"<resulting_size>") ) {
	  fgets(s,lens,f);
	  sscanf(s,"%d %d",
		 &sp->resulting_width_sp,&sp->resulting_height_sp);
	  spinbutton_res_set();
	  on_resulting_apply_clicked(NULL,NULL);
	  close_tag(f);
	} else 
	  if ( 0==strcmp(s,"<image>") ) {
	    load_session_stanza(f);
	  } 
	  else
	    g_message("session file: line '%s' was unrecognized\n",s);
    fgets(s,lens,f);de_n(s);
  }

  if(strcmp(s,"</gtkmorph session>")) {
    show_error(_("parsing of session failed"));
    return FALSE;
  }
  setup_handlebox_factors();
  fclose(f);
  return TRUE;
}










gboolean load_image_from_file(int lp,
			      const char *file)
{
  GdkPixbuf      *impixfile;

  g_assert(lp>0);

#if GTK_MAJOR_VERSION < 2  
  impixfile= gdk_pixbuf_new_from_file(file);
#else
  {
    //GError *err=NULL;
    impixfile= gdk_pixbuf_new_from_file(file,NULL);
    //FIXME should use err
  }
#endif

  if (impixfile ==NULL)
    {
      showerr(file,_("\
the attempt to load the image file %s as produced error: %s"));

      return FALSE;
    }
  else
    {

#ifndef RESCALE_RELOAD_LESS_MEM
      destroy_pixbuf(lp,PIXLOADED );
#endif      
      destroy_pixmap(lp,PIXLOADED );
      
            
      sp->im_width[lp]= gdk_pixbuf_get_width(impixfile);
      sp->im_height[lp]= gdk_pixbuf_get_height(impixfile);
      gtk_subimasel_reset( &(sp->subimasel[lp]) ,
			   sp->im_width[lp],
			   sp->im_height[lp]);
      subimage2affines(lp);
      sp->im_loaded_pixbuf[lp]=impixfile;
      create__pixmap(lp,PIXLOADED );
      render_pixmap(lp, PIXLOADED);

      scale_loaded_pixbuf_et_rrggbb(lp);
      render_pixmap(lp, PIXSUBIMAGE);
      //FIXME do we do this here?
      //render_pixmap(lp, PIXWARPED);

#ifdef RESCALE_RELOAD_LESS_MEM
      destroy_pixbuf(lp,PIXLOADED );
      impixfile=NULL;
#endif


      if(sp->im_filename_in[lp]!=NULL)
	g_free(sp->im_filename_in[lp]);
      
      sp->im_filename_in[lp]=g_strdup(file);
      {
	char s[600];
	sprintf(s,"%s %d: %s",_("in img"),lp,     file);
	gtk_window_set_title ( GTK_WINDOW(sp->im_widget[lp]),   s);
      }
      set_editview( lp, EDITVIEW_EYES); 

      drawingarea_configure(lp);

      gtk_widget_draw( sp-> im_widget[lp], NULL);  

      return TRUE;
    }  
}

/* reloads image , if necessary,  and rescales it */
void
reload_and_scale_image(int i)
{
  GdkPixbuf **impixfile = which_pixbuf(i,PIXLOADED);
  g_assert(i > 0);

  if(*impixfile == NULL) {
#ifndef RESCALE_RELOAD_LESS_MEM
    g_warning("lost original pixbuf %d... why???\n try reloading\n",i);
#endif
    if ( sp-> im_filename_in[i] == NULL
	 || strlen( sp-> im_filename_in[i]) == 0)	
      {
	show_error
	  ( g_strdup_printf(_("can't resize %dth image-no filename"),i));
	return;
      }
    /* reload */
#if GTK_MAJOR_VERSION < 2 
    *impixfile= gdk_pixbuf_new_from_file(sp-> im_filename_in[i]);
#else
    {
      GError *err=NULL;
      *impixfile= gdk_pixbuf_new_from_file(sp-> im_filename_in[i],&err);
      //FIXME should use err
    }
#endif
    if (*impixfile ==NULL)
      {
	showerr(sp-> im_filename_in[i], _("the attempt to reload the image file %s to resize it as produced error: %s"));
	create__pixbuf(i, PIXLOADED);
	return;
      }
  }
#ifdef RESCALE_RELOAD_LESS_MEM
  else {
    g_warning("the original pixbuf %d was not deallocated, reusing it\n",i);
    //FIXME why?? gdk_pixbuf_ref(*impixfile);
  }
#endif

  g_assert(*impixfile);
  g_assert(&(sp->im_loaded_pixbuf[i])==impixfile);
  render_pixmap(i, PIXLOADED);
  scale_loaded_pixbuf_et_rrggbb(i);
  render_pixmap(i, PIXSUBIMAGE);
#ifdef RESCALE_RELOAD_LESS_MEM
  delete_pixbuf(i, PIXLOADED);
#endif
}





/* it looks bad: it would be nicer if done with a static inline fun...
 but it must return the caller, not itself !*/

#define myfputc(F,C) \
{ \
 if( EOF == fputc(C,F)) { \
      showerr(file,_("\
the attempt to save the image file %s as produced error: %s")); \
      return FALSE; \
    } \
}

gboolean save_image_to_file(int lp,
			    const char *file)
{

  FILE *f;
  int  w= sp-> resulting_width;
  int h= sp-> resulting_height;
  int size;
  GdkPixbuf * pb=*(which_pixbuf_is_visible(lp));

  if(is_null(file)) return FALSE;

  if( pb ==NULL)
    {
      show_error(_("\
internal error: the image doesnt exist!"));
      return FALSE;
    }

  if(sp->im_filename_out[lp] == NULL ||
     0!=strcmp(sp->im_filename_out[lp],file)) {
    f = fopen(file, "r");
    if( f!=NULL)
      {
	showerr(file,_("\
This file already exists! If you really want to overwrite it, delete it."));
	fclose(f);
	return FALSE;
      }
  }
 

  f = fopen(file, "w");
  if( f ==NULL)
    {
      showerr(file,_("\
the attempt to save the image file %s as produced error: %s"));
      return FALSE;
    }
  

  /* save as ppm format */
  
  fprintf(f,"\
P6\n\
# CREATOR: " PACKAGE " " VERSION "\n\
%d %d\n\
255\n",
	  w,h);

  size= w*h;
 
  {
    guchar  *data = gdk_pixbuf_get_pixels(pb);	
    
    if ( fwrite(data, 3,size, f) != size)
      {
	showerr(file,_("\
the attempt to save the image file %s as produced error: %s"));
      }
  }

  if( 0 != fclose (f))
     showerr(file,_("\
the attempt to close the saved image file %s as produced error: %s"));

  sp->im_filename_out[lp]=g_strdup(file);

  return TRUE;  
}




static gboolean cmp_mesh_name(int lp,const char *file)
{
  int l;
  for ( l =1; l <= MAX_WINS; l++)
    if( sp->im_widget[l] != NULL && sp->im_mesh_filename[l] != NULL)
      if( l != lp && 
	  0==strcmp (file, sp->im_mesh_filename[l])) {
	gchar *s=
	  g_strdup_printf
	  (_("this filename is already used by the mesh of image %d") ,l);
	show_error(s);
	g_free(s);
	return FALSE;
      }

  return TRUE;
}



gboolean save_mesh_to_file(int lp, const char * file)
{
  FILE *fP;
/*   int c; */
/*   c=strlen(file); */
/*   /\* delete the common initial part of cwd and filename *\/ */
/* #define REDUCE__(A) ((0==strncmp(A,file,c)) ? (A)+c:(A)) */
  if(is_null(file)) return FALSE;

  if(lp==MAIN_WIN && settings_get_value("automatic mesh interpolation"))
    {
      if((fP=fopen(file, "r"))!=NULL)
	{
	  show_error(_("This mesh is automatically generated. You don't want to overwrite another mesh with this one!"));
	  fclose(fP);
	  return FALSE;
	}
    }

  if(!cmp_mesh_name(lp,file))
    return FALSE;

  if((fP=fopen(file, "w"))==NULL) {
    showerr(file, "could not open file '%s' for write: %s");
    return FALSE; 
  }
  if (meshWrite_stream( &(sp-> im_mesh[lp]), fP) ==0)
    {
      /* memory leak */
      sp->im_mesh_filename[lp] = g_strdup(file);
      sp-> subimasel[lp].orig_width = sp-> im_width[lp];
      sp-> subimasel[lp].orig_height = sp->im_height[lp];
      if(gtk_subimasel_save(&(sp-> subimasel[lp]), fP)==0) {
	if(sp->im_filename_in[lp])
	  fprintf(fP,"<image file name>\n%s\n</image file name>\n",
		  (sp->im_filename_in[lp]));
	fclose(fP);
	return TRUE;
      } else	{      
	  char *s = 
	    g_strdup_printf("\
the attempt to save the subimage selection in file %s as produced an internal error",
			    file);
	  show_error(s);	  
	  g_free(s);
	  fclose(fP);
	  return FALSE;
	}
    }
  else
    {      
      char *s = 
	g_strdup_printf("\
the attempt to save the mesh in file %s as produced an internal error",
			file);
			
      show_error(s);	  
      g_free(s);
      fclose(fP);
      return FALSE;
    }
  fclose(fP);
}














/****************************************************************************
 promote meshes to have same lines and columns 
***************************************************************************/



/* adds lines and columns to have this mesh of the given size */
void
promote_mesh(MeshT * mesh,int nx, int ny)
{
  while( nx > mesh->nx) {
    int i=0;
    while( i < mesh->nx-1 && mesh->nx < nx)
      {
	meshLineAdd(mesh, i, 0.5, 1);
	i+=2;
      }
  }
  while( ny > mesh->ny) {
    int i=0;
    while( i < mesh->ny-1 && mesh->ny < ny)
      {
	meshLineAdd(mesh, i, 0.5, 2);
	i+=2;
      }
  }
}

void
promote_meshes()
{
  int lp=MAIN_WIN;
  for(; lp>=0; lp--) 
    if( sp->im_widget[lp] != NULL) {
      int c=sp->im_mesh[lp].changed;
      promote_mesh(&sp->im_mesh[lp], sp->meshes_x,sp->meshes_y);
      if ( c != sp->im_mesh[lp].changed)
	gtk_widget_draw(sp->im_widget[lp],NULL);
    }
}
/***************************************************************
 synch mesh labels
********/

/* we want the negative labels to be the highest, as if casting to unsigned */
#define MESHLABELMAP(A)   (((A)<0)? 20000-(A) : (A))
#define MESHLABELDEMAP(A) (((A)>20000)? 20000-(A) : (A))
#define MAXLABEL(A,B) MESHLABELDEMAP( MAX( MESHLABELMAP(A),MESHLABELDEMAP(B)))

/***************************************************************
 load mesh from file
*/



gboolean load_mesh_from_file(int lp, const char * file)
{
  FILE *fP;
  //int c;
  if(is_null(file)) return FALSE;

  if(!cmp_mesh_name(lp,file))
    return FALSE;

  if((fP=fopen(file, "r"))==NULL) {
    showerr(file, "could not open file '%s' for read: %s");
    return FALSE; 
  }

  if (meshRead_stream( &(sp-> im_mesh[lp]), fP))   {
    show_error(_("the attempt to load mesh from file as produced an error\n(either this is not a mesh file, or the mesh file is corrupted)"));
    fclose(fP);
    return FALSE;
  }
  
  /* memory leak :-) */
  sp->im_mesh_filename[lp] = g_strdup(file);

#ifdef NO_BORDER_HACK
  {
    MeshT *m =&sp->im_mesh[lp];
    meshSetLabel(m,0,0,MESHPOINTSELECTED);
    meshSetLabel(m,0,m->ny-1,MESHPOINTSELECTED);
    meshSetLabel(m,m->nx-1,0,MESHPOINTSELECTED);
    meshSetLabel(m,m->nx-1,m->ny-1,MESHPOINTSELECTED);
  }
#endif
  
#ifdef THE_MESH_IS_NOW_FREE  
  meshScale( &(sp->im_mesh[lp]),
	     sp->resulting_width, sp->resulting_height);
#endif
  gtk_widget_draw( sp-> im_widget[lp], NULL);  
  
  sp->meshes_x= MAX(sp->meshes_x, sp->im_mesh[lp].nx);
  sp->meshes_y= MAX(sp->meshes_y, sp->im_mesh[lp].ny);
  
  if (settings_get_value("mesh auto sync")) {
    int xi,yi,t=0;
    MeshT *this, *res;
    promote_meshes();
    this=&(sp-> im_mesh[lp]);
    res=&(sp-> im_mesh[MAIN_WIN]);

    for(yi=0; yi < this->ny; yi++) {
      for(xi=0; xi < this->nx; xi++) {
	t+= meshGetLabel(this,xi,yi);
	/* this does a sort of fuzzy union */
	meshSetLabel(res, xi,yi,
		     MAXLABEL(meshGetLabel(this,xi,yi),
			      meshGetLabel(res ,xi,yi)));
      }}
    
    if(t==0) {
      /* this is an old style mesh, with no labels:
	 then we select all points so that they cant be smoothed
      */
      g_message(" this mesh %s had no labels: autoselecting all point",
		file);
	  for(yi=0; yi < this->ny; yi++) {
	    for(xi=0; xi < this->nx; xi++) {
	      meshSetLabel(this , xi,yi, -1);
	    }}}
  }


  if(gtk_subimasel_load(&(sp-> subimasel[lp]), fP)==0) {
    char s[401];s[0]=0;
    subimages_spinbuttons_set(lp);
    subimage2affines(lp);
  
    if(fgets(s,400,fP) && 0==strcmp("<image file name>\n",s)) {
      int l;
      fgets(s,400,fP);
      l=strlen(s);
      if(l>0) s[l-1]=0;
    } else
      s[0]=0;

    if(sp-> im_filename_in[lp] && s[0] &&  
       0!=strcmp(sp-> im_filename_in[lp],s)) {
      char z[601];
      sprintf(z,_("this mesh was created on image '%s' and not on this image '%s'"),s,sp-> im_filename_in[lp]);
      show_warning(z);
      set_editview( lp, EDITVIEW_EYES);
    } else {
    if(sp-> subimasel[lp].orig_width != sp-> im_width[lp] || 
       sp-> subimasel[lp].orig_height != sp->im_height[lp]) {
      char z[601];
      sprintf(z,_("the size of the image w=%d h=%d and the size recorded in the mesh  w=%d h=%d  do not match"),
	      sp-> im_width[lp],sp->im_height[lp],
	      sp-> subimasel[lp].orig_width,sp-> subimasel[lp].orig_height);
      show_warning(z);
      set_editview( lp, EDITVIEW_EYES);
      } else {
	set_editview( lp, EDITVIEW_EDIT);
	scale_loaded_pixbuf_et_rrggbb(lp);
      }
    }
    fgets(s,400,fP);

  }
  else
    show_warning("could not read subimage information from this file.");

  fclose(fP);
  return TRUE;
}











/************************************


setup_handlebox_factors()

if there is only one image , then we may only warp it
so the handlebox is hidden

otherwise if in showmeshes mode, they are shown,
and the user may set the factors and warp the image

***********************************/
void
setup_handlebox_factor(int lp)     
{
  GtkWidget* hb= lookup_widget  ( sp->im_widget[lp]  ,
				  "handlebox_factors");
  g_assert(hb);
  // these are really to be hidden!
  //set_sensitive(hb,( sp->max_wins>1 
  //		     && (sp->im_editview[lp] == EDITVIEW_SHOWMESHES  
			 // ||sp->im_editview[lp] == EDITVIEW_SHOW)
  //		     )));
  //return ;
  if( sp->max_wins>1 && sp->im_editview[lp] == EDITVIEW_SHOWMESHES)
    gtk_widget_show(hb);
  else
    gtk_widget_hide(hb);
} 

void
setup_handlebox_factors()
{
  int lp;
  for(lp=1 ; lp <= MAX_WINS;  lp ++)
    if(sp->im_widget[lp] != NULL)
      setup_handlebox_factor(lp);
}



















































/****************************************************************************

 *             create/ destroy image windows

 ***************************************************************************/


void
destroy_image_win_pixbufs(int lp, int what)
{ 
  g_assert(what==0 || what == 1);

#ifdef STORE_RRGGBB  
  g_free(sp->red[lp]);   g_free(sp->blue[lp]  ); g_free( sp->green[lp] );
#endif

  { int j ; for (j=2;j>=what;j--) {
    destroy_pixbuf(lp,j);    destroy_pixmap(lp,j);
  }}

  if(sp->im_warped_widget[lp])
    {
      gtk_widget_destroy(sp->im_warped_widget[lp]);
      sp->im_warped_widget[lp]=NULL;
    }
}


void
destroy_image_win_data(int lp)
{
  smooth_idle_stop_by_mesh(&(  sp->im_mesh[lp] ));
  meshUnref( &(  sp->im_mesh[lp] ));
  meshInit(&(  sp->im_mesh[lp] ));

  {
    int j ; 
    for (j=2;j>=0;j--) {
      destroy_pixbuf(lp,j);   
      destroy_pixmap(lp,j);
    }}
  if(sp->im_warped_widget[lp]) gtk_widget_destroy(sp->im_warped_widget[lp]);
  sp->im_warped_widget[lp]=NULL;
#define myfree(A) {g_free(A); A=NULL;}
  if(sp->im_filename_in[lp]) myfree(sp->im_filename_in[lp]);
  if(sp->im_filename_out[lp]) myfree(sp->im_filename_out[lp]);
  if(sp->im_mesh_filename[lp]) myfree(sp->im_mesh_filename[lp]);
  sp->im_widget[lp]=0;
  sp->im_drawingarea_widget[lp]=0;
}



/**********
	   pixbufs and rr gg bb buffers are alloced here,
	   whilst the im_pixmap_subimage and im_pixwarped are set elsewhere 
*/

void
alloc_image_win_data(int lp, int what)
{ 

  g_assert(what==0 || what == 1);

 /* there is no image associated to this window */
#ifdef USE_IMLIB
  sp->im_image[lp]=NULL;
  sp->im_imlib[lp]=NULL;
#endif

#ifdef STORE_RRGGBB
  {       
    long size = sp->resulting_width *  sp->resulting_height ;
    sp->red[lp] = g_malloc( size );
    sp->blue[lp]  = g_malloc( size );
    sp->green[lp] = g_malloc( size ) ;
  }
#endif

  {
    int j ; 
    for (j=2;j>=what;j--) {
      create__pixbuf(lp,j);   
      // can't do this now-- need a window --create__pixmap(lp,j);
  }}

}



void
init_image_win_data_and_set_all(int lp, /* the slot where the data are put
					   in the arrays in sp-> */
				GtkWidget * topw, /* the top window */
				char * name)
{
  
  /*sets size and subimage selection */
  //  set_image_win_initially(lp);
  /* to start with... until the user loads an image */
  sp->im_width[lp]=sp->resulting_width;
  sp->im_height[lp]=sp->resulting_height;
  gtk_subimasel_reset(&(sp->subimasel[lp]),
		      sp->im_width[lp],sp->im_height[lp] );

  { 
    double a[6]={1,0,0,0,1,0};
    memcpy(sp->transforms[lp].subimage2loaded,a,6*sizeof(double));
    memcpy(sp->transforms[lp].loaded2subimage,a,6*sizeof(double));
  }

  /* NO : this would mean that the image has been loaded
     sp->im_filename[lp] = g_strdup_printf("%s%d.png",_("image"),lp);
  */

  
  /*
    pixbufs and rr gg bb buffers are alloced here,
    whilst the im_pixmap_subimage and im_pixwarped are set elsewhere 
  */
  alloc_image_win_data(lp,0);
  
  create_image_menu_settings (lp);
    
  gtk_window_set_title (GTK_WINDOW(topw), name);


  {
    /* this trick comes from the FAQ of glade*/
    GtkWidget *
      option_menu = lookup_widget (topw, "optionmenu_editview");
    gtk_signal_connect(GTK_OBJECT (GTK_OPTION_MENU (option_menu)->menu),
		       "deactivate",
		       GTK_SIGNAL_FUNC (on_optionmenu_editview__selected ),
		       GUINT_TO_POINTER(lp));
  }
	
  /* NOTE THE ORDER: first the widget is created
   then we set the "imagenum"
   then we show it, so the pixmaps are created and stored in 
   the  *sp  structure 
  */
  gtk_widget_set_data_top(topw,"imagenum",
			  GUINT_TO_POINTER(lp));
  
  {
    GtkWidget *w=(lookup_widget(topw,"back_to_guide"));
    extern GtkWidget *guide_widget;
    if(w && ! guide_widget) gtk_widget_hide(w);
  }

  //FIXME this is risky ... and messy
  gtk_widget_set_data_top(topw,"gtk_subimagesel", &(sp->subimasel[lp]));
  
  //this is set in "set_backing_pixmap()"
  //sp->im_pixmap_subimage[lp] =  get_pixmap_addr (sp->im_widget[lp]);

  meshInit( &(  sp->im_mesh[lp] ));
  meshAlloc( &(sp->im_mesh[lp]), sp->meshes_x, sp->meshes_y);
  meshReset( &(sp->im_mesh[lp]), sp->resulting_width, sp->resulting_height);
  if( settings_get_value("mesh auto sync") && lp!=MAIN_WIN)
    meshCopy( &(sp->im_mesh[lp]), &(sp->im_mesh[MAIN_WIN]));

#ifdef NO_BORDER_HACK
  {
    MeshT *m =&sp->im_mesh[lp];
    meshSetLabel(m,0,0,MESHPOINTSELECTED);
    meshSetLabel(m,0,m->ny-1,MESHPOINTSELECTED);
    meshSetLabel(m,m->nx-1,0,MESHPOINTSELECTED);
    meshSetLabel(m,m->nx-1,m->ny-1,MESHPOINTSELECTED);
  }
#endif
  
  sp->mf.im_warp_factor[lp]=0.1;
  sp->mf.im_dissolve_factor[lp]=0.1;
}


void
create_and_show_image_win(int lp)
{ 
  
  char s[100];

  if (lp== MAIN_WIN)
    {
      GtkWidget *window_main=sp->im_widget[lp]=create_window_main(); 
      {
	GtkMenuItem *f=GTK_MENU_ITEM(lookup_widget(window_main,"file"));
	gtk_widget_set_data_top(f->submenu,"imagenum",
				GUINT_TO_POINTER(MAIN_WIN));
      }
      {
	GtkMenuItem *f=GTK_MENU_ITEM(lookup_widget(window_main,"settings_menu"));
	GtkWidget *menuSettings_g=NULL;
	menuSettings_g=create_gtkmorph_menuSettings();
	gtk_menu_item_set_submenu (f,menuSettings_g );
      }	
      sprintf(s,"%s",_("resulting image"));
    }
  else
    {
      sp->im_widget[lp]=create_image_win_1();
      sprintf(s,"%s %d",_("input image"),lp);     
    }
  gtk_window_set_default_size(GTK_WINDOW(sp->im_widget[lp]),-1,460);
  
  init_image_win_data_and_set_all(lp, /* the slot where the data are put
					 in the arrays in sp-> */
				  sp->im_widget[lp], /* the top window */
				  s);

  gtk_widget_show (sp->im_widget[lp]);
  /* note: this MUST be after the widget_show */
  set_editview(lp,EDITVIEW_EDIT);

  redraw_spins(-3);
}

