#include <GL/gl.h>
#include <gtk/gtkgl.h>
#include "libply.h" 
//#include "bind.h"
#include "gl_widget.h"
#include "math.h"

 float ply_angle_tilt=0,ply_angle_pan=0;

/**************
 what follows is shamelessly adapted from 
   'gliv'
 Author: Guillaume Chazarain <booh@altern.org>
 Copyright is GNU GPL.
 ********/

GtkWidget *gl_widget=NULL;

static void draw_checker(void)
{
    static guint tex_id = 0;
    gint i;
    gfloat half_w, half_h;

    if (1) {
        gushort texture[12];

        if (tex_id == 0)
            glGenTextures(1, &tex_id);

        for (i = 0; i < 3; i++) {
            texture[i] = texture[9 + i] = 1;
            texture[3 + i] = texture[6 + i] = 255;
        }

        glBindTexture(GL_TEXTURE_2D, tex_id);

        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);

        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
        glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);

        glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 2, 2, 0, GL_RGB,
                     GL_UNSIGNED_SHORT, texture);


    } else
        glBindTexture(GL_TEXTURE_2D, tex_id);

    /* glMatrixMode(GL_MODELVIEW); */
    /* Save the matrix only if we will not replace it when redrawing. */
    glPushMatrix();

    glLoadIdentity();

    glBegin(GL_QUADS);

    glTexCoord2f(0.0, 0.0);
    glVertex2f(-half_w, -half_h);

    glTexCoord2f(half_w / 16.0, 0.0);
    glVertex2f(half_w, -half_h);

    glTexCoord2f(half_w / 16.0, half_h / 16.0);
    glVertex2f(half_w, half_h);

    glTexCoord2f(0.0, half_h / 16.0);
    glVertex2f(-half_w, half_h);

    glEnd();

    
    /* glMatrixMode(GL_MODELVIEW); */
    glPopMatrix();
}


static gboolean redraw(void)
{
    GdkGLDrawable *gldrawable;


    gldrawable = gtk_widget_get_gl_drawable(gl_widget);
    gdk_gl_drawable_wait_gdk(gldrawable);

    glDisable(GL_DITHER);

    glClear(GL_COLOR_BUFFER_BIT);

    glEnable(GL_DITHER);

    
    gdk_gl_drawable_swap_buffers(gldrawable);


    gdk_gl_drawable_wait_gl(gldrawable);

    return FALSE;
}


static gboolean make_current(void)
{
    GdkGLContext *glcontext = gtk_widget_get_gl_context(gl_widget);
    GdkGLDrawable *gldrawable = gtk_widget_get_gl_drawable(gl_widget);

    return gdk_gl_drawable_make_current(gldrawable, glcontext);
}


static gboolean first_expose(void)
{
    /* We only handle the first one. */
    g_signal_handlers_disconnect_by_func(gl_widget, G_CALLBACK(first_expose),
                                         NULL);

    if (make_current() == FALSE) {
        g_critical(("glXMakeCurrent() failed\n"));
        exit(1);
    }

    glDisable(GL_DEPTH_TEST);

    glEnable(GL_TEXTURE_2D);
    glEnable(GL_BLEND);
    glShadeModel(GL_SMOOTH);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

}



void config_gl_widget(GtkWidget *widget)
{
    GdkGLConfigMode mode = GDK_GL_MODE_RGBA | GDK_GL_MODE_DEPTH |
        GDK_GL_MODE_DOUBLE | GDK_GL_MODE_ALPHA;

    static GdkGLConfig *glconfig=NULL;

    if(glconfig) return;

    if (gdk_gl_query_extension() == FALSE) {
        g_critical(("OpenGL not supported\n"));
        exit(1);
    }

    glconfig = gdk_gl_config_new_by_mode(mode);

    if (glconfig == NULL)
        /* Try without the alpha channel. */
        glconfig = gdk_gl_config_new_by_mode(mode & ~GDK_GL_MODE_ALPHA);

    if (glconfig == NULL) {
        g_critical(("Cannot find an appropriate visual, try glxinfo(1)\n"));
        exit(1);
    }

    gl_widget = widget;
    if (gtk_widget_set_gl_capability(gl_widget, glconfig, NULL, TRUE,
                                     GDK_GL_RGBA_TYPE) == FALSE) {
        g_critical(("Cannot set the OpenGL capability\n"));
        exit(1);
    }

    gtk_widget_set_events(gl_widget,
                          GDK_BUTTON_PRESS_MASK | GDK_BUTTON1_MOTION_MASK |
                          GDK_BUTTON3_MOTION_MASK | GDK_BUTTON_RELEASE_MASK);


    /* The real initialization is done on the first expose. */
    g_signal_connect_after(gl_widget, "expose-event", G_CALLBACK(first_expose),
                           NULL);
}


void render_ply_gl(PlySurface *PS ,GtkWidget *widget)
{
  const int w=250,h=250;
  int p,fp,th,tw,trs,tc;
  float x,y,z,rho;
  //GdkColor color;
  

  GLubyte red;
  GLubyte green;
  GLubyte blue ;

  //  extern GdkPixbuf* texture;
  //extern float PS->avg_z,PS->avg_x,PS->avg_y,PS->max_box;

  GdkDrawable *window=widget->window;


    GdkGLDrawable *gldrawable;

  guchar*  pixels=NULL;



  gldrawable = gtk_widget_get_gl_drawable(widget);
  gdk_gl_drawable_wait_gdk(gldrawable);

  glPushMatrix();
  
  glLoadIdentity();

  glRotatef(-ply_angle_tilt,1,0,0);
  glRotatef(ply_angle_pan,0,1,0);
  
  glDisable(GL_DITHER);
  
  glClear(GL_COLOR_BUFFER_BIT);
  
  glEnable(GL_DITHER);
  
  glDepthRange(-4,4);

  
  glColor3f(0.3,0.1,0.1);
  glRectf(-1,-1,1,1);


  if(PS->texture) {  
    th=gdk_pixbuf_get_height (PS->texture);
    tw=gdk_pixbuf_get_width (PS->texture);
    trs=gdk_pixbuf_get_rowstride(PS->texture);
    tc=gdk_pixbuf_get_n_channels(PS->texture);
    pixels=gdk_pixbuf_get_pixels(PS->texture);
  }

 
  for(fp=0;fp<PS->flist_len;fp++) {
    gint npoints=PS->flist[fp] -> nverts;

    int l;    
    
    glBegin(GL_POLYGON);
    
    for(l=0;l<npoints;l++) {
      p=PS->flist[fp] -> verts[l];

      x= PS->vlist[p]->x - PS->avg_x;
      y= PS->vlist[p]->y - PS->avg_y;
      z= PS->vlist[p]->z - PS->avg_z;
	
      x = x  / PS->max_box;
      y = y  / PS->max_box;
      z = z  / PS->max_box;

      rho=sqrt(x*x+z*z)*80;
      
      red=PS->vlist[p]->red;
      green=PS->vlist[p]->green;
      blue=PS->vlist[p]->blue;
      if(PS->texture &&
	 ((red==0 && green == 0 &&
	   blue == 0 ) ||
	  (red==255 && green == 255 &&
	   blue == 255 )
	  ) &&	 PS->flist[fp]->ntexcoord > 2 ) {
	int tx=  (double)tw*  ( PS->flist[fp]->texcoord[0])
	  ,ty=   (double)th*  (1-PS->flist[fp]->texcoord[1]) ;
	//tx=CLAMP(tx,0,tw);
	//ty=CLAMP(ty,0,th);
	red  =pixels[tx*tc+ty*trs];
	green=pixels[tx*tc+ty*trs+1];
	blue =pixels[tx*tc+ty*trs+2];
      }
      else  //depth coloring
	red=blue=green=rho+ 4*(4&(int)rho);

      glColor3ub(red,green,blue);
      glVertex3f(x,y,z);
      
    }
  loop:
    glEnd();
  }

  glPopMatrix();
  
  gdk_gl_drawable_swap_buffers(gldrawable);
  
  gdk_gl_drawable_wait_gl(gldrawable);

}
