// This file is a part of the xMule Project.
//
// Copyright (c) 2003 - 2004, by
//
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef DEBUG_H
#define DEBUG_H

#ifndef CWDEBUG

#define AllocTag1(p)
#define AllocTag2(p, desc)
#define AllocTag_dynamic_description(p, x)
#define AllocTag(p, x)
#define Debug(x)
#define Dout(a, b)
#define DoutFatal(a, b) LibcwDoutFatal(::std, , a, b)
#define ForAllDebugChannels(STATEMENT)
#define ForAllDebugObjects(STATEMENT)
#define LibcwDebug(dc_namespace, x)
#define LibcwDout(a, b, c, d)
#define LibcwDoutFatal(a, b, c, d) do { ::std::cerr << d << ::std::endl; ::std::exit(254); } while(1)
#define NEW(x) new x
#define CWDEBUG_ALLOC 0
#define CWDEBUG_MAGIC 0
#define CWDEBUG_LOCATION 0
#define CWDEBUG_LIBBFD 0
#define CWDEBUG_DEBUG 0
#define CWDEBUG_DEBUGOUTPUT 0
#define CWDEBUG_DEBUGM 0
#define CWDEBUG_DEBUGT 0
#define CWDEBUG_MARKER 0

#include <iostream>               // Needed for std::cerr and std::endl.
#include <cstdlib>                // Needed for std::exit.

#else // CWDEBUG

#ifndef DEBUGCHANNELS
// This must be defined before <libcwd/debug.h> is included and must be the
// name of the namespace containing your `dc' (Debug Channels) namespace
// (see below).  You can use any namespace(s) you like, except existing
// namespaces (like ::, ::std and ::libcwd).
#define DEBUGCHANNELS ::debug::channels
#endif
#include <libcwd/debug.h>

namespace debug
{
    void init();          // Initialize debugging code from main().
    void init_thread();   // Initialize debugging code from new threads.

    namespace channels        // namespace DEBUGCHANNELS
    {
        namespace dc
        {
            using namespace ::libcw::debug::channels::dc;
            using ::libcw::debug::channel_ct;

            // Add the declaration of new debug channels here
            // and add their definition in a custom debug.cc file.
            extern channel_ct dirtree;
            extern channel_ct sockets;
            extern channel_ct packet;
            extern channel_ct sockio;
        } // namespace dc
    } // namespace DEBUGCHANNELS

    extern void DumpBufferHex(libcw::debug::channel_ct const& channel, unsigned char const* buf, size_t size);
} // namespace debug

#endif // CWDEBUG

#endif // DEBUG_H
