// This file is a part of the xMule Project.
//
// Copyright (c) 2004, by
//
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef GETTICKCOUNT_H
#define GETTICKCOUNT_H

#if defined(__WXMSW__)
    #include <windows.h>
#else
#include <cstddef>                // Needed for NULL
#include <sys/time.h>             // Needed for gettimeofday

inline wxUint32 GetTickCount()
{
    struct timeval tp;
    gettimeofday(&tp, NULL);
    unsigned long secs = tp.tv_sec * 1000;
    secs += (tp.tv_usec / 1000);
    return secs;
}
#endif // !__WXMSW__

#endif // GETTICKCOUNT_H
