// This file is a part of the xMule Project.
//
// Copyright (c) 2004 Theodore R. Smith (hopeseekr@xmule.ws / http://www.xmule.ws/)
// DSA-1024 Fingerprint: 10A0 6372 9092 85A2 BB7F 907B CB8B 654B E33B F1ED
//
// Copyright (C)2002 Merkur ( merkur-@users.sourceforge.net / http://www.xmule-project.net )
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef KNOWNFILE_H
#define KNOWNFILE_H

#include "wintypes.h"
#include "otherstructs.h"
#include "types.h"
#include "CFile.h"
#include "opcodes.h"                       // PARTSIZE
#include "wx/dynarray.h"
#include "BarShader.h"
#include "MD5Sum.h"

class CTag;
class Packet;

class CFileStatistic{
	friend class CKnownFile;
public:
	CFileStatistic()					{requested = transfered = accepted = alltimerequested= alltimetransfered = alltimeaccepted = 0;}
	void	AddRequest();
	void	AddAccepted();
	void	AddTransferred(uint64 bytes);
	uint16	GetRequests()				{return requested;}
	uint16	GetAccepts()				{return accepted;}
	uint64	GetTransfered()				{return transfered;}
	uint16	GetAllTimeRequests()		{return alltimerequested;}
	uint16	GetAllTimeAccepts()			{return alltimeaccepted;}
	uint64	GetAllTimeTransfered()		{return alltimetransfered;}
	CKnownFile* fileParent;

private:
	uint16 requested;
	uint64 transfered;
	uint16 accepted;
	uint32 alltimerequested;
	uint64 alltimetransfered;
	uint32 alltimeaccepted;
};

/*
					   CPartFile
					 /
		  CKnownFile
		/
CAbstractFile 
		\ 
		  CSearchFile
*/
class CAbstractFile
{
public:
	CAbstractFile()
	{
		m_pszFileName = NULL;
		m_nFileSize = 0;
		m_iFileType = 2;
	}
	virtual ~CAbstractFile()
	{
		if( m_pszFileName != NULL )
			delete[] m_pszFileName;
	}

	char*	GetFileName()			{return m_pszFileName;}
	uchar*	GetFileHash()			{return m_abyFileHash;}
	uint32	GetFileSize()			{return m_nFileSize;}
	uint32*	GetFileTypePtr()		{return &m_iFileType;}
	uint32	GetFileType()			{return m_iFileType;}
	void	SetFileName(char* NewName); // Added by Tarod [Juanjo]
	void SetFileSize(uint32 nFileSize) { m_nFileSize = nFileSize; }
	
protected:
	char*	m_pszFileName;
	uchar	m_abyFileHash[16];
	uint32	m_nFileSize;
	uint32	m_iFileType;
	CString m_strComment;
	int8	m_iRate; //for rate 
};

class CUpDownClient;

class CKnownFile : public CAbstractFile
{
public:
	CKnownFile();
	~CKnownFile();

	virtual bool	CreateFromFile(char* directory,char* filename, volatile int const * notify); // create date, hashset and tags from a file
	uint32*	GetFileTypePtr()		{return &m_iFileType;}
	char*	GetPath()				{return directory;}
	void	SetPath(char* path);
	virtual	bool	IsPartFile()	{return false;}
	virtual bool	LoadFromFile(CFile* file);	//load date, hashset and tags from a .met file
	bool	WriteToFile(FILE* file);	
	uint32	GetFileDate()			{return date;}
	time_t*  GetCFileDate(){return (time_t*)&date;}
	uint16	GetHashCount()			{return hashlist.GetCount();}
	uchar*	GetPartHash(uint16 part);
	inline uint16	GetPartCount()	{return m_iPartCount>0? m_iPartCount:   (m_iPartCount = ((m_nFileSize+(PARTSIZE -1)) / PARTSIZE));}								 
	uint32	date;
	// file upload priority
	uint8	GetUpPriority()			{return m_iUpPriority;}
	void	SetUpPriority(uint8 newUpPriority, bool bSave=true);
	bool	IsAutoUpPriority()		{return m_bAutoUpPriority;}
	void	SetAutoUpPriority(bool flag)	{m_bAutoUpPriority = flag;}
	void	UpdateAutoUpPriority();
	void	AddQueuedCount() {m_iQueuedCount++; UpdateAutoUpPriority();};
	void	SubQueuedCount() {if(m_iQueuedCount) m_iQueuedCount--; UpdateAutoUpPriority();}
	uint32	GetQueuedCount() {return m_iQueuedCount;}

	// shared file view permissions (all, only friends, no one)
	uint8	GetPermissions(void)	{ return m_iPermissions; };
	void	SetPermissions(uint8 iNewPermissions) {m_iPermissions = iNewPermissions;};

	bool	LoadHashsetFromFile(CFile* file, bool checkhash);
	void	AddUploadingClient(CUpDownClient* client);
	void	RemoveUploadingClient(CUpDownClient* client);
	void	NewAvailPartsInfo();
	void	DrawShareStatusBar(wxDC* dc, wxRect rect, bool onlygreyrect, bool bFlat);

	CFileStatistic statistic;
	// comment 
	CString	GetFileComment()		{if (!m_bCommentLoaded) LoadComment(); return m_strComment;} 
	void	SetFileComment(CString strNewComment);
	void	SetFileRate(int8 iNewRate); 
	int8	GetFileRate()			{if (!m_bCommentLoaded) LoadComment(); return m_iRate;}

	// file sharing
	virtual	Packet*	CreateSrcInfoPacket(CUpDownClient* forClient);
    void CreateHashFromString(uchar* in_string, int Length, uchar* Output)	{CreateHashFromInput(0,0,Length,Output,in_string);}

protected:
	bool	LoadTagsFromFile(CFile* file);
	bool	LoadDateFromFile(CFile* file);
	void	CreateHashFromFile(FILE* file, int Length, uchar* Output)	{CreateHashFromInput(file,0,Length,Output,0);}
	void	CreateHashFromFile(CFile* file, int Length, uchar* Output)	{CreateHashFromInput(0,file,Length,Output,0);}
	void	LoadComment();//comment
	CArray<uchar*,uchar*> hashlist;
	CArray<CTag*,CTag*> taglist;
	char*	directory;

private:
	void	CreateHashFromInput(FILE* file,CFile* file2, int Length, uchar* Output, uchar* = 0);
	bool	m_bCommentLoaded;
	uint16	m_iPartCount;
        uint16  m_iED2KPartCount;
	uint16  m_iED2KPartHashCount;
	uint8	m_iUpPriority;
	uint8	m_iPermissions;
	bool	m_bAutoUpPriority;
	uint32	m_iQueuedCount;
	static	CBarShader s_ShareStatusBar;
	bool	m_PublishedED2K;

public:
	time_t	m_nCompleteSourcesTime;
	uint16	m_nCompleteSourcesCount;
	uint16	m_nCompleteSourcesCountLo;
	uint16	m_nCompleteSourcesCountHi;
	CTypedPtrList<CPtrList, CUpDownClient*> m_ClientUploadList;
	CArray<uint16,uint16> 	m_AvailPartFrequency;
	CArray<uint16,uint16>	m_PartSentCount;//added by sivka (Slugfiller: hideOS)
};

// permission values for shared files
#define PERM_ALL		0
#define PERM_FRIENDS	1
#define PERM_NOONE		2


// basic MD4 functions
#define MD4_F(x, y, z) (((x) & (y)) | ((~x) & (z)))
#define MD4_G(x, y, z) (((x) & (y)) | ((x) & (z)) | ((y) & (z)))
#define MD4_H(x, y, z) ((x) ^ (y) ^ (z))

// rotates x left n bits
#define MD4_ROTATE_LEFT(x, n) (((x) << (n)) | ((x) >> (32-(n))))

// partial transformations
#define MD4_FF(a, b, c, d, x, s) \
{ \
  (a) += MD4_F((b), (c), (d)) + (x); \
  (a) = MD4_ROTATE_LEFT((a), (s)); \
}

#define MD4_GG(a, b, c, d, x, s) \
{ \
  (a) += MD4_G((b), (c), (d)) + (x) + (uint32)0x5A827999; \
  (a) = MD4_ROTATE_LEFT((a), (s)); \
}

#define MD4_HH(a, b, c, d, x, s) \
{ \
  (a) += MD4_H((b), (c), (d)) + (x) + (uint32)0x6ED9EBA1; \
  (a) = MD4_ROTATE_LEFT((a), (s)); \
}


#endif
