#include <cstring>
#include <iostream>
#include <list>
#include <sys/time.h>                       // clock_gettime
#include <utility>                          // std::pair

using std::cerr;
using std::cout;
using std::endl;

typedef enum
{
    PRE_INCR = 0,
    POST_INCR
} sort_t;
//#include <linux/sched.h>

void CanCount(sort_t style)
{
    std::list<uint32_t> massive;
    for (uint32_t a = 0; a < 1000000; ++a)
    {
        massive.push_front(a);
    }

    std::list<uint32_t>::iterator it; 
    if (style == PRE_INCR)
    {
        for (it = massive.begin(); it != massive.end(); ++it)
        {
        }

        cout << "Pre: ";
    }
    else
    {
        for (it = massive.begin(); it != massive.end(); it++)
        {
        }

        cout << "Post: ";
    }
}

bool XBench(sort_t style, void (*function_pointer)(sort_t))
{
    enum
    {
        MIN,
        MAX,
        MEDIAN
    };

    if (function_pointer == NULL)
    {
        cerr << "O no! A NULL function pointer has been passed! Eeek!!" << endl;
        exit(1);
    }

    static uint64_t run_average[2];
    static uint32_t count[2];
    struct timespec now, then;

    static std::pair<sort_t, uint64_t> statistics[3];

    ++count[style];
    clock_gettime(CLOCK_REALTIME, &then);

    cout << count[style] << " | ";

    function_pointer(style);

    clock_gettime(CLOCK_REALTIME, &now);
    // Begin collation of statistics
    uint64_t usecs = static_cast<uint64_t>(((now.tv_sec - then.tv_sec) * 1e6) + ((now.tv_nsec - then.tv_nsec) * 1e-3));

    if (count[style] == 1)
    {
        run_average[style] = usecs;
        statistics[MIN].first = style;
        statistics[MIN].second = usecs;
    }
    else
    {
        run_average[style] = (run_average[style] + usecs) / 2;
    }

    if (usecs < statistics[MIN].second)
    {
        statistics[MIN].first = style;
        statistics[MIN].second = usecs;
    }
    else if (usecs > statistics[MAX].second)
    {
        statistics[MAX].first = style;
        statistics[MAX].second = usecs;
    }

    // Output statistics.
    cout << usecs << " usecs | average: " << run_average[style]
        << " | Min: " << statistics[MIN].second << " (" << (statistics[MIN].first == 1 ? "Post" : "Pre") << ") " << endl;
}

int main(int argc, char* argv[])
{
    sort_t style;

    for (int a = 0; a < 25; ++a)
    {
        XBench(PRE_INCR, &CanCount);
    }

    for (int a = 0; a < 25; ++a)
    {
        XBench(POST_INCR, &CanCount);
    }
}
