/*
 * Copyright (c) 2001-2008 International Computer Science Institute
 * See LICENSE file for licensing, conditions, and warranties on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'tgt-gen'.
 */

#ident "$XORP: xorp/xrl/targets/mfea_base.cc,v 1.33 2008/01/04 03:18:09 pavlin Exp $"


#include "mfea_base.hh"


XrlMfeaTargetBase::XrlMfeaTargetBase(XrlCmdMap* cmds)
    : _cmds(cmds)
{
    if (_cmds)
	add_handlers();
}

XrlMfeaTargetBase::~XrlMfeaTargetBase()
{
    if (_cmds)
	remove_handlers();
}

bool
XrlMfeaTargetBase::set_command_map(XrlCmdMap* cmds)
{
    if (_cmds == 0 && cmds) {
        _cmds = cmds;
        add_handlers();
        return true;
    }
    if (_cmds && cmds == 0) {
	remove_handlers();
        _cmds = cmds;
        return true;
    }
    return false;
}

const XrlCmdError
XrlMfeaTargetBase::handle_common_0_1_get_target_name(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_target_name");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string name;
    try {
	XrlCmdError e = common_0_1_get_target_name(
	    name);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_target_name", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("name", name);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_common_0_1_get_version(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_version");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string version;
    try {
	XrlCmdError e = common_0_1_get_version(
	    version);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_version", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("version", version);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_common_0_1_get_status(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/get_status");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    uint32_t status;
    string reason;
    try {
	XrlCmdError e = common_0_1_get_status(
	    status,
	    reason);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/get_status", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("status", status);
	pxa_outputs->add("reason", reason);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_common_0_1_shutdown(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "common/0.1/shutdown");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = common_0_1_shutdown();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "common/0.1/shutdown", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_cli_processor_0_1_process_command(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 5) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(5), XORP_UINT_CAST(xa_inputs.size()), "cli_processor/0.1/process_command");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    string ret_processor_name;
    string ret_cli_term_name;
    uint32_t ret_cli_session_id;
    string ret_command_output;
    try {
	XrlCmdError e = cli_processor_0_1_process_command(
	    xa_inputs.get_string("processor_name"),
	    xa_inputs.get_string("cli_term_name"),
	    xa_inputs.get_uint32("cli_session_id"),
	    xa_inputs.get_string("command_name"),
	    xa_inputs.get_string("command_args"),
	    ret_processor_name,
	    ret_cli_term_name,
	    ret_cli_session_id,
	    ret_command_output);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "cli_processor/0.1/process_command", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("ret_processor_name", ret_processor_name);
	pxa_outputs->add("ret_cli_term_name", ret_cli_term_name);
	pxa_outputs->add("ret_cli_session_id", ret_cli_session_id);
	pxa_outputs->add("ret_command_output", ret_command_output);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_ifmgr_replicator_0_1_register_ifmgr_mirror(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr_replicator/0.1/register_ifmgr_mirror");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_replicator_0_1_register_ifmgr_mirror(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr_replicator/0.1/register_ifmgr_mirror", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_ifmgr_replicator_0_1_unregister_ifmgr_mirror(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = ifmgr_replicator_0_1_unregister_ifmgr_mirror(
	    xa_inputs.get_string("clientname"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "ifmgr_replicator/0.1/unregister_ifmgr_mirror", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_finder_event_observer_0_1_xrl_target_birth(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_birth");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_birth(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_birth", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_finder_event_observer_0_1_xrl_target_death(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "finder_event_observer/0.1/xrl_target_death");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = finder_event_observer_0_1_xrl_target_death(
	    xa_inputs.get_string("target_class"),
	    xa_inputs.get_string("target_instance"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "finder_event_observer/0.1/xrl_target_death", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_have_multicast_routing4(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/have_multicast_routing4");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool result;
    try {
	XrlCmdError e = mfea_0_1_have_multicast_routing4(
	    result);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/have_multicast_routing4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("result", result);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_have_multicast_routing6(const XrlArgs& xa_inputs, XrlArgs* pxa_outputs)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/have_multicast_routing6");
	return XrlCmdError::BAD_ARGS();
    }

    if (pxa_outputs == 0) {
	XLOG_FATAL("Return list empty");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    bool result;
    try {
	XrlCmdError e = mfea_0_1_have_multicast_routing6(
	    result);
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/have_multicast_routing6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }

    /* Marshall return values */
    try {
	pxa_outputs->add("result", result);
    } catch (const XrlArgs::XrlAtomFound& ) {
	XLOG_FATAL("Duplicate atom name"); /* XXX Should never happen */
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_register_protocol4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/register_protocol4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_register_protocol4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/register_protocol4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_register_protocol6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 4) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(4), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/register_protocol6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_register_protocol6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_uint32("ip_protocol"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/register_protocol6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_unregister_protocol4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/unregister_protocol4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_unregister_protocol4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/unregister_protocol4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_unregister_protocol6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/unregister_protocol6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_unregister_protocol6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_string("if_name"),
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/unregister_protocol6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_add_mfc4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(8), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/add_mfc4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_add_mfc4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv4("source_address"),
	    xa_inputs.get_ipv4("group_address"),
	    xa_inputs.get_uint32("iif_vif_index"),
	    xa_inputs.get_binary("oiflist"),
	    xa_inputs.get_binary("oiflist_disable_wrongvif"),
	    xa_inputs.get_uint32("max_vifs_oiflist"),
	    xa_inputs.get_ipv4("rp_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/add_mfc4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_add_mfc6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 8) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(8), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/add_mfc6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_add_mfc6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv6("source_address"),
	    xa_inputs.get_ipv6("group_address"),
	    xa_inputs.get_uint32("iif_vif_index"),
	    xa_inputs.get_binary("oiflist"),
	    xa_inputs.get_binary("oiflist_disable_wrongvif"),
	    xa_inputs.get_uint32("max_vifs_oiflist"),
	    xa_inputs.get_ipv6("rp_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/add_mfc6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_delete_mfc4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/delete_mfc4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_delete_mfc4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv4("source_address"),
	    xa_inputs.get_ipv4("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/delete_mfc4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_delete_mfc6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/delete_mfc6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_delete_mfc6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv6("source_address"),
	    xa_inputs.get_ipv6("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/delete_mfc6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_add_dataflow_monitor4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 11) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(11), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/add_dataflow_monitor4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_add_dataflow_monitor4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv4("source_address"),
	    xa_inputs.get_ipv4("group_address"),
	    xa_inputs.get_uint32("threshold_interval_sec"),
	    xa_inputs.get_uint32("threshold_interval_usec"),
	    xa_inputs.get_uint32("threshold_packets"),
	    xa_inputs.get_uint32("threshold_bytes"),
	    xa_inputs.get_bool("is_threshold_in_packets"),
	    xa_inputs.get_bool("is_threshold_in_bytes"),
	    xa_inputs.get_bool("is_geq_upcall"),
	    xa_inputs.get_bool("is_leq_upcall"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/add_dataflow_monitor4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_add_dataflow_monitor6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 11) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(11), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/add_dataflow_monitor6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_add_dataflow_monitor6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv6("source_address"),
	    xa_inputs.get_ipv6("group_address"),
	    xa_inputs.get_uint32("threshold_interval_sec"),
	    xa_inputs.get_uint32("threshold_interval_usec"),
	    xa_inputs.get_uint32("threshold_packets"),
	    xa_inputs.get_uint32("threshold_bytes"),
	    xa_inputs.get_bool("is_threshold_in_packets"),
	    xa_inputs.get_bool("is_threshold_in_bytes"),
	    xa_inputs.get_bool("is_geq_upcall"),
	    xa_inputs.get_bool("is_leq_upcall"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/add_dataflow_monitor6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_delete_dataflow_monitor4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 11) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(11), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/delete_dataflow_monitor4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_delete_dataflow_monitor4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv4("source_address"),
	    xa_inputs.get_ipv4("group_address"),
	    xa_inputs.get_uint32("threshold_interval_sec"),
	    xa_inputs.get_uint32("threshold_interval_usec"),
	    xa_inputs.get_uint32("threshold_packets"),
	    xa_inputs.get_uint32("threshold_bytes"),
	    xa_inputs.get_bool("is_threshold_in_packets"),
	    xa_inputs.get_bool("is_threshold_in_bytes"),
	    xa_inputs.get_bool("is_geq_upcall"),
	    xa_inputs.get_bool("is_leq_upcall"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/delete_dataflow_monitor4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_delete_dataflow_monitor6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 11) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(11), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/delete_dataflow_monitor6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_delete_dataflow_monitor6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv6("source_address"),
	    xa_inputs.get_ipv6("group_address"),
	    xa_inputs.get_uint32("threshold_interval_sec"),
	    xa_inputs.get_uint32("threshold_interval_usec"),
	    xa_inputs.get_uint32("threshold_packets"),
	    xa_inputs.get_uint32("threshold_bytes"),
	    xa_inputs.get_bool("is_threshold_in_packets"),
	    xa_inputs.get_bool("is_threshold_in_bytes"),
	    xa_inputs.get_bool("is_geq_upcall"),
	    xa_inputs.get_bool("is_leq_upcall"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/delete_dataflow_monitor6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_delete_all_dataflow_monitor4(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/delete_all_dataflow_monitor4");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_delete_all_dataflow_monitor4(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv4("source_address"),
	    xa_inputs.get_ipv4("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/delete_all_dataflow_monitor4", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_delete_all_dataflow_monitor6(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 3) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(3), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/delete_all_dataflow_monitor6");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_delete_all_dataflow_monitor6(
	    xa_inputs.get_string("xrl_sender_name"),
	    xa_inputs.get_ipv6("source_address"),
	    xa_inputs.get_ipv6("group_address"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/delete_all_dataflow_monitor6", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_enable_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 2) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(2), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/enable_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_enable_vif(
	    xa_inputs.get_string("vif_name"),
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/enable_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_start_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/start_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_start_vif(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/start_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_stop_vif(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/stop_vif");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_stop_vif(
	    xa_inputs.get_string("vif_name"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/stop_vif", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_enable_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/enable_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_enable_all_vifs(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/enable_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_start_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/start_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_start_all_vifs();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/start_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_stop_all_vifs(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/stop_all_vifs");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_stop_all_vifs();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/stop_all_vifs", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_enable_mfea(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/enable_mfea");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_enable_mfea(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/enable_mfea", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_start_mfea(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/start_mfea");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_start_mfea();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/start_mfea", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_stop_mfea(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/stop_mfea");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_stop_mfea();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/stop_mfea", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_enable_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/enable_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_enable_cli(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/enable_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_start_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/start_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_start_cli();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/start_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_stop_cli(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(0), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/stop_cli");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_stop_cli();
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/stop_cli", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

const XrlCmdError
XrlMfeaTargetBase::handle_mfea_0_1_log_trace_all(const XrlArgs& xa_inputs, XrlArgs* /* pxa_outputs */)
{
    if (xa_inputs.size() != 1) {
	XLOG_ERROR("Wrong number of arguments (%u != %u) handling %s",
            XORP_UINT_CAST(1), XORP_UINT_CAST(xa_inputs.size()), "mfea/0.1/log_trace_all");
	return XrlCmdError::BAD_ARGS();
    }

    /* Return value declarations */
    try {
	XrlCmdError e = mfea_0_1_log_trace_all(
	    xa_inputs.get_bool("enable"));
	if (e != XrlCmdError::OKAY()) {
	    XLOG_WARNING("Handling method for %s failed: %s",
            		 "mfea/0.1/log_trace_all", e.str().c_str());
	    return e;
        }
    } catch (const XrlArgs::BadArgs& e) {
	XLOG_ERROR("Error decoding the arguments: %s", e.str().c_str());
	return XrlCmdError::BAD_ARGS(e.str());
    }
    return XrlCmdError::OKAY();
}

void
XrlMfeaTargetBase::add_handlers()
{
	if (_cmds->add_handler("common/0.1/get_target_name",
	    callback(this, &XrlMfeaTargetBase::handle_common_0_1_get_target_name)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "common/0.1/get_target_name");
	}
	if (_cmds->add_handler("common/0.1/get_version",
	    callback(this, &XrlMfeaTargetBase::handle_common_0_1_get_version)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "common/0.1/get_version");
	}
	if (_cmds->add_handler("common/0.1/get_status",
	    callback(this, &XrlMfeaTargetBase::handle_common_0_1_get_status)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "common/0.1/get_status");
	}
	if (_cmds->add_handler("common/0.1/shutdown",
	    callback(this, &XrlMfeaTargetBase::handle_common_0_1_shutdown)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "common/0.1/shutdown");
	}
	if (_cmds->add_handler("cli_processor/0.1/process_command",
	    callback(this, &XrlMfeaTargetBase::handle_cli_processor_0_1_process_command)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "cli_processor/0.1/process_command");
	}
	if (_cmds->add_handler("ifmgr_replicator/0.1/register_ifmgr_mirror",
	    callback(this, &XrlMfeaTargetBase::handle_ifmgr_replicator_0_1_register_ifmgr_mirror)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "ifmgr_replicator/0.1/register_ifmgr_mirror");
	}
	if (_cmds->add_handler("ifmgr_replicator/0.1/unregister_ifmgr_mirror",
	    callback(this, &XrlMfeaTargetBase::handle_ifmgr_replicator_0_1_unregister_ifmgr_mirror)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_birth",
	    callback(this, &XrlMfeaTargetBase::handle_finder_event_observer_0_1_xrl_target_birth)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "finder_event_observer/0.1/xrl_target_birth");
	}
	if (_cmds->add_handler("finder_event_observer/0.1/xrl_target_death",
	    callback(this, &XrlMfeaTargetBase::handle_finder_event_observer_0_1_xrl_target_death)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "finder_event_observer/0.1/xrl_target_death");
	}
	if (_cmds->add_handler("mfea/0.1/have_multicast_routing4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_have_multicast_routing4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/have_multicast_routing4");
	}
	if (_cmds->add_handler("mfea/0.1/have_multicast_routing6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_have_multicast_routing6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/have_multicast_routing6");
	}
	if (_cmds->add_handler("mfea/0.1/register_protocol4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_register_protocol4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/register_protocol4");
	}
	if (_cmds->add_handler("mfea/0.1/register_protocol6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_register_protocol6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/register_protocol6");
	}
	if (_cmds->add_handler("mfea/0.1/unregister_protocol4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_unregister_protocol4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/unregister_protocol4");
	}
	if (_cmds->add_handler("mfea/0.1/unregister_protocol6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_unregister_protocol6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/unregister_protocol6");
	}
	if (_cmds->add_handler("mfea/0.1/add_mfc4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_add_mfc4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/add_mfc4");
	}
	if (_cmds->add_handler("mfea/0.1/add_mfc6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_add_mfc6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/add_mfc6");
	}
	if (_cmds->add_handler("mfea/0.1/delete_mfc4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_delete_mfc4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/delete_mfc4");
	}
	if (_cmds->add_handler("mfea/0.1/delete_mfc6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_delete_mfc6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/delete_mfc6");
	}
	if (_cmds->add_handler("mfea/0.1/add_dataflow_monitor4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_add_dataflow_monitor4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/add_dataflow_monitor4");
	}
	if (_cmds->add_handler("mfea/0.1/add_dataflow_monitor6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_add_dataflow_monitor6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/add_dataflow_monitor6");
	}
	if (_cmds->add_handler("mfea/0.1/delete_dataflow_monitor4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_delete_dataflow_monitor4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/delete_dataflow_monitor4");
	}
	if (_cmds->add_handler("mfea/0.1/delete_dataflow_monitor6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_delete_dataflow_monitor6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/delete_dataflow_monitor6");
	}
	if (_cmds->add_handler("mfea/0.1/delete_all_dataflow_monitor4",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_delete_all_dataflow_monitor4)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/delete_all_dataflow_monitor4");
	}
	if (_cmds->add_handler("mfea/0.1/delete_all_dataflow_monitor6",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_delete_all_dataflow_monitor6)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/delete_all_dataflow_monitor6");
	}
	if (_cmds->add_handler("mfea/0.1/enable_vif",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_enable_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/enable_vif");
	}
	if (_cmds->add_handler("mfea/0.1/start_vif",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_start_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/start_vif");
	}
	if (_cmds->add_handler("mfea/0.1/stop_vif",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_stop_vif)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/stop_vif");
	}
	if (_cmds->add_handler("mfea/0.1/enable_all_vifs",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_enable_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/enable_all_vifs");
	}
	if (_cmds->add_handler("mfea/0.1/start_all_vifs",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_start_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/start_all_vifs");
	}
	if (_cmds->add_handler("mfea/0.1/stop_all_vifs",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_stop_all_vifs)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/stop_all_vifs");
	}
	if (_cmds->add_handler("mfea/0.1/enable_mfea",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_enable_mfea)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/enable_mfea");
	}
	if (_cmds->add_handler("mfea/0.1/start_mfea",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_start_mfea)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/start_mfea");
	}
	if (_cmds->add_handler("mfea/0.1/stop_mfea",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_stop_mfea)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/stop_mfea");
	}
	if (_cmds->add_handler("mfea/0.1/enable_cli",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_enable_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/enable_cli");
	}
	if (_cmds->add_handler("mfea/0.1/start_cli",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_start_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/start_cli");
	}
	if (_cmds->add_handler("mfea/0.1/stop_cli",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_stop_cli)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/stop_cli");
	}
	if (_cmds->add_handler("mfea/0.1/log_trace_all",
	    callback(this, &XrlMfeaTargetBase::handle_mfea_0_1_log_trace_all)) == false) {
	    XLOG_ERROR("Failed to xrl handler finder://%s/%s", "mfea", "mfea/0.1/log_trace_all");
	}
	_cmds->finalize();
}

void
XrlMfeaTargetBase::remove_handlers()
{
	_cmds->remove_handler("common/0.1/get_target_name");
	_cmds->remove_handler("common/0.1/get_version");
	_cmds->remove_handler("common/0.1/get_status");
	_cmds->remove_handler("common/0.1/shutdown");
	_cmds->remove_handler("cli_processor/0.1/process_command");
	_cmds->remove_handler("ifmgr_replicator/0.1/register_ifmgr_mirror");
	_cmds->remove_handler("ifmgr_replicator/0.1/unregister_ifmgr_mirror");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_birth");
	_cmds->remove_handler("finder_event_observer/0.1/xrl_target_death");
	_cmds->remove_handler("mfea/0.1/have_multicast_routing4");
	_cmds->remove_handler("mfea/0.1/have_multicast_routing6");
	_cmds->remove_handler("mfea/0.1/register_protocol4");
	_cmds->remove_handler("mfea/0.1/register_protocol6");
	_cmds->remove_handler("mfea/0.1/unregister_protocol4");
	_cmds->remove_handler("mfea/0.1/unregister_protocol6");
	_cmds->remove_handler("mfea/0.1/add_mfc4");
	_cmds->remove_handler("mfea/0.1/add_mfc6");
	_cmds->remove_handler("mfea/0.1/delete_mfc4");
	_cmds->remove_handler("mfea/0.1/delete_mfc6");
	_cmds->remove_handler("mfea/0.1/add_dataflow_monitor4");
	_cmds->remove_handler("mfea/0.1/add_dataflow_monitor6");
	_cmds->remove_handler("mfea/0.1/delete_dataflow_monitor4");
	_cmds->remove_handler("mfea/0.1/delete_dataflow_monitor6");
	_cmds->remove_handler("mfea/0.1/delete_all_dataflow_monitor4");
	_cmds->remove_handler("mfea/0.1/delete_all_dataflow_monitor6");
	_cmds->remove_handler("mfea/0.1/enable_vif");
	_cmds->remove_handler("mfea/0.1/start_vif");
	_cmds->remove_handler("mfea/0.1/stop_vif");
	_cmds->remove_handler("mfea/0.1/enable_all_vifs");
	_cmds->remove_handler("mfea/0.1/start_all_vifs");
	_cmds->remove_handler("mfea/0.1/stop_all_vifs");
	_cmds->remove_handler("mfea/0.1/enable_mfea");
	_cmds->remove_handler("mfea/0.1/start_mfea");
	_cmds->remove_handler("mfea/0.1/stop_mfea");
	_cmds->remove_handler("mfea/0.1/enable_cli");
	_cmds->remove_handler("mfea/0.1/start_cli");
	_cmds->remove_handler("mfea/0.1/stop_cli");
	_cmds->remove_handler("mfea/0.1/log_trace_all");
}
