/*
 *   XPP - The X Printing Panel
 *   --------------------------
 *
 *   cupsHelper - This class was originally written by Michael Goffioul
 *   (e-mail: gofioul@emic.ucl.ac.be) for QTCUPS, another excellent
 *   printing frontend for CUPS. This version has the same functions,
 *   but is more general, it is not dependent on QT, and it also overloads
 *   printf to get rid of console messages completely and to take the
 *   information out of these messages
 *
 *   Thank you for your great work, Michael!
 *
 *   Copyright 2000 by Till Kamppeter and Michael Goffioul
 *
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License as
 *   published by the Free Software Foundation; either version 2 of the
 *   License, or (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *   02111-1307  USA
 *
 */

#ifndef CUPSHELPER_H
#define CUPSHELPER_H

#include <cups/cups.h>
#include <cups/ipp.h>

const char* cupsGetPassword(const char *prompt);
const char* cupsGetPasswordFromLibrary(const char *prompt);
const char* cupsUser();
const char* cupsUserFromLibrary();
const char* cupsServer();
const char* cupsServerFromLibrary();
int ippPort();
int ippPortFromLibrary();

#include <string.h>

class CupsHelper {
public: 
	CupsHelper();
	~CupsHelper();
  static void setLoginInfo(const char *usr = 0, const char *pwd = 0);
  static void setHostInfo(const char *host, int port = 631);
  static int port();
  static const char* host();
  static const char* password();
  static const char* login();
  static ipp_t* newIppRequest();
  static ipp_t* processRequest(ipp_t *req, const char *res);
  static bool checkHost();
  static const char* cupsGetPassword(const char* prompt);
  static void setup();
  static int printerType(const char *name);
private: // Private attributes
  static char host_[256];
  static char password_[256];
  static char login_[256];
  static int port_;
  static int count_;
};

#endif
