%define name		xprint
%define version		20040322release
%define release		0.9

Summary:	Xprint
Name:		%{name}
Version: 	%{version}
Release: 	%{release}
Copyright: 	MIT
Group: 		X11/Applications
URL: 		http://xprint.mozdev.org/
Source: 	xprint-%{version}.tar.gz
#BuildPrereq:    XFree86-devel
BuildRoot:	%{_tmppath}/%{name}-%{version}
Prefix:		%{_prefix}
Packager:       Roland Mainz <roland.mainz@nrubsig.org>
Patch0:         xprint_rpmpackage.patch

%description
Xprint provides an advanched print API for X11-based
(incl. CDE, Xt/Motif-, Xt/LessTif-, Xt/Athena-, Qt- and
Mozilla-based) applications.

%prep

%setup -q -n xprint
%patch0 -p0

%build
cd src/xprint_main/xc/
make World

%install
if [ -d ${RPM_BUILD_ROOT} ] ; then
    rm -rf ${RPM_BUILD_ROOT}
fi
mkdir -p ${RPM_BUILD_ROOT}

# Create and test tarball of files which should be in the final RPM...
cd src/xprint_main/xc/packager/
# ${XPDESTTARFILE} is used by "make make_xprint_tarball"
XPDESTTARFILE="/tmp/xprint_rpm_`date +%y%m%d%H%M%S`.tar.gz"
export XPDESTTARFILE
make make_xprint_tarball

# Check if the temp. tarball was being build
if [ ! -f "${XPDESTTARFILE}" ] ; then
    echo "# temp. tarball missing."
    exit 1
fi

# ... and then unpack the temp. tarball in the ${RPM_BUILD_ROOT} dir
cd ${RPM_BUILD_ROOT}
gunzip -c ${XPDESTTARFILE} | tar -xvf -
rm -f ${XPDESTTARFILE}

# the tarball generation script puts the files which should be installed
# in the "install/" subdir. we strip the tarball README and the
# tarball-specific "run_xprint_from_tarball.sh" and then move all stuff
# in install/* to $PWD
rm -f xprint/run_xprint_from_tarball.sh
rm -f xprint/README
mv xprint/install/* .
rmdir xprint/install
rmdir xprint

# remove obsolete README and SECURITY extension config "SecurityPolicy"
rm -f ${RPM_BUILD_ROOT}/usr/X11R6/lib/X11/xserver/README
rm -f ${RPM_BUILD_ROOT}/usr/X11R6/lib/X11/xserver/SecurityPolicy

mv ${RPM_BUILD_ROOT}/usr/X11R6/bin/Xprt ${RPM_BUILD_ROOT}/usr/X11R6/bin/Xprt_xprint_org

if [ ! -f ${RPM_BUILD_ROOT}/usr/X11R6/lib/X11/xserver/C/print/models/PSdefault/model-config ] ; then
    echo "# ERROR: ${RPM_BUILD_ROOT}/usr/X11R6/lib/X11/xserver/C/print/models/PSdefault/model-config missing."
    exit 1
fi

%clean
rm -rf ${RPM_BUILD_ROOT}

%post
if [ -x /usr/lib/lsb/install_initd ] ; then
    # (hopefully) LSB-compliant distribution
    /usr/lib/lsb/install_initd /etc/init.d/xprint
else
    if [ -f /etc/redhat-release ] ; then
        if [ $1 = 1 ]; then
            /sbin/chkconfig --add xprint
        fi
    else
        # SuSE(-like) ?
        if [ -d /etc/rc.d/rc2.d/ ] ; then
            echo "# Detected SuSE(-like) distribution"
            echo "# Creating links..."
            ln -sf ../xprint /etc/rc.d/rc2.d/K21xprint
            ln -sf ../xprint /etc/rc.d/rc2.d/S21xprint
            ln -sf ../xprint /etc/rc.d/rc3.d/K21xprint
            ln -sf ../xprint /etc/rc.d/rc3.d/S21xprint

            # Older SuSE versions (like SuSE 6.4) do not have /etc/init.d/
            if [ ! -f /etc/rc.d/xprint ] ; then
                echo "# Creating old SuSE compatibility link..."
                ln -s /etc/init.d/xprint /etc/rc.d/xprint
            fi
        else
            # RedHat(-like) ?
            if [ -d "/etc/rc1.d" -a -d "/etc/init.d/" ] ; then
                echo "# Detected RedHat(-like) distribution"
                echo "# Creating links..."             
                ln -sf /etc/init.d/xprint /etc/rc.d/rc0.d/K61xprint
                ln -sf /etc/init.d/xprint /etc/rc.d/rc1.d/K61xprint
                ln -sf /etc/init.d/xprint /etc/rc.d/rc2.d/S61xprint
                ln -sf /etc/init.d/xprint /etc/rc.d/rc3.d/S61xprint
                ln -sf /etc/init.d/xprint /etc/rc.d/rc4.d/S61xprint
                ln -sf /etc/init.d/xprint /etc/rc.d/rc5.d/S61xprint
                ln -sf /etc/init.d/xprint /etc/rc.d/rc6.d/K61xprint
            else
                echo "# Unsupported version of Linux, cannot create links for /etc/init.d/."
                exit 1
            fi
        fi
    fi
fi

ln -sf /usr/X11R6/bin/Xprt_xprint_org /usr/X11R6/bin/Xprt

echo "#"
echo "# Notes:"
echo "# 1. You have to start the Xprint servers using % /etc/init.d/xprint start #"
echo "#    and relogin (to populate the XPSERVERLIST env variable using"
echo "#    /etc/profile.d/xprint) before using any Xprint-based applications."
echo "# 2. Please consult the FAQ (/usr/doc/packages/xprint/Xprint_FAQ.txt)"
echo "#    or http://xprint.mozdev.org/ if there are any problems."

%preun
if [ -x /usr/lib/lsb/remove_initd ] ; then
    # (hopefully) LSB-compliant distribution
    /usr/lib/lsb/remove_initd /etc/init.d/xprint
else
    if [ -f /etc/redhat-release ] ; then
        if [ $1 = 0 ]; then
            /sbin/service xprint stop >/dev/null 2>&1
            /sbin/chkconfig --del xprint
        fi
    else
        # SuSE(-like) ?
        if [ -d /etc/rc.d/rc2.d/ ] ; then
            echo "# Detected SuSE(-like) distribution"
            echo "# Removing links..."
            rm -f /etc/rc.d/rc2.d/K21xprint
            rm -f /etc/rc.d/rc2.d/S21xprint
            rm -f /etc/rc.d/rc3.d/K21xprint
            rm -f /etc/rc.d/rc3.d/S21xprint

            # See comment above about old SuSE versions
            if [ -L /etc/rc.d/xprint ] ; then
                echo "# Removing old SuSE compatibility link..."
                rm -f /etc/rc.d/xprint
            fi
        else
            # RedHat(-like) ?
            if [ -d "/etc/rc1.d" -a -d "/etc/init.d/" ] ; then
                echo "# Detected RedHat(-like) distribution"
                echo "# Removing links..."             
                rm -f /etc/rc.d/rc0.d/K61xprint
                rm -f /etc/rc.d/rc1.d/K61xprint
                rm -f /etc/rc.d/rc2.d/S61xprint
                rm -f /etc/rc.d/rc3.d/S61xprint
                rm -f /etc/rc.d/rc4.d/S61xprint
                rm -f /etc/rc.d/rc5.d/S61xprint
                rm -f /etc/rc.d/rc6.d/K61xprint
            else
                echo "# Unsupported version of Linux, cannot remove links for /etc/init.d/."
                exit 1
            fi
        fi
    fi
fi

%postun
if [ $1 -ge 1 ]; then
    /sbin/service xprint condrestart >/dev/null 2>&1
fi

%files 
%defattr(-,root,root) 
%doc src/xprint_main/xc/doc/hardcopy/XPRINT/Xprint_FAQ.html
%doc src/xprint_main/xc/doc/hardcopy/XPRINT/Xprint_FAQ.txt
/etc/init.d/*
/etc/profile.d/*
/etc/X11/Xsession.d/92xprint-xpserverlist
/etc/X11/xinit/xinitrc.d/92xprint-xpserverlist
/usr/X11R6/bin/Xprt_xprint_org
/usr/X11R6/bin/xplsprinters
/usr/X11R6/bin/xphelloworld
/usr/X11R6/bin/xpxthelloworld
/usr/X11R6/bin/xpsimplehelloworld
/usr/X11R6/lib/X11/xserver/*
/usr/X11R6/man/man1/*
/usr/X11R6/man/man7/*
# EOF.
