/*-
# X-BASED BARREL(tm)
#
#  Barrel.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Barrel */

#ifndef _XtBarrel_h
#define _XtBarrel_h

/***********************************************************************
 *
 * Barrel Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNtiles ((char *) "tiles")
#define XtNfaces ((char *) "faces")
#define XtNorient ((char *) "orient")
#define XtNpairs ((char *) "pairs")
#define XtNpractice ((char *) "practice")
#define XtNbase ((char *) "base")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNtileBorder ((char *) "tileBorder")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtCUserName ((char *) "UserName")
#define XtCTiles ((char *) "Tiles")
#define XtCFaces ((char *) "Faces")
#define XtCOrient ((char *) "Orient")
#define XtCPairs ((char *) "Pairs")
#define XtCPractice ((char *) "Practice")
#define XtCBase ((char *) "Base")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCMenu ((char *) "Menu")

typedef struct _BarrelClassRec *BarrelWidgetClass;

extern WidgetClass barrelWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} barrelCallbackStruct;
#endif

#define BARREL_HIDE (-9)
#define BARREL_PRACTICE_QUERY (-8)
#define BARREL_RANDOMIZE_QUERY (-7)
#define BARREL_SOLVE_MESSAGE (-6)
#define BARREL_RESTORE (-5)
#define BARREL_RESET (-4)
#define BARREL_BLOCKED (-3)
#define BARREL_SPACE (-2)
#define BARREL_IGNORE (-1)
#define BARREL_MOVED 0
#define BARREL_SOLVED 1
#define BARREL_CONTROL 2
#define BARREL_PRACTICE 3
#define BARREL_RANDOMIZE 4
#define BARREL_ORIENT 5
#define BARREL_PAIRS 6
#define BARREL_DEC_X 7
#define BARREL_INC_X 8
#define BARREL_DEC_Y 9
#define BARREL_INC_Y 10
#define BARREL_COMPUTED 11
#define BARREL_UNDO 12
#define BARREL_SPEED 13

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define MINFACES 5
#define MAXFACES 5
#define MINTILES 6
#define MAXTILES 6
#define DEFAULTFACES 5
#define DEFAULTTILES 6
#define DEFAULTORIENT FALSE
#define DEFAULTPAIRS TRUE
#define DEFAULTPRACTICE FALSE
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

typedef struct _BarrelRec *BarrelWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtBarrel_h */
/* DON'T ADD STUFF AFTER THIS #endif */
