/*-
# X-BASED CUBES
#
#  CubesP.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Cubes */

#ifndef _CubesP_h
#define _CubesP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Cubes.h"

#ifndef BUMPSOUND
#define BUMPSOUND "c:/windows/bump.wav"
#endif
#ifndef DRIPSOUND
#define DRIPSOUND "c:/windows/drip.wav"
#endif

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)		/* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define Pixmap HBITMAP

#define DC(w,dr) ((dr==0)?w->core.hDC:w->cubes.memDC)
#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w,x,y,x+l,y+h)
#define DRAWRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->cubes.hOldBitmap = (HBITMAP) SelectObject(w->cubes.memDC,dr); \
  w->cubes.hPen = CreatePen(PS_SOLID,1,c); \
  w->cubes.hOldPen = (HPEN) SelectObject(DC(w,dr),w->cubes.hPen); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->cubes.hOldPen); \
  (void) DeleteObject(w->cubes.hPen); \
  if (dr) (void) SelectObject(w->cubes.memDC,w->cubes.hOldBitmap)
#define FILLRECTANGLE(w,dr,c,x,y,l,h) \
  if (dr) w->cubes.hOldBitmap = (HBITMAP) SelectObject(w->cubes.memDC,dr); \
  w->cubes.hPen = CreatePen(PS_SOLID,1,c); \
  w->cubes.hOldPen = (HPEN) SelectObject(DC(w,dr),w->cubes.hPen); \
  w->cubes.hBrush = CreateSolidBrush(c); \
  w->cubes.hOldBrush = (HBRUSH) SelectObject(DC(w,dr),w->cubes.hBrush); \
  RECTANGLE(DC(w,dr),x,y,l,h); \
  (void) SelectObject(DC(w,dr),w->cubes.hOldBrush); \
  (void) DeleteObject(w->cubes.hBrush); \
  (void) SelectObject(DC(w,dr),w->cubes.hOldPen); \
  (void) DeleteObject(w->cubes.hPen); \
  if (dr) (void) SelectObject(w->cubes.memDC,w->cubes.hOldBitmap)
#define DRAWTEXT(w,dr,c,x,y,s,l) \
  if (dr) w->cubes.hOldBitmap = (HBITMAP) SelectObject(w->cubes.memDC,dr); \
  (void) SetTextColor(DC(w,dr), c); \
  (void) SetBkMode(DC(w,dr), TRANSPARENT); \
  (void) TextOut(DC(w,dr), (x)-3, (y)-11, (LPCSTR) s, l); \
  if (dr) (void) SelectObject(w->cubes.memDC,w->cubes.hOldBitmap)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyCubes(HBRUSH brush);
extern void ResizeCubes(CubesWidget w);
extern void SizeCubes(CubesWidget w);
extern void InitializeCubes(CubesWidget w, HBRUSH brush);
extern void ExposeCubes(const CubesWidget w);
extern void HideCubes(const CubesWidget w);
extern void SelectCubes(CubesWidget w, const int x, const int y);
extern void ReleaseCubes(CubesWidget w);
extern void RandomizeCubes(CubesWidget w);
extern void ClearCubes(CubesWidget w);
extern void GetCubes(CubesWidget w);
extern void WriteCubes(CubesWidget w);
extern void UndoCubes(CubesWidget w);
extern void SolveCubes(CubesWidget w);
extern void SpeedCubes(CubesWidget w);
extern void SlowCubes(CubesWidget w);
extern void SoundCubes(CubesWidget w);
extern void EnterCubes(CubesWidget w);
extern void LeaveCubes(CubesWidget w);
extern int MoveCubes(CubesWidget w, const int direction, const int control);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>
#include "Cubes.h"

#ifdef VMS
#ifndef BUMPSOUND
#define BUMPSOUND "[.]bump.au"
#endif
#ifndef DRIPSOUND
#define DRIPSOUND "[.]drip.au"
#endif
#else
#ifndef BUMPSOUND
#if 0
#define BUMPSOUND "/usr/local/share/games/xpuzzles/bump.au"
#endif
#define BUMPSOUND "/usr/share/games/xpuzzles/bump.au"
#endif
#ifndef DRIPSOUND
#if 0
#define DRIPSOUND "/usr/local/share/games/xpuzzles/drip.au"
#endif
#define DRIPSOUND "/usr/share/games/xpuzzles/drip.au"
#endif
#endif

#ifndef Pos
#define Pos Position
#endif
#ifndef Point
#define Point XPoint
#endif
#define DR(w,dr) ((dr==0)?XtWindow(w):dr)
#define DRAWRECTANGLE(w,dr,c,i,j,l,h) XDrawRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define FILLRECTANGLE(w,dr,c,i,j,l,h) XFillRectangle(XtDisplay(w),DR(w,dr),\
  c,i,j,l,h)
#define DRAWTEXT(w,dr,c,x,y,s,l) (void) XDrawString(XtDisplay(w),DR(w,dr),\
  c,x,y,s,l)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _CubesClassPart {
	int         ignore;
} CubesClassPart;

typedef struct _CubesClassRec {
	CoreClassPart core_class;
	CubesClassPart cubes_class;
} CubesClassRec;

extern CubesClassRec cubesClassRec;
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define INWARDS 4
#define OUTWARDS 5
#define COORD 6

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srandom
#define LRAND random
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand
#define LRAND rand
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _CubesPart {
	int        *blockOfPosition, spacePosition;
	int         currentPosition, currentRow[3];
	Boolean     started, cheat, sound;
	Boolean     vertical, mono, reverse, focus;
	int         delay, numSlices;
	int         base;
	int         sizeX, sizeY, sizeZ, sizeRect, sizeBlock;
	Point       offset;
	Point       blockSize, faceSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          blockGC, blockBrighterGC, blockDarkerGC;
	Pixmap      bufferBlocks[2];
#ifdef WINVER
	long        oldTime;
	char        username[81], bumpSound[81], dripSound[81], picture[81];
	HDC         memDC;
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
	HBITMAP     hOldBitmap;
#else
	struct timeval oldTime;
	char       *username, *bumpSound, *dripSound, *picture, *font;
	int         menu, graphicsFormat;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage	   *image;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, blockColor, borderColor;
	XtCallbackList select;
#endif
} CubesPart;

typedef struct _CubesRec {
	CorePart    core;
	CubesPart   cubes;
} CubesRec;

extern int *startPosition;
extern void SetCubes(CubesWidget w, int reason);
extern int  MoveCubesDir(CubesWidget w, const int direction, const int fast);
extern void AnimateSlide(CubesWidget w, int numBlocks, int direction, int fast,
	Boolean logMoves);

extern void SolveSomeBlocks(CubesWidget w);
extern void DrawAllBlocks(const CubesWidget w);
extern Boolean CheckSolved(const CubesWidget w);
extern void InitMoves(void);
extern void PutMove(int direction);
extern void GetMove(int *direction);
extern int  MadeMoves(void);
extern void FlushMoves(CubesWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, CubesWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, CubesWidget w);
extern void PrintStartPosition(FILE * fp, CubesWidget w);
extern void SetStartPosition(CubesWidget w);

#endif /* _CubesP_h */
