/*-
# X-BASED DINOSAUR CUBE
#
#  Dino.h
#
###
#
#  Copyright (c) 1995 - 2003	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Dino */

#ifndef _XtDino_h
#define _XtDino_h

/***********************************************************************
 *
 * Dino Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNface ((char *) "face")
#define XtNpos ((char *) "position")
#define XtNdirection ((char *) "direction")
#define XtNstyle ((char *) "style")
#define XtNpractice ((char *) "practice")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtNfaceColor4 ((char *) "faceColor4")
#define XtNfaceColor5 ((char *) "faceColor5")
#define XtCUserName ((char *) "UserName")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCFace ((char *) "Face")
#define XtCPos ((char *) "Position")
#define XtCDirection ((char *) "Direction")
#define XtCStyle ((char *) "Style")
#define XtCMenu ((char *) "Menu")

typedef struct _DinoClassRec *DinoWidgetClass;

extern WidgetClass dinoWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
	int         face, position, direction, style;
} dinoCallbackStruct;
#endif

#define DINO_HIDE (-9)
#define DINO_PRACTICE_QUERY (-8)
#define DINO_RANDOMIZE_QUERY (-7)
#define DINO_SOLVE_MESSAGE (-6)
#define DINO_RESTORE (-5)
#define DINO_CLEAR (-4)
#define DINO_RESET (-3)
#define DINO_ILLEGAL (-2)
#define DINO_IGNORE (-1)
#define DINO_MOVED 0
#define DINO_CONTROL 1
#define DINO_SOLVED 2
#define DINO_PRACTICE 3
#define DINO_RANDOMIZE 4
#define DINO_DEC 5
#define DINO_ORIENT 6
#define DINO_INC 7
#define DINO_PERIOD2 8
#define DINO_PERIOD3 9
#define DINO_BOTH 10
#define DINO_COMPUTED 11
#define DINO_UNDO 12
#define DINO_DIM 13

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define PERIOD2 2
#define PERIOD3 3
#define BOTH 4
#define MAXMODES 3
#define MAXFACES 6
#define DEFAULTMODE PERIOD3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _DinoRec *DinoWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtDino_h */
/* DON'T ADD STUFF AFTER THIS #endif */
