/*-
# X-BASED MASTERBALL(tm)
#
#  MballP.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Mball */

#ifndef _MballP_h
#define _MballP_h

#define NUM_DEGREES 360
#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Mball.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)          /* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define FULLCIRCLE NUM_DEGREES

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define ARC(w,x,y,l,h,a1,a2) if (a2 > 0) Arc(w->core.hDC,x,y,x+l,y+h, \
  (int) (cos(M_PI * (a1) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1) / 180) * (h) + y + ((h)>>1)), \
  (int) (cos(M_PI * (a1+a2) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1+a2) / 180) * (h) + y + ((h)>>1))); \
  else Arc(w->core.hDC,x,y,x+l,y+h, \
  (int) (cos(M_PI * (a1+a2) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1+a2) / 180) * (h) + y + ((h)>>1)), \
  (int) (cos(M_PI * (a1) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1) / 180) * (h) + y + ((h)>>1)))
#define DRAWRECTANGLE(w,c,x,y,l,h) w->mball.hPen = CreatePen(PS_SOLID, 1, c); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->mball.hPen = CreatePen(PS_SOLID, 1, c); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  w->mball.hBrush = CreateSolidBrush(c); \
  w->mball.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->mball.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->mball.hOldBrush); \
  (void) DeleteObject(w->mball.hBrush); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define DRAWLINE(w,c,x1,y1,x2,y2) w->mball.hPen = CreatePen(PS_SOLID, 1, c); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  LINE(w,x1,y1,x2,y2); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->mball.hPen = CreatePen(PS_SOLID, 1, c); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->mball.hPen = CreatePen(PS_SOLID, 1, c); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  w->mball.hBrush = CreateSolidBrush(c); \
  w->mball.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->mball.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->mball.hOldBrush); \
  (void) DeleteObject(w->mball.hBrush); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define DRAWARC(w,c,t,x,y,l,h,a1,a2) w->mball.hPen = \
  CreatePen(PS_SOLID, t, c); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  ARC(w,x,y,l,h,a1,a2); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define DRAWARC2(w,c,t,x,y,l,h,a1,a2) lb.lbStyle = BS_SOLID; \
  lb.lbColor = c; lb.lbHatch = 0; w->mball.hPen = \
  ExtCreatePen(PS_GEOMETRIC | PS_SOLID | PS_ENDCAP_FLAT, (unsigned int) t, \
  &lb, 0, NULL); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  ARC(w,x,y,l,h,a1,a2); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define PIE(w,x,y,l,h,a1,a2) if (a2 > 0) Pie(w->core.hDC,x,y,x+l,y+h, \
  (int) (cos(M_PI * (a1) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1) / 180) * (h) + y + ((h)>>1)), \
  (int) (cos(M_PI * (a1+a2) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1+a2) / 180) * (h) + y + ((h)>>1))); \
  else Pie(w->core.hDC,x,y,x+l,y+h, \
  (int) (cos(M_PI * (a1+a2) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1+a2) / 180) * (h) + y + ((h)>>1)), \
  (int) (cos(M_PI * (a1) / 180) * (l) + x + ((l)>>1)), \
  (int) (-sin(M_PI * (a1) / 180) * (h) + y + ((h)>>1)))
#define DRAWPIE(w,c,x,y,l,h,a1,a2) w->mball.hPen = CreatePen(PS_SOLID, 1, c); \
  w->mball.hOldPen = (HPEN) SelectObject(w->core.hDC, w->mball.hPen); \
  w->mball.hBrush = CreateSolidBrush(c); \
  w->mball.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->mball.hBrush); \
  PIE(w,x,y,l,h,a1,a2); \
  (void) SelectObject(w->core.hDC, w->mball.hOldBrush); \
  (void) DeleteObject(w->mball.hBrush); \
  (void) SelectObject(w->core.hDC, w->mball.hOldPen); \
  (void) DeleteObject(w->mball.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyMball(HBRUSH brush);
extern void ResizeMball(MballWidget w);
extern void SizeMball(MballWidget w);
extern void InitializeMball(MballWidget w, HBRUSH brush);
extern void ExposeMball(const MballWidget w);
extern void HideMball(const MballWidget w);
extern void SelectMball(MballWidget w,
	const int x, const int y, const int shift);
extern void ReleaseMball(MballWidget w,
	const int x, const int y, const int shift);
extern void PracticeMball(MballWidget w);
extern void PracticeMballMaybe(MballWidget w);
extern void PracticeMball2(MballWidget w);
extern void RandomizeMball(MballWidget w);
extern void RandomizeMballMaybe(MballWidget w);
extern void RandomizeMball2(MballWidget w);
extern void ClearMball(MballWidget w);
extern void GetMball(MballWidget w);
extern void WriteMball(MballWidget w);
extern void UndoMball(MballWidget w);
extern void SolveMball(MballWidget w);
extern void IncrementMball(MballWidget w);
extern Boolean DecrementMball(MballWidget w);
extern void WedgeMball(MballWidget w, const int mode);
extern void Wedge2ModeMball(MballWidget w);
extern void Wedge4ModeMball(MballWidget w);
extern void Wedge6ModeMball(MballWidget w);
extern void Wedge8ModeMball(MballWidget w);
extern void Wedge10ModeMball(MballWidget w);
extern void Wedge12ModeMball(MballWidget w);
extern void OrientizeMball(MballWidget w);
extern void MiddleMball(MballWidget w);
extern void EnterMball(MballWidget w);
extern void LeaveMball(MballWidget w);
extern void MoveMballInput(MballWidget w,
	int x, int direction, int shift, int control);
extern int  MoveMballDir(MballWidget w, const int direction);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Mball.h"

#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DRAWLINE(w,c,i,j,k,l) XDrawLine(XtDisplay(w),XtWindow(w),\
  c,i,j,k,l)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWARC(w,c,t,x,y,l,h,a1,a2) \
  if(t>1)XSetLineAttributes(XtDisplay(w),c,t,LineSolid,CapNotLast,JoinRound);\
  XDrawArc(XtDisplay(w),XtWindow(w),c,x,y,l,h,(a1)*MULT,(a2)*MULT);\
  if(t>1)XSetLineAttributes(XtDisplay(w),c,1,LineSolid,CapNotLast,JoinRound)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
  c,x,y,s,l)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _MballClassPart {
	int         ignore;
} MballClassPart;

typedef struct _MballClassRec {
	CoreClassPart core_class;
	MballClassPart mball_class;
} MballClassRec;

extern MballClassRec mballClassRec;
#endif

#define SYMBOL ':'

#define TOP 0
#define TTR 1
#define TR 2
#define RIGHT 3
#define BR 4
#define BBR 5
#define BOTTOM 6
#define BBL 7
#define BL 8
#define LEFT 9
#define TL 10
#define TTL 11
#define COORD 12
#define CW 13
#define CCW 23
#define CUTS (COORD / 2)
#define SAME 0
#define OPPOSITE 1
#define DOWN 0
#define UP 1
#define MAXVIEWS 2

#define ST_ANG  (NUM_DEGREES/2)
#define RT_ANG  (NUM_DEGREES/4)
#define DEGREES(x) ((x)/M_PI*(double)ST_ANG)
#define RADIANS(x) (M_PI*(x)/(double)ST_ANG)
#define CIRCLE_2  (FULLCIRCLE/2)
#define CIRCLE_4  (FULLCIRCLE/4)

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand48
#define LRAND lrand48
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _MballLoc {
	int         wedge, direction;
} MballLoc;

typedef struct _MballPart {
	MballLoc   *mballLoc[MAXWEDGES];
	int         currentWedge, currentRing;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	int         base;
	int         wedges, rings;
	Position    delta, dr;
	Position    mballLength;
	Position    wedgeLength;
	Position    viewLength, viewMiddle;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          wedgeGC[MAXWEDGES];
#ifdef WINVER
	char        username[81];
	char        wedgeChar[MAXWEDGES];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
#else
	int         menu;
	char       *username, *font;
	XFontStruct *fontInfo;
	char       *wedgeName[MAXWEDGES];
	Pixel       foreground, background;
        Pixel       frameColor, borderColor;
	Pixel       wedgeColor[MAXWEDGES];
	XtCallbackList select;
#endif
} MballPart;

typedef struct _MballRec {
	CorePart    core;
	MballPart   mball;
} MballRec;

extern MballLoc *startLoc[MAXWEDGES];
extern void SetMball(MballWidget w, int reason);
extern void MoveMball(MballWidget w, const int wedge, const int ring,
	const int direction, const int control);

#if 0
/* For future auto-solver */
extern void SolveWedges(MballWidget w);

#endif
extern void DrawAllWedges(MballWidget w);
extern Boolean CheckSolved(MballWidget w);
extern void InitMoves(void);
extern void PutMove(int wedge, int ring, int direction, int control);
extern void GetMove(int *wedge, int *ring, int *direction, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(MballWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, MballWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, MballWidget w);
extern void PrintStartPosition(FILE * fp, MballWidget w);
extern void SetStartPosition(MballWidget w);

#endif /* _MballP_h */
