/*-
# X-BASED PANEX(tm)
#
#  PanexP.h
#
###
#
#  Copyright (c) 1996 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Panex */

#ifndef _PanexP_h
#define _PanexP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "Panex.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)          /* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) w->panex.hPen = CreatePen(PS_SOLID, 1, c); \
  w->panex.hOldPen = (HPEN) SelectObject(w->core.hDC, w->panex.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->panex.hOldPen); \
  (void) DeleteObject(w->panex.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->panex.hPen = CreatePen(PS_SOLID, 1, c); \
  w->panex.hOldPen = (HPEN) SelectObject(w->core.hDC, w->panex.hPen); \
  w->panex.hBrush = CreateSolidBrush(c); \
  w->panex.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->panex.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->panex.hOldBrush); \
  (void) DeleteObject(w->panex.hBrush); \
  (void) SelectObject(w->core.hDC, w->panex.hOldPen); \
  (void) DeleteObject(w->panex.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->panex.hPen = CreatePen(PS_SOLID, 1, c); \
  w->panex.hOldPen = (HPEN) SelectObject(w->core.hDC, w->panex.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->panex.hOldPen); \
  (void) DeleteObject(w->panex.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->panex.hPen = CreatePen(PS_SOLID, 1, c); \
  w->panex.hOldPen = (HPEN) SelectObject(w->core.hDC, w->panex.hPen); \
  w->panex.hBrush = CreateSolidBrush(c); \
  w->panex.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->panex.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->panex.hOldBrush); \
  (void) DeleteObject(w->panex.hBrush); \
  (void) SelectObject(w->core.hDC, w->panex.hOldPen); \
  (void) DeleteObject(w->panex.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyPanex(HBRUSH brush);
extern void ResizePanex(PanexWidget w);
extern void SizePanex(PanexWidget w);
extern void InitializePanex(PanexWidget w, HBRUSH brush);
extern void ExposePanex(const PanexWidget w);
extern void HidePanex(const PanexWidget w);
extern void SelectPanex(PanexWidget w, const int x);
extern void ReleasePanex(PanexWidget w, const int x);
extern void ClearPanex(PanexWidget w);
extern void GetPanex(PanexWidget w);
extern void WritePanex(PanexWidget w);
extern void UndoPanex(PanexWidget w);
extern void SolvePanex(PanexWidget w);
extern void ModePanex(PanexWidget w);
extern void DecrementPanex(PanexWidget w);
extern void IncrementPanex(PanexWidget w);
extern void EnterPanex(PanexWidget w);
extern void LeavePanex(PanexWidget w);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Panex.h"

#ifndef Point
#define Point XPoint
#endif
#define NUM_DEGREES 360
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
  c,x,y,s,l)
#define POLYGON(w,c,lc,l,n,o) XFillPolygon(XtDisplay(w), XtWindow(w), c, \
  l, n, Convex, (o) ? CoordModeOrigin : CoordModePrevious); \
  XDrawLines(XtDisplay(w), XtWindow(w), lc, \
  l, (n)+1,(o) ? CoordModeOrigin : CoordModePrevious)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _PanexClassPart {
	int         ignore;
} PanexClassPart;

typedef struct _PanexClassRec {
	CoreClassPart core_class;
	PanexClassPart panex_class;
} PanexClassRec;

extern PanexClassRec panexClassRec;
#endif

#define SYMBOL ':'

#define MAXSTACKS 3
#define UP 1
#define DOWN 0

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srandom
#define LRAND lrandom
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand
#define LRAND lrand
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _PanexLoc {
	int         stack, loc;
} PanexLoc;

typedef struct _PanexPart {
	PanexLoc   *tileOfPosition[MAXSTACKS];
	PanexLoc   *positionOfTile[MAXSTACKS];
	int         currentStack, currentPosition;
	Boolean     started, cheat;
	Boolean     mono, reverse, focus;
	int         mode, tiles;
	int         delay;
	Position    width, height;
	Point       tileSize, pos;
	Point       delta, puzzleOffset, letterOffset;
	GC          pyramidGC[MAXSTACKS - 1];
	GC          frameGC, stackGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
#ifdef WINVER
	char        username[81];
	char        pyramidChar[MAXSTACKS - 1];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
#else
	int         menu;
	char       *username, *font;
	XFontStruct *fontInfo;
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	Pixel       pyramidColor[MAXSTACKS - 1];
	String      pyramidName[MAXSTACKS - 1];
	XtCallbackList select;
#endif
} PanexPart;

typedef struct _PanexRec {
	CorePart    core;
	PanexPart   panex;
} PanexRec;

extern PanexLoc *startLoc[MAXSTACKS - 1];
extern void SetPanex(PanexWidget w, int reason);
extern int  MovePanex(PanexWidget w, int fromStack, int fromPosition,
	int toStack);

extern void SolveTilesFromStart(PanexWidget w);
extern void DrawAllTiles(PanexWidget w);
extern int  TopOfStack(PanexWidget w, int stack);
extern Boolean CheckMiddle(PanexWidget w);
extern Boolean CheckSolved(PanexWidget w);
extern void InitMoves(void);
extern void PutMove(int from, int to);
extern void GetMove(int *from, int *to);
extern int  MadeMoves(void);
extern void FlushMoves(PanexWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, PanexWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, PanexWidget w);
extern void PrintStartPosition(FILE * fp, PanexWidget w);
extern void SetStartPosition(PanexWidget w);

#endif /* _PanexP_h */
