/*
# X-BASED THREED
#
#  Threed.h
#
###
#
#  Copyright (c) 1994 - 2003	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Threed */

#ifndef _XtThreed_h
#define _XtThreed_h

/***********************************************************************
 *
 * 3D Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNdistance ((char *) "distance")
#define XtNthetaDegrees ((char *) "thetaDegrees")
#define XtNphiDegrees ((char *) "phiDegrees")
#define XtNsurface ((char *) "surface")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNobject ((char *) "object")
#define XtNobjectName ((char *) "objectName")
#define XtNobjectNumber ((char *) "objectNumber")
#define XtNobjectList ((char *) "objectList")
#define XtNanotherBrush ((char *) "anotherBrush")
#define XtNblackBrush ((char *) "blackBrush")
#define XtNdkgrayBrush ((char *) "dkgrayBrush")
#define XtNgrayBrush ((char *) "grayBrush")
#define XtNltgrayBrush ((char *) "ltgrayBrush")
#define XtNwhiteBrush ((char *) "whiteBrush")
#define XtNbuffer ((char *) "Buffer")
#define XtCDistance ((char *) "Distance")
#define XtCThetaDegrees ((char *) "ThetaDegrees")
#define XtCPhiDegrees ((char *) "PhiDegrees")
#define XtCSurface ((char *) "Surface")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCObject ((char *) "Object")
#define XtCObjectName ((char *) "ObjectName")
#define XtCObjectNumber ((char *) "ObjectNumber")
#define XtCObjectList ((char *) "ObjectList")
#define XtCBuffer ((char *) "Buffer")

typedef struct _ThreeDClassRec *ThreeDWidgetClass;

extern WidgetClass threedWidgetClass;

typedef struct {
  int reason;
  XEvent *event;
  char message[81];
} threedCallbackStruct;
#endif

#define THREED_HIDE (-1) 
#define THREED_SET 0
#define THREED_SURFACE 1
#define THREED_OBJECT 2

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _ThreeDRec *ThreeDWidget;

extern void intCat(char ** string, const char * var1, const int var2);
#if 0
extern void stringCat(char ** string, const char * var1, const char * var2);
#endif

#endif /* _XtThreed_h */
/* DON'T ADD STUFF AFTER THIS #endif */
