/*
# X-BASED THREED
#
#  ThreedP.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "useful",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Threed */

#ifndef _ThreedP_h
#define _ThreedP_h

#define NUMDEGREES 360

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Threed.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)          /* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) w->threed.hPen = \
  CreatePen(PS_SOLID, 1, c); \
  w->threed.hOldPen = (HPEN) SelectObject(w->core.hDC, w->threed.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->threed.hPen = \
  CreatePen(PS_SOLID, 1, c); \
  w->threed.hOldPen = (HPEN) SelectObject(w->core.hDC, w->threed.hPen); \
  w->threed.hBrush = CreateSolidBrush(c); \
  w->threed.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->threed.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->threed.hOldBrush); \
  (void) DeleteObject(w->threed.hBrush); \
  (void) SelectObject(w->core.hDC, w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->threed.hPen = CreatePen(PS_SOLID, 1, c); \
  w->threed.hOldPen = (HPEN) SelectObject(w->core.hDC, w->threed.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->threed.hPen = CreatePen(PS_SOLID, 1, c); \
  w->threed.hOldPen = (HPEN) SelectObject(w->core.hDC, w->threed.hPen); \
  w->threed.hBrush = CreateSolidBrush(c); \
  w->threed.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, w->threed.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->threed.hOldBrush); \
  (void) DeleteObject(w->threed.hBrush); \
  (void) SelectObject(w->core.hDC, w->threed.hOldPen); \
  (void) DeleteObject(w->threed.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
		  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyThreeD(HBRUSH brush);
extern void InitializeThreeD(ThreeDWidget w, HBRUSH brush);
extern void ExposeThreeD(const ThreeDWidget w);
extern void HideThreeD(const ThreeDWidget w);
extern void SetSurfaceThreeD(ThreeDWidget w, int surface);
extern void SetObjectThreeD(ThreeDWidget w, int object3D);
extern void SetThreeD(ThreeDWidget w, int reason);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Threed.h"

#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUMDEGREES*MULT)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
  c,x,y,s,l)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _ThreeDClassPart {
  int ignore;
} ThreeDClassPart;

typedef struct _ThreeDClassRec {
  CoreClassPart core_class;
  ThreeDClassPart threed_class;
} ThreeDClassRec;

extern ThreeDClassRec threedClassRec;
#endif

#define SYMBOL '='

#define VIEWRATIO 4.0
#define MINDISTANCE 0
#define MAXDISTANCE 200
#define DELTADISTANCE 5
#define DELTADEGREES 5
#define MINDEGREES 0
#define MAXDEGREES (NUMDEGREES-1)
#define COLORS 6
#define WHITE_BRUSH 0
#define LTGRAY_BRUSH 1
#define GRAY_BRUSH 2
#define DKGRAY_BRUSH 3
#define BLACK_BRUSH 4
#define ANOTHER_BRUSH 5
#define HIDDENSURFACEREMOVAL True
#define WIREFRAME False

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

typedef struct _Point3D {
  double x, y, z;
} Point3D;

typedef struct _Vertex {
  Point3D eye;
  Point screen;
} Vertex;

typedef struct _Surface {
  int mapIndex, numVertices, depthIndex, brushColor;
} Surface;

typedef struct _Box
{
  char name[81];
  int numVertices, numSurfaces, numSurfaceVertices;
  Point3D *world; /* Vertex Array */
  Surface *info; /* Points to Surface Map */
  int *map; /* Points to Vertex Array */
  Vertex *vertex; /* Vertex Array */
} Object3D;

typedef struct _ThreeDPart {
  int distance, thetaDegrees, phiDegrees;
  Boolean mono, reverse, surface;
  int object, numObjects;
  char *name;
  char **list;
  Object3D *objects;
  Position size;
  Point center;
  GC graphicsGC, inverseGC;
  GC shadeGC[COLORS];
#ifdef WINVER
  HPEN hOldPen, hPen;
  HBRUSH hOldBrush, hBrush;
#else
  Pixel foreground;
  Pixel shadeColor[COLORS];
  XtCallbackList select;
#endif
} ThreeDPart;

typedef struct _ThreeDRec {
  CorePart core;
  ThreeDPart threed;
} ThreeDRec;

#endif /* _ThreedP_h */
