#define ANIMATE 1
/*-
# X-BASED TRIANGLES
#
#  Triangles.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Triangles */

#ifndef _XtTriangles_h
#define _XtTriangles_h

/***********************************************************************
 *
 * Triangles Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNsize ((char *) "size")
#define XtNbase ((char *) "base")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNmoveSound ((char *) "moveSound")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNtileColor ((char *) "tileColor")
#define XtNtileBorder ((char *) "tileBorder")
#define XtCUserName ((char *) "UserName")
#define XtCSize ((char *) "Size")
#define XtCBase ((char *) "Base")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCMoveSound ((char *) "MoveSound")
#define XtCMenu ((char *) "Menu")

typedef struct _TrianglesClassRec *TrianglesWidgetClass;

extern WidgetClass trianglesWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} trianglesCallbackStruct;
#endif

#define TRIANGLES_HIDE (-8)
#define TRIANGLES_RANDOMIZE_QUERY (-7)
#define TRIANGLES_SOLVE_MESSAGE (-6)
#define TRIANGLES_RESTORE (-5)
#define TRIANGLES_RESET (-4)
#define TRIANGLES_BLOCKED (-3)
#define TRIANGLES_SPACE (-2)
#define TRIANGLES_IGNORE (-1)
#define TRIANGLES_MOVED 0
#define TRIANGLES_SOLVED 1
#define TRIANGLES_PRACTICE 2
#define TRIANGLES_RANDOMIZE 3
#define TRIANGLES_DEC 4
#define TRIANGLES_INC 5
#define TRIANGLES_COMPUTED 6
#define TRIANGLES_UNDO 7
#define TRIANGLES_SPEED 8

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define MINTILES 1
#define DEFAULTTILES 4
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

typedef struct _TrianglesRec *TrianglesWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtTriangles_h */
/* DON'T ADD STUFF AFTER THIS #endif */
