/*-
# X-BASED OCTAHEDRON
#
#  OctP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Oct */

#ifndef _OctP_h
#define _OctP_h

#include "xwin.h"
#include "timer.h"
#include "Oct.h"

#ifdef WINVER
extern void DestroyOct(HBRUSH brush);
extern void ResizeOct(OctWidget w);
extern void SizeOct(OctWidget w);
extern void InitializeOct(OctWidget w, HBRUSH brush);
extern void ExposeOct(OctWidget w);
extern void HideOct(OctWidget w);
extern void SelectOct(OctWidget w,
	const int x, const int y, const int control);
extern void ReleaseOct(OctWidget w,
	const int x, const int y, const int shift, const int control);
extern void PracticeOct(OctWidget w);
extern void PracticeOctMaybe(OctWidget w);
extern void PracticeOct2(OctWidget w);
extern void RandomizeOct(OctWidget w);
extern void RandomizeOctMaybe(OctWidget w);
extern void RandomizeOct2(OctWidget w);
extern void ClearOct(OctWidget w);
extern void GetOct(OctWidget w);
extern void WriteOct(OctWidget w);
extern void UndoOct(OctWidget w);
extern void SolveOct(OctWidget w);
extern void IncrementOct(OctWidget w);
extern Boolean DecrementOct(OctWidget w);
extern void OrientizeOct(OctWidget w);
extern void StickyModeOct(OctWidget w);
extern void PeriodModeOct(OctWidget w, const int mode);
extern void Period3ModeOct(OctWidget w);
extern void Period4ModeOct(OctWidget w);
extern void BothModeOct(OctWidget w);
extern void EnterOct(OctWidget w);
extern void LeaveOct(OctWidget w);
extern void MoveOctInput(OctWidget w,
	int x, int y, int direction, int shift, int control);
extern int  MoveOctDir(OctWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _OctClassPart {
	int         ignore;
} OctClassPart;

typedef struct _OctClassRec {
	CoreClassPart coreClass;
	OctClassPart octClass;
} OctClassRec;

extern OctClassRec octClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define TR 1
#define RIGHT 2
#define BR 3
#define BOTTOM 4
#define BL 5
#define LEFT 6
#define TL 7
#define COORD 8
#define CW 9
#define CCW 15

#define MAXFACES 8
#define SAME 0
#define OPPOSITE 1
#define UP 1
#define DOWN 0
#define MAXVIEWS 2
#define MAXSIDES (MAXFACES/MAXVIEWS)
#define MAXORIENT (3*MAXSIDES)

typedef struct _OctLoc {
	int         face, rotation;
} OctLoc;

typedef struct _OctPart {
	OctLoc     *facetLoc[MAXFACES];
	OctLoc     *faceLoc;
	OctLoc     *rowLoc[MAXORIENT / 2];
	int         currentFace, currentPosition;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, sticky, focus;
	Boolean     scoreOnly, versionOnly;
	int         size, sizeSize, mode;
	Position    delta;
	Position    facetLength;
	Position    faceLength;
	Position    viewLength, viewMiddle;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} OctPart;

typedef struct _OctRec {
	CorePart    core;
	OctPart     oct;
} OctRec;

extern OctLoc *startLoc[MAXFACES];
extern void SetOct(OctWidget w, int reason);
extern void MoveOct(OctWidget w, int face, int position, int direction, int style, int control);

#if 0
/* For future auto-solver */
extern void SolvePolyhedrons(OctWidget w);

#endif
extern void DrawAllPieces(OctWidget w);
extern Boolean CheckSolved(OctWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int style, int control);
extern void GetMove(int *face, int *position, int *direction, int *style, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(OctWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, OctWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, OctWidget w);
extern void PrintStartPosition(FILE * fp, OctWidget w);
extern void SetStartPosition(OctWidget w);

#endif /* _OctP_h */
