/*-
# X-BASED DINOSAUR CUBE
#
#  DinoP.h
#
###
#
#  Copyright (c) 1995 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Dino */

#ifndef _DinoP_h
#define _DinoP_h

#include "xwin.h"
#include "timer.h"
#include "Dino.h"

#ifdef WINVER
extern void DestroyDino(HBRUSH brush);
extern void ResizeDino(DinoWidget w);
extern void SizeDino(DinoWidget w);
extern void InitializeDino(DinoWidget w, HBRUSH brush);
extern void ExposeDino(DinoWidget w);
extern void PeriodModeDino(DinoWidget w, const int mode);
extern void DimDino(DinoWidget w);
extern int  MoveDinoDir(DinoWidget w, const int direction);
extern void SetDino(DinoWidget w, int reason);
extern void SetDinoMove(DinoWidget w, int reason, int face, int position,
	int direction, int style);

#else

/* This gets around C's inability to do inheritance */
typedef struct _DinoClassPart {
	int         ignore;
} DinoClassPart;

typedef struct _DinoClassRec {
	CoreClassPart coreClass;
	DinoClassPart dinoClass;
} DinoClassRec;

extern DinoClassRec dinoClassRec;

extern void QuitDino(DinoWidget w, XEvent * event, char **args, int nArgs);
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAXORIENT 4
#define MAXROTATE 3
#define CORNER 0
#define MIDDLE 1
#define EDGE 2
#define FACE 3

typedef struct _DinoLoc {
	int         face, side, dir;
} DinoLoc;

typedef struct _DinoCornerLoc {
	int         face, rotation;
} DinoCornerLoc;

typedef struct _DinoPart {
	DinoCornerLoc cubeLoc[MAXFACES][MAXORIENT];
	DinoCornerLoc faceLoc[MAXORIENT];
	DinoCornerLoc rowLoc[MAXORIENT][MAXORIENT];
	DinoCornerLoc spindleLoc[MAXROTATE][2];
	int         currentFace, currentPosition, currentDirection;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         mode, style;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} DinoPart;

typedef struct _DinoRec {
	CorePart    core;
	DinoPart    dino;
} DinoRec;

typedef struct _RowNext {
	int         face, direction, side_face;
} RowNext;

extern void HideDino(
#ifdef WINVER
const DinoWidget w
#else
DinoWidget w, XEvent * event, char **args, int nArgs
#endif
);
extern void SelectDino(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int control
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void ReleaseDino(DinoWidget w
#ifdef WINVER
, const int x, const int y, const int shift, const int control, const int alt
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void PracticeDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticeDinoMaybe(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void PracticeDino2(DinoWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void RandomizeDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void RandomizeDinoMaybe(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void RandomizeDino2(DinoWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void GetDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void WriteDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void ClearDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void UndoDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void SolveDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void OrientizeDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void EnterDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void LeaveDino(DinoWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void Period2ModeDino(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void Period3ModeDino(DinoWidget w
, XEvent * event, char **args, int nArgs
);
extern void BothModeDino(DinoWidget w
, XEvent * event, char **args, int nArgs
);
#endif

extern void MoveDinoInput(DinoWidget w, int x, int y, int direction, int shift,
	int control, int alt);
extern void MoveDino(DinoWidget w, int face, int position, int direction,
	int style, int control);
extern void SetAllColors(DinoWidget w);
#if 0
/* For future auto-solver */
extern void SolvePieces(DinoWidget w);

#endif
extern void DrawAllPieces(DinoWidget w);
extern Boolean CheckSolved(DinoWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int style,
	int control);
extern void GetMove(int *face, int *position, int *direction, int *style,
	int *control);
extern int  MadeMoves(void);
extern void FlushMoves(DinoWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, DinoWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, DinoWidget w);
extern void PrintStartPosition(FILE * fp, DinoWidget w);
extern void SetStartPosition(DinoWidget w);

#ifdef DEBUG
extern void PrintCube(DinoWidget w);

#endif

#endif /* _DinoP_h */
